/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.cancelables.CompositeCancelable$;
import monix.execution.cancelables.MultiAssignCancelable;
import monix.execution.cancelables.MultiAssignCancelable$;
import monix.reactive.Observable;
import monix.reactive.internal.operators.BufferTimedObservable$;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class BufferTimedObservable<A>
extends Observable<Seq<A>> {
    private final Observable<A> source;
    public final FiniteDuration monix$reactive$internal$operators$BufferTimedObservable$$timespan;
    public final int monix$reactive$internal$operators$BufferTimedObservable$$maxCount;

    public <A> BufferTimedObservable(Observable<A> source, FiniteDuration timespan, int maxCount) {
        this.source = source;
        this.monix$reactive$internal$operators$BufferTimedObservable$$timespan = timespan;
        this.monix$reactive$internal$operators$BufferTimedObservable$$maxCount = maxCount;
        Predef$.MODULE$.require(timespan.$greater((Object)Duration$.MODULE$.Zero()), BufferTimedObservable::$init$$$anonfun$1);
        Predef$.MODULE$.require(maxCount >= 0, BufferTimedObservable::$init$$$anonfun$2);
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<Seq<A>> out) {
        MultiAssignCancelable periodicTask = MultiAssignCancelable$.MODULE$.apply();
        Cancelable connection = this.source.unsafeSubscribeFn(new Subscriber<A>(out, periodicTask, this){
            private final Subscriber out$1;
            private final MultiAssignCancelable periodicTask$1;
            private final Scheduler scheduler;
            private final long timespanMillis;
            private Future ack;
            private ListBuffer buffer;
            private long expiresAt;
            private final BufferTimedObservable $outer;
            {
                this.out$1 = out$1;
                this.periodicTask$1 = periodicTask$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.scheduler = out$1.scheduler();
                this.timespanMillis = $outer.monix$reactive$internal$operators$BufferTimedObservable$$timespan.toMillis();
                this.ack = Ack.Continue$.MODULE$;
                this.buffer = ListBuffer$.MODULE$.empty();
                this.expiresAt = this.scheduler().clockMonotonic(package$.MODULE$.MILLISECONDS()) + this.timespanMillis;
                Predef$.MODULE$.locally((Object)periodicTask$1.$colon$eq(out$1.scheduler().scheduleOnce(this.timespanMillis, TimeUnit.MILLISECONDS, (Runnable)this)));
            }

            public Scheduler scheduler() {
                return this.scheduler;
            }

            public void run() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    BoxedUnit boxedUnit;
                    long now = this.scheduler().clockMonotonic(package$.MODULE$.MILLISECONDS());
                    if (now < this.expiresAt) {
                        long remaining = this.expiresAt - now;
                        boxedUnit = this.periodicTask$1.$colon$eq(this.scheduler().scheduleOnce(remaining, TimeUnit.MILLISECONDS, (Runnable)this));
                    } else if (this.buffer != null) {
                        Future future = Ack$.MODULE$.AckExtensions(this.sendNextAndReset(now));
                        Ack.AckExtensions$.MODULE$.syncOnContinue$extension(future, (Function0)((JFunction0.mcV.sp & Serializable)this::run$$anonfun$1), (UncaughtExceptionReporter)this.scheduler());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            private Future sendNextAndReset(long now) {
                List oldBuffer = this.buffer.toList();
                this.buffer = ListBuffer$.MODULE$.empty();
                this.expiresAt = now + this.timespanMillis;
                Future future = Ack$.MODULE$.AckExtensions(this.ack);
                Future future2 = Ack$.MODULE$.AckExtensions(Ack.AckExtensions$.MODULE$.syncTryFlatten$extension(future, (UncaughtExceptionReporter)this.scheduler()));
                this.ack = Ack.AckExtensions$.MODULE$.syncFlatMap$extension(future2, (Function1 & Serializable)x$1 -> {
                    Ack.Stop$ stop$;
                    Ack ack = x$1;
                    if (Ack.Continue$.MODULE$.equals(ack)) {
                        stop$ = this.out$1.onNext(oldBuffer);
                    } else if (Ack.Stop$.MODULE$.equals(ack)) {
                        stop$ = Ack.Stop$.MODULE$;
                    } else {
                        throw new MatchError((Object)ack);
                    }
                    return stop$;
                }, (UncaughtExceptionReporter)this.scheduler());
                return this.ack;
            }

            public Future onNext(Object elem) {
                Future future;
                $anon$1 var2_2 = this;
                synchronized (var2_2) {
                    long now = this.scheduler().clockMonotonic(package$.MODULE$.MILLISECONDS());
                    this.buffer.append(elem);
                    future = this.expiresAt <= now || this.$outer.monix$reactive$internal$operators$BufferTimedObservable$$maxCount > 0 && this.$outer.monix$reactive$internal$operators$BufferTimedObservable$$maxCount <= this.buffer.length() ? this.sendNextAndReset(now) : Ack.Continue$.MODULE$;
                }
                return future;
            }

            public void onError(Throwable ex) {
                $anon$1 var2_2 = this;
                synchronized (var2_2) {
                    this.periodicTask$1.cancel();
                    this.ack = Ack.Stop$.MODULE$;
                    this.buffer = null;
                    this.out$1.onError(ex);
                }
            }

            public void onComplete() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    BoxedUnit boxedUnit;
                    this.periodicTask$1.cancel();
                    if (this.buffer.nonEmpty()) {
                        List bundleToSend = this.buffer.toList();
                        Future future = Ack$.MODULE$.AckExtensions(this.ack);
                        boxedUnit = Ack.AckExtensions$.MODULE$.syncOnContinue$extension(future, (Function0)((JFunction0.mcV.sp & Serializable)() -> this.onComplete$$anonfun$1(bundleToSend)), (UncaughtExceptionReporter)this.scheduler());
                    } else {
                        this.out$1.onComplete();
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.buffer = null;
                    this.ack = Ack.Stop$.MODULE$;
                }
            }

            private final void run$$anonfun$1() {
                this.run();
            }

            private final void onComplete$$anonfun$1(List bundleToSend$1) {
                this.out$1.onNext(bundleToSend$1);
                this.out$1.onComplete();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{run$$anonfun$1(), sendNextAndReset$$anonfun$1(scala.collection.immutable.List monix.execution.Ack ), onComplete$$anonfun$1(scala.collection.immutable.List )}, serializedLambda);
            }
        });
        return CompositeCancelable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Cancelable[]{connection, periodicTask}));
    }

    private static final String $init$$$anonfun$1() {
        return "timespan must be strictly positive";
    }

    private static final String $init$$$anonfun$2() {
        return "maxCount must be positive";
    }
}

