/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.operators;

import cats.effect.ExitCase;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Ack;
import monix.execution.Callback;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.FutureUtils$;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.internal.Platform$;
import monix.execution.schedulers.TrampolineExecutionContext$;
import monix.execution.schedulers.TrampolinedRunnable;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class GuaranteeCaseObservable<A>
extends Observable<A> {
    private final Observable<A> source;
    public final Function1<ExitCase<Throwable>, Task<BoxedUnit>> monix$reactive$internal$operators$GuaranteeCaseObservable$$f;

    public <A> GuaranteeCaseObservable(Observable<A> source, Function1<ExitCase<Throwable>, Task<BoxedUnit>> f) {
        this.source = source;
        this.monix$reactive$internal$operators$GuaranteeCaseObservable$$f = f;
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> out) {
        Cancelable cancelable;
        Scheduler s = out.scheduler();
        AtomicBoolean isActive = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(true, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
        try {
            GuaranteeSubscriber out2 = new GuaranteeSubscriber(this, out, isActive);
            Cancelable c = this.source.unsafeSubscribeFn(out2);
            cancelable = Cancelable$.MODULE$.collection((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Cancelable[]{c, out2}));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.monix$reactive$internal$operators$GuaranteeCaseObservable$$fireAndForget(isActive, (ExitCase<Throwable>)ExitCase.Error$.MODULE$.apply((Object)e), s);
                s.reportFailure(e);
                cancelable = Cancelable$.MODULE$.empty();
            }
            throw throwable;
        }
        return cancelable;
    }

    public void monix$reactive$internal$operators$GuaranteeCaseObservable$$fireAndForget(AtomicBoolean isActive, ExitCase<Throwable> ec, Scheduler s) {
        if (isActive.getAndSet(false)) {
            s.execute((Runnable)new TrampolinedRunnable(ec, s, this){
                private final ExitCase ec$1;
                private final Scheduler s$1;
                private final GuaranteeCaseObservable $outer;
                {
                    this.ec$1 = ec$2;
                    this.s$1 = s$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    try {
                        ((Task)this.$outer.monix$reactive$internal$operators$GuaranteeCaseObservable$$f.apply((Object)this.ec$1)).runAsyncAndForget(this.s$1);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable e = throwable3 = (Throwable)option.get();
                            this.s$1.reportFailure(e);
                        }
                        throw throwable;
                    }
                }
            });
        }
    }

    public static final /* synthetic */ Ack.Stop$ monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$_$stopAsFuture$$anonfun$1(BoxedUnit _$1) {
        return Ack.Stop$.MODULE$;
    }

    public static final Throwable monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$_$composeError$1(Throwable e, Throwable e2) {
        return e != null ? Platform$.MODULE$.composeErrors(e, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Throwable[]{e2})) : e2;
    }

    public static final /* synthetic */ Ack.Stop$ monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$_$$anonfun$1$$anonfun$1(BoxedUnit _$2) {
        return Ack.Stop$.MODULE$;
    }

    public static final /* synthetic */ Ack monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$_$$anonfun$2$$anonfun$1(Ack ack$1, BoxedUnit _$3) {
        return ack$1;
    }

    private final class GuaranteeSubscriber
    implements Subscriber<A>,
    Cancelable {
        public final Subscriber<A> monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$out;
        private final AtomicBoolean isActive;
        private final Scheduler scheduler;
        private Future<Ack> ack;
        private final Function1<Try<Ack>, Future<Ack>> asyncTransformRef;
        private final GuaranteeCaseObservable<A> $outer;

        public GuaranteeSubscriber(GuaranteeCaseObservable $outer, Subscriber<A> out, AtomicBoolean isActive) {
            this.monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$out = out;
            this.isActive = isActive;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.scheduler = out.scheduler();
            this.ack = Ack.Continue$.MODULE$;
            this.asyncTransformRef = (Function1 & Serializable)x$1 -> {
                Future<Ack> future;
                Try try_ = x$1;
                if (try_ instanceof Success) {
                    Ack value = (Ack)((Success)try_).value();
                    future = this.detectStopOrFailure((Future<Ack>)value);
                } else if (try_ instanceof Failure) {
                    Throwable e = ((Failure)try_).exception();
                    future = this.stopAsFuture((ExitCase<Throwable>)ExitCase.Error$.MODULE$.apply((Object)e));
                } else {
                    throw new MatchError((Object)try_);
                }
                return future;
            };
        }

        @Override
        public Scheduler scheduler() {
            return this.scheduler;
        }

        @Override
        public Future<Ack> onNext(A elem) {
            Future<Ack> future;
            boolean catchErrors = true;
            try {
                Future<Ack> fa = this.monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$out.onNext(elem);
                this.ack = fa;
                catchErrors = false;
                future = this.detectStopOrFailure(fa);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    if (catchErrors) {
                        future = this.detectStopOrFailure((Future<Ack>)Future$.MODULE$.failed(e));
                    }
                }
                throw throwable;
            }
            return future;
        }

        @Override
        public void onError(Throwable ex) {
            this.signalComplete(ex);
        }

        @Override
        public void onComplete() {
            this.signalComplete(null);
        }

        public void cancel() {
            this.$outer.monix$reactive$internal$operators$GuaranteeCaseObservable$$fireAndForget(this.isActive, (ExitCase<Throwable>)ExitCase.Canceled$.MODULE$, this.scheduler());
        }

        private Future<Ack> detectStopOrFailure(Future<Ack> ack) {
            Future future;
            Future<Ack> future2 = ack;
            if (Ack.Continue$.MODULE$.equals(future2)) {
                future = Ack.Continue$.MODULE$;
            } else if (Ack.Stop$.MODULE$.equals(future2)) {
                future = this.stopAsFuture((ExitCase<Throwable>)ExitCase.Canceled$.MODULE$);
            } else {
                Future<Ack> async = future2;
                future = FutureUtils$.MODULE$.transformWith(async, this.asyncTransformRef, (ExecutionContext)TrampolineExecutionContext$.MODULE$.immediate());
            }
            return future;
        }

        private Future<Ack> stopAsFuture(ExitCase<Throwable> e2) {
            return (Future)(this.isActive.getAndSet(false) ? Task$.MODULE$.suspend(() -> this.stopAsFuture$$anonfun$1(e2)).redeem((Function1 & Serializable)e -> {
                this.scheduler().reportFailure(e);
                return Ack.Stop$.MODULE$;
            }, GuaranteeCaseObservable::monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$_$stopAsFuture$$anonfun$1).runToFuture(this.scheduler()) : Ack.Stop$.MODULE$);
        }

        private void signalComplete(Throwable e) {
            Task task = Task$.MODULE$.fromFuture(this.ack).redeemWith((Function1 & Serializable)e2 -> {
                Task task;
                if (this.isActive.getAndSet(false)) {
                    Throwable error = GuaranteeCaseObservable.monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$_$composeError$1(e, e2);
                    task = ((Task)this.$outer.monix$reactive$internal$operators$GuaranteeCaseObservable$$f.apply((Object)ExitCase.Error$.MODULE$.apply((Object)error))).map(GuaranteeCaseObservable::monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$_$$anonfun$1$$anonfun$1);
                } else {
                    this.scheduler().reportFailure(e2);
                    task = Task$.MODULE$.now((Object)Ack.Stop$.MODULE$);
                }
                return task;
            }, (Function1 & Serializable)ack -> {
                Task task;
                if (this.isActive.getAndSet(false)) {
                    ExitCase.Completed$ code = e != null ? ExitCase.Error$.MODULE$.apply((Object)e) : ExitCase.Completed$.MODULE$;
                    task = ((Task)this.$outer.monix$reactive$internal$operators$GuaranteeCaseObservable$$f.apply((Object)code)).map(arg_0 -> GuaranteeCaseObservable.monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$_$$anonfun$2$$anonfun$1(ack, arg_0));
                } else {
                    task = Task$.MODULE$.now((Object)Ack.Stop$.MODULE$);
                }
                return task;
            });
            task.runAsyncUncancelable((Function1)new Callback<Throwable, Ack>(e, this){
                private final Throwable e$1;
                private final GuaranteeSubscriber $outer;
                {
                    this.e$1 = e$5;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void onSuccess(Ack value) {
                    Ack ack = value;
                    Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                    if (!(ack != null ? !ack.equals(continue$) : continue$ != null)) {
                        if (this.e$1 != null) {
                            this.$outer.monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$out.onError(this.e$1);
                        } else {
                            this.$outer.monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$out.onComplete();
                        }
                    }
                }

                public void onError(Throwable e2) {
                    this.$outer.monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$out.onError(GuaranteeCaseObservable.monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$_$composeError$1(this.e$1, e2));
                }
            }, this.scheduler());
        }

        public final GuaranteeCaseObservable<A> monix$reactive$internal$operators$GuaranteeCaseObservable$GuaranteeSubscriber$$$outer() {
            return this.$outer;
        }

        private final Task stopAsFuture$$anonfun$1(ExitCase e$1) {
            return (Task)this.$outer.monix$reactive$internal$operators$GuaranteeCaseObservable$$f.apply((Object)e$1);
        }
    }
}

