/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.operators;

import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.Future;
import scala.util.control.NonFatal$;

public final class MapAccumulateObservable<A, S, R>
extends Observable<R> {
    private final Observable<A> source;
    private final Function0<S> initial;
    public final Function2<S, A, Tuple2<S, R>> monix$reactive$internal$operators$MapAccumulateObservable$$f;

    public <A, S, R> MapAccumulateObservable(Observable<A> source, Function0<S> initial, Function2<S, A, Tuple2<S, R>> f) {
        this.source = source;
        this.initial = initial;
        this.monix$reactive$internal$operators$MapAccumulateObservable$$f = f;
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<R> out) {
        Cancelable cancelable;
        boolean streamErrors = true;
        try {
            Object initialState = this.initial.apply();
            streamErrors = false;
            cancelable = this.source.unsafeSubscribeFn(new Subscriber<A>(out, initialState, this){
                private final Subscriber out$1;
                private final Scheduler scheduler;
                private boolean isDone;
                private Object state;
                private final MapAccumulateObservable $outer;
                {
                    this.out$1 = out$1;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.scheduler = out$1.scheduler();
                    this.isDone = false;
                    this.state = initialState$1;
                }

                public Scheduler scheduler() {
                    return this.scheduler;
                }

                public Future onNext(Object elem) {
                    Future<Ack> future;
                    boolean streamError = true;
                    try {
                        Tuple2 tuple2 = (Tuple2)this.$outer.monix$reactive$internal$operators$MapAccumulateObservable$$f.apply(this.state, elem);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object newState = tuple2._1();
                        Object result = tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply(newState, result);
                        Object newState2 = tuple22._1();
                        Object result2 = tuple22._2();
                        streamError = false;
                        this.state = newState2;
                        future = this.out$1.onNext(result2);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable ex = throwable3 = (Throwable)option.get();
                            if (streamError) {
                                this.onError(ex);
                                future = Ack.Stop$.MODULE$;
                            }
                        }
                        throw throwable;
                    }
                    return future;
                }

                public void onError(Throwable ex) {
                    if (!this.isDone) {
                        this.isDone = true;
                        this.out$1.onError(ex);
                    }
                }

                public void onComplete() {
                    if (!this.isDone) {
                        this.isDone = true;
                        this.out$1.onComplete();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = (Throwable)option.get();
                if (streamErrors) {
                    out.onError(ex);
                    cancelable = Cancelable$.MODULE$.empty();
                }
            }
            throw throwable;
        }
        return cancelable;
    }
}

