/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.operators;

import java.io.Serializable;
import monix.eval.Task;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.AsyncSemaphore;
import monix.execution.AsyncSemaphore$;
import monix.execution.Callback$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.CancelableFuture;
import monix.execution.ChannelType;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.cancelables.CompositeCancelable;
import monix.execution.cancelables.CompositeCancelable$;
import monix.execution.cancelables.SingleAssignCancelable;
import monix.execution.cancelables.SingleAssignCancelable$;
import monix.reactive.Observable;
import monix.reactive.OverflowStrategy;
import monix.reactive.internal.operators.MapTaskObservable;
import monix.reactive.observers.BufferedSubscriber$;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class MapParallelUnorderedObservable<A, B>
extends Observable<B> {
    private final Observable<A> source;
    public final int monix$reactive$internal$operators$MapParallelUnorderedObservable$$parallelism;
    public final Function1<A, Task<B>> monix$reactive$internal$operators$MapParallelUnorderedObservable$$f;
    public final OverflowStrategy<B> monix$reactive$internal$operators$MapParallelUnorderedObservable$$overflowStrategy;

    public <A, B> MapParallelUnorderedObservable(Observable<A> source, int parallelism, Function1<A, Task<B>> f, OverflowStrategy<B> overflowStrategy) {
        this.source = source;
        this.monix$reactive$internal$operators$MapParallelUnorderedObservable$$parallelism = parallelism;
        this.monix$reactive$internal$operators$MapParallelUnorderedObservable$$f = f;
        this.monix$reactive$internal$operators$MapParallelUnorderedObservable$$overflowStrategy = overflowStrategy;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<B> out) {
        Cancelable cancelable;
        if (this.monix$reactive$internal$operators$MapParallelUnorderedObservable$$parallelism <= 0) {
            out.onError(new IllegalArgumentException("parallelism > 0"));
            cancelable = Cancelable$.MODULE$.empty();
        } else if (this.monix$reactive$internal$operators$MapParallelUnorderedObservable$$parallelism == 1) {
            cancelable = new MapTaskObservable<A, B>(this.source, this.monix$reactive$internal$operators$MapParallelUnorderedObservable$$f).unsafeSubscribeFn(out);
        } else {
            void var3_3;
            CompositeCancelable composite = CompositeCancelable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Cancelable[0]));
            MapAsyncParallelSubscription subscription = new MapAsyncParallelSubscription(this, out, composite);
            composite.$plus$eq(this.source.unsafeSubscribeFn(subscription));
            cancelable = var3_3;
        }
        return cancelable;
    }

    public static final /* synthetic */ Future monix$reactive$internal$operators$MapParallelUnorderedObservable$MapAsyncParallelSubscription$$_$_$$anonfun$1(BoxedUnit _$1) {
        return Ack.Continue$.MODULE$;
    }

    private final class MapAsyncParallelSubscription
    implements Subscriber<A>,
    Cancelable {
        private final CompositeCancelable composite;
        private final Scheduler scheduler;
        private final AsyncSemaphore semaphore;
        private final Subscriber<B> buffer;
        private boolean isDone;
        private Ack lastAck;
        private final MapParallelUnorderedObservable<A, B> $outer;

        public MapAsyncParallelSubscription(MapParallelUnorderedObservable $outer, Subscriber<B> out, CompositeCancelable composite) {
            this.composite = composite;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.scheduler = out.scheduler();
            this.semaphore = AsyncSemaphore$.MODULE$.apply((long)$outer.monix$reactive$internal$operators$MapParallelUnorderedObservable$$parallelism, AsyncSemaphore$.MODULE$.apply$default$2());
            this.buffer = BufferedSubscriber$.MODULE$.apply(out, $outer.monix$reactive$internal$operators$MapParallelUnorderedObservable$$overflowStrategy, (ChannelType.ProducerSide)ChannelType.MultiProducer$.MODULE$);
            this.isDone = false;
            this.lastAck = Ack.Continue$.MODULE$;
        }

        @Override
        public Scheduler scheduler() {
            return this.scheduler;
        }

        private Object process(A elem) {
            BoxedUnit boxedUnit;
            boolean streamErrors = true;
            try {
                SingleAssignCancelable subscription = SingleAssignCancelable$.MODULE$.apply();
                this.composite.$plus$eq((Cancelable)subscription);
                Task task = ((Task)this.$outer.monix$reactive$internal$operators$MapParallelUnorderedObservable$$f.apply(elem)).redeem((Function1)(JProcedure1 & Serializable)error -> {
                    this.lastAck = Ack.Stop$.MODULE$;
                    this.composite.$minus$eq((Cancelable)subscription);
                    this.composite.cancel();
                    this.onError((Throwable)error);
                }, (Function1)(JProcedure1 & Serializable)value -> {
                    Future future = Ack$.MODULE$.AckExtensions(this.buffer.onNext(value));
                    Ack.AckExtensions$.MODULE$.syncOnComplete$extension(future, (Function1)(JProcedure1 & Serializable)x$1 -> {
                        Try try_ = x$1;
                        if (try_ instanceof Success) {
                            Ack ack = (Ack)((Success)try_).value();
                            if (Ack.Stop$.MODULE$.equals(ack)) {
                                this.lastAck = Ack.Stop$.MODULE$;
                                this.composite.cancel();
                                return;
                            }
                            if (Ack.Continue$.MODULE$.equals(ack)) {
                                this.semaphore.release();
                                this.composite.$minus$eq((Cancelable)subscription);
                                return;
                            }
                        }
                        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                        Throwable ex = ((Failure)try_).exception();
                        this.lastAck = Ack.Stop$.MODULE$;
                        this.composite.$minus$eq((Cancelable)subscription);
                        this.onError(ex);
                    }, (UncaughtExceptionReporter)this.scheduler());
                });
                streamErrors = false;
                boxedUnit = subscription.$colon$eq(task.runAsync((Function1)Callback$.MODULE$.empty((UncaughtExceptionReporter)this.scheduler()), this.scheduler()));
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable ex = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(ex)) {
                    if (streamErrors) {
                        this.onError(ex);
                    } else {
                        this.scheduler().reportFailure(ex);
                    }
                } else {
                    throw throwable;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }

        @Override
        public Future<Ack> onNext(A elem) {
            Ack.Stop$ stop$;
            Ack ack = this.lastAck;
            Ack.Stop$ stop$2 = Ack.Stop$.MODULE$;
            if (!(ack == null ? stop$2 != null : !ack.equals(stop$2)) || this.isDone) {
                stop$ = Ack.Stop$.MODULE$;
            } else {
                Ack.Continue$ continue$;
                CancelableFuture permit = this.semaphore.acquire();
                Option option = permit.value();
                if (None$.MODULE$.equals(option)) {
                    continue$ = permit.flatMap(MapParallelUnorderedObservable::monix$reactive$internal$operators$MapParallelUnorderedObservable$MapAsyncParallelSubscription$$_$_$$anonfun$1, (ExecutionContext)this.scheduler());
                } else if (option instanceof Some) {
                    continue$ = Ack.Continue$.MODULE$;
                } else {
                    throw new MatchError((Object)option);
                }
                Future ack2 = (Future)continue$;
                this.composite.$plus$eq((Cancelable)permit);
                ack2.onComplete((Function1 & Serializable)x$1 -> {
                    Object object;
                    Try try_ = x$1;
                    if (try_ instanceof Success) {
                        this.composite.$minus$eq((Cancelable)permit);
                        object = this.process(elem);
                    } else if (try_ instanceof Failure) {
                        Throwable ex = ((Failure)try_).exception();
                        this.composite.$minus$eq((Cancelable)permit);
                        this.onError(ex);
                        object = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    return object;
                }, (ExecutionContext)this.scheduler());
                Future future = Ack$.MODULE$.AckExtensions(ack2);
                stop$ = Ack.AckExtensions$.MODULE$.syncTryFlatten$extension(future, (UncaughtExceptionReporter)this.scheduler());
            }
            return stop$;
        }

        @Override
        public void onError(Throwable ex) {
            if (!this.isDone) {
                this.isDone = true;
                this.lastAck = Ack.Stop$.MODULE$;
                this.buffer.onError(ex);
            }
        }

        @Override
        public void onComplete() {
            this.semaphore.awaitAvailable((long)this.$outer.monix$reactive$internal$operators$MapParallelUnorderedObservable$$parallelism).foreach((Function1)(JProcedure1 & Serializable)_$2 -> {
                if (!this.isDone) {
                    this.isDone = true;
                    this.lastAck = Ack.Stop$.MODULE$;
                    this.buffer.onComplete();
                }
            }, (ExecutionContext)this.scheduler());
        }

        public void cancel() {
            this.isDone = true;
            this.composite.cancel();
        }

        public final MapParallelUnorderedObservable<A, B> monix$reactive$internal$operators$MapParallelUnorderedObservable$MapAsyncParallelSubscription$$$outer() {
            return this.$outer;
        }
    }
}

