/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.operators;

import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.PaddingStrategy;
import monix.reactive.Observable;
import monix.reactive.internal.operators.MapTaskObservable;
import monix.reactive.internal.operators.MapTaskObservable$MapTaskState$;
import monix.reactive.internal.operators.MapTaskObservable$MapTaskState$Active$;
import monix.reactive.internal.operators.MapTaskObservable$MapTaskState$Cancelled$;
import monix.reactive.internal.operators.MapTaskObservable$MapTaskState$WaitActiveTask$;
import monix.reactive.internal.operators.MapTaskObservable$MapTaskState$WaitComplete$;
import monix.reactive.internal.operators.MapTaskObservable$MapTaskState$WaitOnNext$;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.concurrent.Future;
import scala.deriving.Mirror;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class MapTaskObservable<A, B>
extends Observable<B> {
    private final Observable<A> source;
    public final Function1<A, Task<B>> monix$reactive$internal$operators$MapTaskObservable$$f;

    public <A, B> MapTaskObservable(Observable<A> source, Function1<A, Task<B>> f) {
        this.source = source;
        this.monix$reactive$internal$operators$MapTaskObservable$$f = f;
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<B> out) {
        MapAsyncSubscriber subscriber = new MapAsyncSubscriber(this, out);
        Cancelable mainSubscription = this.source.unsafeSubscribeFn(subscriber);
        return Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            try {
                mainSubscription.cancel();
            }
            finally {
                subscriber.cancel();
            }
        });
    }

    public static final Ack.Stop$ monix$reactive$internal$operators$MapTaskObservable$MapAsyncSubscriber$$_$$init$$$anonfun$1$$anonfun$1(Subscriber out$3, Throwable error$1) {
        out$3.onError(error$1);
        return Ack.Stop$.MODULE$;
    }

    private final class MapAsyncSubscriber
    implements Subscriber<A>,
    Cancelable {
        private final Subscriber<B> out;
        private final Scheduler scheduler;
        private final AtomicAny<MapTaskState> stateRef;
        private final AtomicBoolean isActive;
        private final Function1<B, Task<Ack>> childOnSuccess;
        private final Function1<Throwable, Task<Ack.Stop$>> childOnError;
        private final MapTaskObservable<A, B> $outer;

        public MapAsyncSubscriber(MapTaskObservable $outer, Subscriber<B> out) {
            this.out = out;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.scheduler = out.scheduler();
            MapTaskObservable$MapTaskState$WaitOnNext$ initialValue$proxy1 = MapTaskObservable$MapTaskState$WaitOnNext$.MODULE$;
            AtomicBuilder builder$proxy1 = AtomicBuilder$.MODULE$.AtomicRefBuilder();
            this.stateRef = (AtomicAny)builder$proxy1.buildInstance((Object)initialValue$proxy1, (PaddingStrategy)PaddingStrategy.LeftRight128$.MODULE$, true);
            this.isActive = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(true, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
            this.childOnSuccess = (Function1 & Serializable)value -> {
                Task task;
                MapTaskState mapTaskState;
                block7: {
                    Future<Ack> next;
                    block6: {
                        next = out.onNext(value);
                        mapTaskState = (MapTaskState)this.stateRef.getAndSet((Object)MapTaskObservable$MapTaskState$WaitOnNext$.MODULE$);
                        if (MapTaskObservable$MapTaskState$WaitActiveTask$.MODULE$.equals(mapTaskState) || MapTaskObservable$MapTaskState$WaitOnNext$.MODULE$.equals(mapTaskState)) break block6;
                        if (!(mapTaskState instanceof MapTaskState.Active)) break block7;
                        MapTaskState.Active active = MapTaskObservable$MapTaskState$Active$.MODULE$.unapply((MapTaskState.Active)mapTaskState);
                        Cancelable cancelable = active._1();
                    }
                    task = Task$.MODULE$.fromFuture(next);
                    return task;
                }
                if (MapTaskObservable$MapTaskState$Cancelled$.MODULE$.equals(mapTaskState)) {
                    task = Task$.MODULE$.now((Object)Ack.Stop$.MODULE$);
                    return task;
                }
                if (!(mapTaskState instanceof MapTaskState.WaitComplete)) throw new MatchError((Object)mapTaskState);
                MapTaskState.WaitComplete waitComplete = MapTaskObservable$MapTaskState$WaitComplete$.MODULE$.unapply((MapTaskState.WaitComplete)mapTaskState);
                Option<Throwable> option = waitComplete._1();
                Cancelable cancelable = waitComplete._2();
                Option<Throwable> exOpt = option;
                Option<Throwable> option2 = exOpt;
                if (None$.MODULE$.equals(option2)) {
                    out.onComplete();
                } else {
                    if (!(option2 instanceof Some)) throw new MatchError(option2);
                    Throwable ex = (Throwable)((Some)option2).value();
                    out.onError(ex);
                }
                task = Task$.MODULE$.now((Object)Ack.Stop$.MODULE$);
                return task;
            };
            this.childOnError = (Function1 & Serializable)error -> {
                Task task;
                MapTaskState mapTaskState;
                block5: {
                    block4: {
                        mapTaskState = (MapTaskState)this.stateRef.getAndSet((Object)MapTaskObservable$MapTaskState$WaitComplete$.MODULE$.apply((Option<Throwable>)Some$.MODULE$.apply(error), null));
                        if (MapTaskObservable$MapTaskState$WaitActiveTask$.MODULE$.equals(mapTaskState) || MapTaskObservable$MapTaskState$WaitOnNext$.MODULE$.equals(mapTaskState)) break block4;
                        if (!(mapTaskState instanceof MapTaskState.Active)) break block5;
                        MapTaskState.Active active = MapTaskObservable$MapTaskState$Active$.MODULE$.unapply((MapTaskState.Active)mapTaskState);
                        Cancelable cancelable = active._1();
                    }
                    task = Task$.MODULE$.eval(() -> MapTaskObservable.monix$reactive$internal$operators$MapTaskObservable$MapAsyncSubscriber$$_$$init$$$anonfun$1$$anonfun$1(out, error));
                    return task;
                }
                if (mapTaskState instanceof MapTaskState.WaitComplete) {
                    MapTaskState.WaitComplete waitComplete = MapTaskObservable$MapTaskState$WaitComplete$.MODULE$.unapply((MapTaskState.WaitComplete)mapTaskState);
                    Option<Throwable> option = waitComplete._1();
                    Cancelable cancelable = waitComplete._2();
                    Option<Throwable> otherEx = option;
                    otherEx.foreach((Function1)(JProcedure1 & Serializable)t -> this.scheduler().reportFailure(t));
                    out.onError((Throwable)error);
                    task = Task$.MODULE$.now((Object)Ack.Stop$.MODULE$);
                    return task;
                }
                if (!MapTaskObservable$MapTaskState$Cancelled$.MODULE$.equals(mapTaskState)) throw new MatchError((Object)mapTaskState);
                this.scheduler().reportFailure(error);
                task = Task$.MODULE$.now((Object)Ack.Stop$.MODULE$);
                return task;
            };
        }

        @Override
        public Scheduler scheduler() {
            return this.scheduler;
        }

        public void cancel() {
            if (this.isActive.getAndSet(false)) {
                this.cancelState();
            }
        }

        private void cancelState() {
            block5: {
                MapTaskState mapTaskState;
                MapAsyncSubscriber mapAsyncSubscriber = this;
                while (true) {
                    if ((mapTaskState = (MapTaskState)mapAsyncSubscriber.stateRef.get()) instanceof MapTaskState.Active) {
                        Cancelable cancelable;
                        MapTaskState.Active active = (MapTaskState.Active)mapTaskState;
                        MapTaskState.Active active2 = MapTaskObservable$MapTaskState$Active$.MODULE$.unapply(active);
                        Cancelable ref = cancelable = active2._1();
                        MapTaskState.Active current = active;
                        if (!mapAsyncSubscriber.stateRef.compareAndSet((Object)current, (Object)MapTaskObservable$MapTaskState$Cancelled$.MODULE$)) continue;
                        ref.cancel();
                        break block5;
                    }
                    if (mapTaskState instanceof MapTaskState.WaitComplete) {
                        Cancelable cancelable;
                        MapTaskState.WaitComplete waitComplete = (MapTaskState.WaitComplete)mapTaskState;
                        MapTaskState.WaitComplete waitComplete2 = MapTaskObservable$MapTaskState$WaitComplete$.MODULE$.unapply(waitComplete);
                        Option<Throwable> option = waitComplete2._1();
                        Cancelable ref = cancelable = waitComplete2._2();
                        MapTaskState.WaitComplete current = waitComplete;
                        if (ref == null) break block5;
                        if (!mapAsyncSubscriber.stateRef.compareAndSet((Object)current, (Object)MapTaskObservable$MapTaskState$Cancelled$.MODULE$)) continue;
                        ref.cancel();
                        break block5;
                    }
                    if (!MapTaskObservable$MapTaskState$WaitOnNext$.MODULE$.equals(mapTaskState) && !MapTaskObservable$MapTaskState$WaitActiveTask$.MODULE$.equals(mapTaskState)) break;
                    Mirror.Singleton current = (Mirror.Singleton)mapTaskState;
                    if (!mapAsyncSubscriber.stateRef.compareAndSet((Object)current, (Object)MapTaskObservable$MapTaskState$Cancelled$.MODULE$)) {
                        continue;
                    }
                    break block5;
                    break;
                }
                if (!MapTaskObservable$MapTaskState$Cancelled$.MODULE$.equals(mapTaskState)) {
                    throw new MatchError((Object)mapTaskState);
                }
            }
        }

        @Override
        public Future<Ack> onNext(A elem) {
            Ack.Stop$ stop$;
            block14: {
                boolean streamErrors = true;
                if (!this.isActive.get()) {
                    stop$ = Ack.Stop$.MODULE$;
                } else {
                    try {
                        Task task = ((Task)this.$outer.monix$reactive$internal$operators$MapTaskObservable$$f.apply(elem)).redeemWith(this.childOnError, this.childOnSuccess);
                        streamErrors = false;
                        this.stateRef.lazySet((Object)MapTaskObservable$MapTaskState$WaitActiveTask$.MODULE$);
                        CancelableFuture ack = task.runToFuture(this.scheduler());
                        MapTaskState mapTaskState = (MapTaskState)this.stateRef.getAndSet((Object)MapTaskObservable$MapTaskState$Active$.MODULE$.apply((Cancelable)ack));
                        if (MapTaskObservable$MapTaskState$WaitOnNext$.MODULE$.equals(mapTaskState)) {
                            this.stateRef.lazySet((Object)MapTaskObservable$MapTaskState$WaitOnNext$.MODULE$);
                            CancelableFuture cancelableFuture = (CancelableFuture)Ack$.MODULE$.AckExtensions((Future)ack);
                            stop$ = Ack.AckExtensions$.MODULE$.syncTryFlatten$extension((Future)cancelableFuture, (UncaughtExceptionReporter)this.scheduler());
                            break block14;
                        }
                        if (MapTaskObservable$MapTaskState$WaitActiveTask$.MODULE$.equals(mapTaskState)) {
                            CancelableFuture cancelableFuture;
                            if (this.isActive.get()) {
                                cancelableFuture = ack;
                            } else {
                                this.cancelState();
                                cancelableFuture = Ack.Stop$.MODULE$;
                            }
                            stop$ = (Future)cancelableFuture;
                            break block14;
                        }
                        if (mapTaskState instanceof MapTaskState.WaitComplete) {
                            MapTaskState.WaitComplete waitComplete = MapTaskObservable$MapTaskState$WaitComplete$.MODULE$.unapply((MapTaskState.WaitComplete)mapTaskState);
                            Option<Throwable> option = waitComplete._1();
                            Cancelable cancelable = waitComplete._2();
                            this.stateRef.lazySet((Object)MapTaskObservable$MapTaskState$Cancelled$.MODULE$);
                            stop$ = Ack.Stop$.MODULE$;
                            break block14;
                        }
                        if (MapTaskObservable$MapTaskState$Cancelled$.MODULE$.equals(mapTaskState)) {
                            this.cancelState();
                            stop$ = Ack.Stop$.MODULE$;
                            break block14;
                        }
                        if (mapTaskState instanceof MapTaskState.Active) {
                            MapTaskState.Active active = MapTaskObservable$MapTaskState$Active$.MODULE$.unapply((MapTaskState.Active)mapTaskState);
                            Cancelable cancelable = active._1();
                            MapTaskState.Active state = (MapTaskState.Active)mapTaskState;
                            this.reportInvalidState(state, "onNext");
                            stop$ = Ack.Stop$.MODULE$;
                            break block14;
                        }
                        throw new MatchError((Object)mapTaskState);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(ex)) {
                            if (streamErrors) {
                                this.onError(ex);
                                stop$ = Ack.Stop$.MODULE$;
                            } else {
                                this.scheduler().reportFailure(ex);
                                stop$ = Ack.Stop$.MODULE$;
                            }
                        }
                        throw throwable;
                    }
                }
            }
            return stop$;
        }

        private void signalFinish(Option<Throwable> ex) {
            Cancelable cancelable;
            MapTaskState mapTaskState = (MapTaskState)this.stateRef.get();
            if (mapTaskState instanceof MapTaskState.Active) {
                Cancelable cancelable2;
                Cancelable ref;
                MapTaskState.Active active = MapTaskObservable$MapTaskState$Active$.MODULE$.unapply((MapTaskState.Active)mapTaskState);
                cancelable = ref = (cancelable2 = active._1());
            } else if (mapTaskState instanceof MapTaskState.WaitComplete) {
                Cancelable cancelable3;
                Cancelable ref;
                MapTaskState.WaitComplete waitComplete = MapTaskObservable$MapTaskState$WaitComplete$.MODULE$.unapply((MapTaskState.WaitComplete)mapTaskState);
                Option<Throwable> option = waitComplete._1();
                cancelable = ref = (cancelable3 = waitComplete._2());
            } else {
                cancelable = null;
            }
            Cancelable childRef = cancelable;
            MapTaskState mapTaskState2 = (MapTaskState)this.stateRef.getAndSet((Object)MapTaskObservable$MapTaskState$WaitComplete$.MODULE$.apply(ex, childRef));
            if (MapTaskObservable$MapTaskState$WaitOnNext$.MODULE$.equals(mapTaskState2)) {
                if (ex.isEmpty()) {
                    this.out.onComplete();
                } else {
                    this.out.onError((Throwable)ex.get());
                }
                this.stateRef.lazySet((Object)MapTaskObservable$MapTaskState$Cancelled$.MODULE$);
            } else if (mapTaskState2 instanceof MapTaskState.WaitComplete) {
                MapTaskState.WaitComplete waitComplete = MapTaskObservable$MapTaskState$WaitComplete$.MODULE$.unapply((MapTaskState.WaitComplete)mapTaskState2);
                Option<Throwable> option = waitComplete._1();
                Cancelable cancelable4 = waitComplete._2();
                this.stateRef.lazySet((Object)MapTaskObservable$MapTaskState$Cancelled$.MODULE$);
            } else if (MapTaskObservable$MapTaskState$Cancelled$.MODULE$.equals(mapTaskState2)) {
                this.cancelState();
                this.stateRef.lazySet((Object)MapTaskObservable$MapTaskState$Cancelled$.MODULE$);
            } else if (mapTaskState2 instanceof MapTaskState.Active) {
                MapTaskState.Active active = MapTaskObservable$MapTaskState$Active$.MODULE$.unapply((MapTaskState.Active)mapTaskState2);
                Cancelable cancelable5 = active._1();
                if (!this.isActive.get()) {
                    this.cancelState();
                }
            } else if (MapTaskObservable$MapTaskState$WaitActiveTask$.MODULE$.equals(mapTaskState2)) {
                this.reportInvalidState(MapTaskObservable$MapTaskState$WaitActiveTask$.MODULE$, "signalFinish");
            } else {
                throw new MatchError((Object)mapTaskState2);
            }
        }

        @Override
        public void onComplete() {
            this.signalFinish((Option<Throwable>)None$.MODULE$);
        }

        @Override
        public void onError(Throwable ex) {
            this.signalFinish((Option<Throwable>)Some$.MODULE$.apply((Object)ex));
        }

        private void reportInvalidState(MapTaskState state, String method) {
            this.cancelState();
            this.scheduler().reportFailure((Throwable)new IllegalStateException("State " + state + " in the Monix MapTask." + method + " implementation is invalid, " + "due to either a broken Subscriber implementation, or a bug, " + "please open an issue, see: https://monix.io"));
        }

        public final MapTaskObservable<A, B> monix$reactive$internal$operators$MapTaskObservable$MapAsyncSubscriber$$$outer() {
            return this.$outer;
        }
    }

    public static abstract class MapTaskState {
        public static int ordinal(MapTaskState mapTaskState) {
            return MapTaskObservable$MapTaskState$.MODULE$.ordinal(mapTaskState);
        }
    }
}

