/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import monix.execution.cancelables.OrderedCancelable;
import monix.execution.cancelables.OrderedCancelable$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class OnErrorRetryIfObservable<A>
extends Observable<A> {
    private final Observable<A> source;
    public final Function1<Throwable, Object> monix$reactive$internal$operators$OnErrorRetryIfObservable$$p;

    public <A> OnErrorRetryIfObservable(Observable<A> source, Function1<Throwable, Object> p) {
        this.source = source;
        this.monix$reactive$internal$operators$OnErrorRetryIfObservable$$p = p;
    }

    public void monix$reactive$internal$operators$OnErrorRetryIfObservable$$loop(Subscriber<A> subscriber, OrderedCancelable task, long retryIdx) {
        Cancelable cancelable = this.source.unsafeSubscribeFn(new Subscriber<A>(subscriber, task, retryIdx, this){
            private final Subscriber subscriber$1;
            private final OrderedCancelable task$1;
            private final long retryIdx$1;
            private final Scheduler scheduler;
            private boolean isDone;
            private Future ack;
            private final OnErrorRetryIfObservable $outer;
            {
                this.subscriber$1 = subscriber$1;
                this.task$1 = task$1;
                this.retryIdx$1 = retryIdx$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.scheduler = subscriber$1.scheduler();
                this.isDone = false;
                this.ack = Ack.Continue$.MODULE$;
            }

            public Scheduler scheduler() {
                return this.scheduler;
            }

            public Future onNext(Object elem) {
                this.ack = this.subscriber$1.onNext(elem);
                return this.ack;
            }

            public void onComplete() {
                if (!this.isDone) {
                    this.isDone = true;
                    this.subscriber$1.onComplete();
                }
            }

            public void onError(Throwable ex) {
                if (!this.isDone) {
                    this.isDone = true;
                    boolean streamError = true;
                    try {
                        boolean shouldRetry = BoxesRunTime.unboxToBoolean((Object)this.$outer.monix$reactive$internal$operators$OnErrorRetryIfObservable$$p.apply((Object)ex));
                        streamError = false;
                        if (shouldRetry) {
                            this.ack.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                                block0: {
                                    Try try_ = x$1;
                                    if (!(try_ instanceof Success) || !Ack.Continue$.MODULE$.equals(((Success)try_).value())) break block0;
                                    this.$outer.monix$reactive$internal$operators$OnErrorRetryIfObservable$$loop(this.subscriber$1, this.task$1, this.retryIdx$1 + 1L);
                                }
                            }, (ExecutionContext)this.scheduler());
                        } else {
                            this.subscriber$1.onError(ex);
                        }
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable err = throwable3 = (Throwable)option.get();
                            if (streamError) {
                                this.scheduler().reportFailure(ex);
                                this.subscriber$1.onError(err);
                            }
                        }
                        throw throwable;
                    }
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onError$$anonfun$1(scala.util.Try )}, serializedLambda);
            }
        });
        task.orderedUpdate(cancelable, retryIdx);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> subscriber) {
        void var2_2;
        OrderedCancelable task = OrderedCancelable$.MODULE$.apply();
        this.monix$reactive$internal$operators$OnErrorRetryIfObservable$$loop(subscriber, task, 0L);
        return var2_2;
    }
}

