/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.observers;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.reactive.observers.SafeSubscriber$;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class SafeSubscriber<A>
implements Subscriber<A> {
    private final Subscriber<A> subscriber;
    private final Scheduler scheduler;
    private boolean isDone;
    private Future<Ack> ack;

    public static <A> SafeSubscriber<A> apply(Subscriber<A> subscriber) {
        return SafeSubscriber$.MODULE$.apply(subscriber);
    }

    public <A> SafeSubscriber(Subscriber<A> subscriber) {
        this.subscriber = subscriber;
        this.scheduler = subscriber.scheduler();
        this.isDone = false;
        this.ack = Ack.Continue$.MODULE$;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public Future<Ack> onNext(A elem) {
        Future<Ack> future;
        if (!this.isDone) {
            this.ack = this.liftedTree1$1(elem);
            future = this.ack;
        } else {
            future = Ack.Stop$.MODULE$;
        }
        return future;
    }

    @Override
    public void onError(Throwable ex) {
        Future future = Ack$.MODULE$.AckExtensions(this.ack);
        Ack.AckExtensions$.MODULE$.syncOnContinue$extension(future, (Function0)((JFunction0.mcV.sp & Serializable)() -> this.onError$$anonfun$1(ex)), (UncaughtExceptionReporter)this.scheduler());
    }

    @Override
    public void onComplete() {
        Future future = Ack$.MODULE$.AckExtensions(this.ack);
        Ack.AckExtensions$.MODULE$.syncOnContinue$extension(future, (Function0)((JFunction0.mcV.sp & Serializable)this::onComplete$$anonfun$1), (UncaughtExceptionReporter)this.scheduler());
    }

    private Future<Ack> flattenAndCatchFailures(Future<Ack> ack) {
        Ack.Continue$ continue$;
        if (ack == Ack.Continue$.MODULE$) {
            continue$ = Ack.Continue$.MODULE$;
        } else if (ack.isCompleted()) {
            continue$ = this.handleFailure((Try<Ack>)((Try)ack.value().get()));
        } else {
            Promise p = Promise$.MODULE$.apply();
            ack.onComplete((Function1 & Serializable)result -> p.success((Object)this.handleFailure((Try<Ack>)result)), (ExecutionContext)this.scheduler());
            continue$ = p.future();
        }
        return continue$;
    }

    private void signalError(Throwable ex) {
        if (!this.isDone) {
            this.isDone = true;
            try {
                this.subscriber.onError(ex);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable err = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(err)) {
                    this.scheduler().reportFailure(err);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Ack handleFailure(Try<Ack> value) {
        Ack.Stop$ stop$;
        try {
            void var2_2;
            Ack ack = (Ack)value.get();
            if (ack == Ack.Stop$.MODULE$) {
                this.isDone = true;
            }
            stop$ = var2_2;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                this.signalError((Throwable)value.failed().get());
                stop$ = Ack.Stop$.MODULE$;
            }
            throw throwable;
        }
        return stop$;
    }

    private final Future liftedTree1$1(Object elem$1) {
        Ack.Stop$ stop$;
        try {
            stop$ = this.flattenAndCatchFailures(this.subscriber.onNext(elem$1));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                this.onError(ex);
                stop$ = Ack.Stop$.MODULE$;
            }
            throw throwable;
        }
        return stop$;
    }

    private final void onError$$anonfun$1(Throwable ex$1) {
        this.signalError(ex$1);
    }

    private final void liftedTree2$1() {
        try {
            this.subscriber.onComplete();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable err = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(err)) {
                this.scheduler().reportFailure(err);
            }
            throw throwable;
        }
    }

    private final void onComplete$$anonfun$1() {
        if (!this.isDone) {
            this.isDone = true;
            this.liftedTree2$1();
        }
    }
}

