/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.observers;

import monix.execution.Ack;
import monix.execution.Scheduler;
import monix.execution.cancelables.BooleanCancelable;
import monix.reactive.Observer;
import monix.reactive.observers.Subscriber$Extensions$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.concurrent.Future;
import scala.util.control.NonFatal$;

public interface Subscriber<A>
extends Observer<A> {
    public Scheduler scheduler();

    private static final class ContravariantSubscriber<A, B>
    implements Subscriber<B> {
        private final Subscriber<A> source;
        private final Function1<B, A> f;
        private boolean isDone;

        public <A, B> ContravariantSubscriber(Subscriber<A> source, Function1<B, A> f) {
            this.source = source;
            this.f = f;
            this.isDone = false;
        }

        @Override
        public Scheduler scheduler() {
            return this.source.scheduler();
        }

        @Override
        public Future<Ack> onNext(B elem) {
            Ack.Stop$ stop$;
            if (this.isDone) {
                stop$ = Ack.Stop$.MODULE$;
            } else {
                boolean streamError = true;
                try {
                    Object b = this.f.apply(elem);
                    streamError = false;
                    stop$ = this.source.onNext(b);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = (Throwable)option.get();
                        if (streamError) {
                            this.onError(ex);
                            stop$ = Ack.Stop$.MODULE$;
                        }
                    }
                    throw throwable;
                }
            }
            return stop$;
        }

        @Override
        public void onError(Throwable ex) {
            if (!this.isDone) {
                this.isDone = true;
                this.source.onError(ex);
            }
        }

        @Override
        public void onComplete() {
            if (!this.isDone) {
                this.isDone = true;
                this.source.onComplete();
            }
        }
    }

    public static final class Extensions<A> {
        private final Subscriber target;

        public static Subscriber contramap$extension(Subscriber subscriber, Function1 function1) {
            return Subscriber$Extensions$.MODULE$.contramap$extension(subscriber, function1);
        }

        public static boolean equals$extension(Subscriber subscriber, Object object) {
            return Subscriber$Extensions$.MODULE$.equals$extension(subscriber, object);
        }

        public static Future feed$extension(Subscriber subscriber, BooleanCancelable booleanCancelable, Iterable iterable) {
            return Subscriber$Extensions$.MODULE$.feed$extension(subscriber, booleanCancelable, iterable);
        }

        public static Future feed$extension(Subscriber subscriber, BooleanCancelable booleanCancelable, Iterator iterator) {
            return Subscriber$Extensions$.MODULE$.feed$extension(subscriber, booleanCancelable, iterator);
        }

        public static Future feed$extension(Subscriber subscriber, Iterable iterable) {
            return Subscriber$Extensions$.MODULE$.feed$extension(subscriber, iterable);
        }

        public static Future feed$extension(Subscriber subscriber, Iterator iterator) {
            return Subscriber$Extensions$.MODULE$.feed$extension(subscriber, iterator);
        }

        public static int hashCode$extension(Subscriber subscriber) {
            return Subscriber$Extensions$.MODULE$.hashCode$extension(subscriber);
        }

        public static Future onNextAll$extension(Subscriber subscriber, Iterable iterable) {
            return Subscriber$Extensions$.MODULE$.onNextAll$extension(subscriber, iterable);
        }

        public static org.reactivestreams.Subscriber toReactive$extension(Subscriber subscriber) {
            return Subscriber$Extensions$.MODULE$.toReactive$extension(subscriber);
        }

        public static org.reactivestreams.Subscriber toReactive$extension(Subscriber subscriber, int n) {
            return Subscriber$Extensions$.MODULE$.toReactive$extension(subscriber, n);
        }

        public <A> Extensions(Subscriber<A> target) {
            this.target = target;
        }

        public int hashCode() {
            return Subscriber$Extensions$.MODULE$.hashCode$extension(this.target());
        }

        public boolean equals(Object x$0) {
            return Subscriber$Extensions$.MODULE$.equals$extension(this.target(), x$0);
        }

        public Subscriber<A> target() {
            return this.target;
        }

        public org.reactivestreams.Subscriber<A> toReactive() {
            return Subscriber$Extensions$.MODULE$.toReactive$extension(this.target());
        }

        public org.reactivestreams.Subscriber<A> toReactive(int requestCount) {
            return Subscriber$Extensions$.MODULE$.toReactive$extension(this.target(), requestCount);
        }

        public Future<Ack> onNextAll(Iterable<A> xs) {
            return Subscriber$Extensions$.MODULE$.onNextAll$extension(this.target(), xs);
        }

        public Future<Ack> feed(Iterable<A> iterable) {
            return Subscriber$Extensions$.MODULE$.feed$extension(this.target(), iterable);
        }

        public Future<Ack> feed(BooleanCancelable subscription, Iterable<A> iterable) {
            return Subscriber$Extensions$.MODULE$.feed$extension(this.target(), subscription, iterable);
        }

        public Future<Ack> feed(Iterator<A> iterator) {
            return Subscriber$Extensions$.MODULE$.feed$extension(this.target(), iterator);
        }

        public Future<Ack> feed(BooleanCancelable subscription, Iterator<A> iterator) {
            return Subscriber$Extensions$.MODULE$.feed$extension(this.target(), subscription, iterator);
        }

        public <B> Subscriber<B> contramap(Function1<B, A> f) {
            return Subscriber$Extensions$.MODULE$.contramap$extension(this.target(), f);
        }
    }

    private static final class Implementation<A>
    implements Subscriber<A> {
        private final Observer underlying;
        private final Scheduler scheduler;

        public <A> Implementation(Observer<A> underlying, Scheduler scheduler) {
            this.underlying = underlying;
            this.scheduler = scheduler;
            Predef$.MODULE$.require(underlying != null, this::$init$$$anonfun$1);
            Predef$.MODULE$.require(scheduler != null, this::$init$$$anonfun$2);
        }

        private Observer<A> underlying() {
            return this.underlying;
        }

        @Override
        public Scheduler scheduler() {
            return this.scheduler;
        }

        @Override
        public Future<Ack> onNext(A elem) {
            return this.underlying().onNext(elem);
        }

        @Override
        public void onError(Throwable ex) {
            this.underlying().onError(ex);
        }

        @Override
        public void onComplete() {
            this.underlying().onComplete();
        }

        private final String $init$$$anonfun$1() {
            return "Observer should not be null";
        }

        private final String $init$$$anonfun$2() {
            return "Scheduler should not be null";
        }
    }

    public static interface Sync<A>
    extends Subscriber<A>,
    Observer.Sync<A> {
    }

    private static final class SyncImplementation<A>
    implements Sync<A> {
        private final Observer.Sync<A> observer;
        private final Scheduler scheduler;

        public <A> SyncImplementation(Observer.Sync<A> observer, Scheduler scheduler) {
            this.observer = observer;
            this.scheduler = scheduler;
            Predef$.MODULE$.require(observer != null, this::$init$$$anonfun$1);
            Predef$.MODULE$.require(scheduler != null, this::$init$$$anonfun$2);
        }

        @Override
        public Scheduler scheduler() {
            return this.scheduler;
        }

        @Override
        public Ack onNext(A elem) {
            return this.observer.onNext(elem);
        }

        @Override
        public void onError(Throwable ex) {
            this.observer.onError(ex);
        }

        @Override
        public void onComplete() {
            this.observer.onComplete();
        }

        private final String $init$$$anonfun$1() {
            return "Observer should not be null";
        }

        private final String $init$$$anonfun$2() {
            return "Scheduler should not be null";
        }
    }
}

