/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.observers.buffers;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Coeval;
import monix.execution.Ack;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicAny$;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicInt;
import monix.execution.atomic.AtomicInt$;
import monix.execution.atomic.PaddingStrategy;
import monix.reactive.OverflowStrategy;
import monix.reactive.OverflowStrategy$ClearBuffer$;
import monix.reactive.OverflowStrategy$ClearBufferAndSignal$;
import monix.reactive.OverflowStrategy$DropNew$;
import monix.reactive.OverflowStrategy$DropNewAndSignal$;
import monix.reactive.OverflowStrategy$DropOld$;
import monix.reactive.OverflowStrategy$DropOldAndSignal$;
import monix.reactive.observers.BufferedSubscriber;
import monix.reactive.observers.Subscriber;
import monix.reactive.observers.buffers.AbstractEvictingBufferedSubscriber$;
import monix.reactive.observers.buffers.AbstractEvictingBufferedSubscriber$Buffer$;
import monix.reactive.observers.buffers.CommonBufferMembers;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public abstract class AbstractEvictingBufferedSubscriber<A>
extends CommonBufferMembers
implements BufferedSubscriber<A>,
Subscriber.Sync<A> {
    public final Subscriber<A> monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$out;
    public final Function1<Object, Coeval<Option<A>>> monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$onOverflow;
    private final Scheduler scheduler;
    public final ExecutionModel monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$em;
    public final AtomicInt monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$droppedCount;
    public final AtomicInt monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$itemsToPush;
    public final ConcurrentBuffer<A> monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$queue;
    private final Runnable consumerLoop;

    public <A> AbstractEvictingBufferedSubscriber(Subscriber<A> out, OverflowStrategy.Evicted<Nothing$> strategy, Function1<Object, Coeval<Option<A>>> onOverflow) {
        this.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$out = out;
        this.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$onOverflow = onOverflow;
        Predef$.MODULE$.require(strategy.bufferSize() > 0, AbstractEvictingBufferedSubscriber::$init$$$anonfun$1);
        this.scheduler = out.scheduler();
        this.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$em = out.scheduler().executionModel();
        this.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$droppedCount = onOverflow != null ? AtomicInt$.MODULE$.withPadding(0, (PaddingStrategy)PaddingStrategy.LeftRight128$.MODULE$) : null;
        this.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$itemsToPush = AtomicBuilder.AtomicIntBuilder$.MODULE$.buildInstance(0, (PaddingStrategy)PaddingStrategy.LeftRight256$.MODULE$, true);
        this.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$queue = new ConcurrentBuffer(strategy);
        this.consumerLoop = new Runnable(this){
            private final AbstractEvictingBufferedSubscriber $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.fastLoop(Queue$.MODULE$.empty(), this.$outer.lastIterationAck, 0, 0);
            }

            private Future signalNext(Object next) {
                Ack ack;
                block9: {
                    try {
                        Ack ack2;
                        block11: {
                            block10: {
                                Ack ack3 = ack2 = this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$out.onNext(next);
                                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                                if (!(ack3 == null ? continue$ != null : !ack3.equals(continue$))) break block10;
                                Ack ack4 = ack2;
                                Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                                if (ack4 != null ? !ack4.equals(stop$) : stop$ != null) break block11;
                            }
                            ack = ack2;
                            break block9;
                        }
                        Option option = ack2.value();
                        if (option instanceof Some) {
                            Try try_ = (Try)((Some)option).value();
                            if (try_ instanceof Success) {
                                Ack success;
                                ack = success = (Ack)((Success)try_).value();
                                break block9;
                            }
                            if (try_ instanceof Failure) {
                                Throwable ex = ((Failure)try_).exception();
                                this.signalError(ex);
                                ack = Ack.Stop$.MODULE$;
                                break block9;
                            }
                        }
                        if (None$.MODULE$.equals(option)) {
                            ack = ack2;
                            break block9;
                        }
                        throw new MatchError((Object)option);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(ex)) {
                            this.signalError(ex);
                            ack = Ack.Stop$.MODULE$;
                        }
                        throw throwable;
                    }
                }
                return ack;
            }

            private void signalComplete() {
                try {
                    this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$out.onComplete();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(ex)) {
                        this.$outer.scheduler().reportFailure(ex);
                    }
                    throw throwable;
                }
            }

            private void signalError(Throwable ex) {
                try {
                    this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$out.onError(ex);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable err = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(err)) {
                        this.$outer.scheduler().reportFailure(err);
                    }
                    throw throwable;
                }
            }

            private void goAsync(Queue prevQueue, Object next, Future ack, int processed, int toProcess) {
                ack.onComplete((Function1)((JProcedure1 & Serializable)arg_0 -> this.goAsync$$anonfun$1(prevQueue, next, ack, processed, toProcess, arg_0)), (ExecutionContext)this.$outer.scheduler());
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void fastLoop(Queue prevQueue, Future prevAck, int lastProcessed, int startIndex) {
                Ack.Continue$ ack;
                Ack.Continue$ continue$ = ack = prevAck == null ? Ack.Continue$.MODULE$ : prevAck;
                Ack.Continue$ continue$2 = Ack.Continue$.MODULE$;
                boolean isFirstIteration = !(continue$ != null ? !continue$.equals(continue$2) : continue$2 != null);
                int processed = lastProcessed;
                int nextIndex = startIndex;
                Queue<A> currentQueue = prevQueue;
                while (!this.$outer.downstreamIsComplete) {
                    boolean streamErrors = true;
                    try {
                        Object object;
                        Object overflowMessage;
                        Object object2;
                        if (currentQueue.isEmpty()) {
                            currentQueue = this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$queue.drain();
                        }
                        int toProcess = 0;
                        if (this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$onOverflow == null || this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$droppedCount.get() == 0) {
                            object2 = null;
                        } else {
                            Option option = (Option)((Coeval)this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$onOverflow.apply((Object)BoxesRunTime.boxToLong((long)this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$droppedCount.getAndSet(0)))).value();
                            if (option instanceof Some) {
                                Object value;
                                object2 = value = ((Some)option).value();
                            } else {
                                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                                object2 = overflowMessage = null;
                            }
                        }
                        if (overflowMessage != null) {
                            object = overflowMessage;
                        } else if (currentQueue.isEmpty()) {
                            object = null;
                        } else {
                            Queue<A> q;
                            Tuple2 tuple2 = currentQueue.dequeue();
                            if (tuple2 == null) throw new MatchError((Object)tuple2);
                            Object ref = tuple2._1();
                            Queue q2 = (Queue)tuple2._2();
                            Tuple2 tuple22 = Tuple2$.MODULE$.apply(ref, (Object)q2);
                            Object ref2 = tuple22._1();
                            currentQueue = q = (Queue<A>)tuple22._2();
                            toProcess = 1;
                            object = ref2;
                        }
                        Object next = object;
                        streamErrors = false;
                        if (next != null) {
                            if (nextIndex > 0 || isFirstIteration) {
                                isFirstIteration = false;
                                Ack.Continue$ continue$3 = ack;
                                if (Ack.Continue$.MODULE$.equals(continue$3)) {
                                    Ack.Continue$ continue$4 = ack = this.signalNext(next);
                                    Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                                    if (!(continue$4 != null ? !continue$4.equals(stop$) : stop$ != null)) {
                                        this.$outer.downstreamIsComplete = true;
                                        return;
                                    }
                                    Ack.Continue$ continue$5 = ack;
                                    Ack.Continue$ continue$6 = Ack.Continue$.MODULE$;
                                    boolean isSync = !(continue$5 != null ? !continue$5.equals(continue$6) : continue$6 != null);
                                    nextIndex = isSync ? this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$em.nextFrameIndex(nextIndex) : 0;
                                    processed += toProcess;
                                    continue;
                                }
                                if (Ack.Stop$.MODULE$.equals(continue$3)) {
                                    this.$outer.downstreamIsComplete = true;
                                    return;
                                }
                                this.goAsync(currentQueue, next, (Future)ack, processed, toProcess);
                                return;
                            }
                            this.goAsync(currentQueue, next, (Future)ack, processed, toProcess);
                            return;
                        }
                        if (this.$outer.upstreamIsComplete) {
                            currentQueue = this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$queue.drain();
                            if (!currentQueue.isEmpty() || this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$onOverflow != null && this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$droppedCount.get() != 0) continue;
                            this.$outer.downstreamIsComplete = true;
                            if (this.$outer.errorThrown != null) {
                                this.signalError(this.$outer.errorThrown);
                                return;
                            }
                            this.signalComplete();
                            return;
                        }
                        this.$outer.lastIterationAck = ack;
                        int remaining = this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$itemsToPush.decrementAndGet(processed);
                        processed = 0;
                        if (remaining > 0) continue;
                        return;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = throwable;
                        if (!NonFatal$.MODULE$.apply(ex)) throw throwable;
                        if (streamErrors) {
                            this.$outer.downstreamIsComplete = true;
                            this.signalError(ex);
                            continue;
                        }
                        this.$outer.scheduler().reportFailure(ex);
                    }
                }
            }

            /*
             * Unable to fully structure code
             */
            private final /* synthetic */ void goAsync$$anonfun$1(Queue prevQueue$1, Object next$1, Future ack$1, int processed$1, int toProcess$1, Try x$1) {
                block7: {
                    block6: {
                        var7_7 = x$1;
                        if (!(var7_7 instanceof Success)) ** GOTO lbl-1000
                        var8_8 = (Ack)((Success)var7_7).value();
                        if (!Ack.Continue$.MODULE$.equals(var8_8)) break block6;
                        nextAck = this.signalNext(next$1);
                        v0 = ack$1;
                        var11_10 = Ack.Continue$.MODULE$;
                        if (!(v0 == null ? var11_10 != null : v0.equals(var11_10) == false)) ** GOTO lbl-1000
                        v1 = ack$1;
                        var12_11 = Ack.Stop$.MODULE$;
                        if (!(v1 != null ? v1.equals(var12_11) == false : var12_11 != null)) lbl-1000:
                        // 2 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        isSync = v2;
                        nextFrame = isSync != false ? this.$outer.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$em.nextFrameIndex(0) : 0;
                        this.fastLoop(prevQueue$1, nextAck, processed$1 + toProcess$1, nextFrame);
                        break block7;
                    }
                    if (Ack.Stop$.MODULE$.equals(var8_8)) {
                        this.$outer.downstreamIsComplete = true;
                    } else if (var7_7 instanceof Failure) {
                        ex = ((Failure)var7_7).exception();
                        this.$outer.downstreamIsComplete = true;
                        this.signalError(ex);
                    } else {
                        throw new MatchError((Object)var7_7);
                    }
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{goAsync$$anonfun$1(scala.collection.immutable.Queue java.lang.Object scala.concurrent.Future int int scala.util.Try )}, serializedLambda);
            }
        };
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public Ack onNext(A elem) {
        Ack.Stop$ stop$;
        if (this.upstreamIsComplete || this.downstreamIsComplete) {
            stop$ = Ack.Stop$.MODULE$;
        } else {
            Ack.Stop$ stop$2;
            if (elem == null) {
                this.onError(new NullPointerException("Null not supported in onNext"));
                stop$2 = Ack.Stop$.MODULE$;
            } else {
                int dropped = this.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$queue.offer(elem);
                if (dropped > 0 && this.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$onOverflow != null) {
                    this.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$droppedCount.increment(dropped);
                }
                int increment = 1 - dropped;
                this.pushToConsumer(increment);
                stop$2 = Ack.Continue$.MODULE$;
            }
            stop$ = (Ack)stop$2;
        }
        return stop$;
    }

    @Override
    public void onError(Throwable ex) {
        if (!this.upstreamIsComplete && !this.downstreamIsComplete) {
            this.errorThrown = ex;
            this.upstreamIsComplete = true;
            this.pushToConsumer(1);
        }
    }

    @Override
    public void onComplete() {
        if (!this.upstreamIsComplete && !this.downstreamIsComplete) {
            this.upstreamIsComplete = true;
            this.pushToConsumer(1);
        }
    }

    private void pushToConsumer(int increment) {
        int currentNr;
        int n = currentNr = increment != 0 ? this.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$itemsToPush.getAndIncrement(increment) : this.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$itemsToPush.get();
        if (currentNr == 0) {
            this.scheduler().execute(this.consumerLoop);
        }
    }

    private static final String $init$$$anonfun$1() {
        return "bufferSize must be a strictly positive number";
    }

    private static final class Buffer<A>
    implements Product,
    Serializable {
        private final int length;
        private final Queue queue;

        public static <A> Buffer<A> apply(int n, Queue<A> queue) {
            return AbstractEvictingBufferedSubscriber$Buffer$.MODULE$.apply(n, queue);
        }

        public static Buffer fromProduct(Product product) {
            return AbstractEvictingBufferedSubscriber$Buffer$.MODULE$.fromProduct(product);
        }

        public static <A> Buffer<A> unapply(Buffer<A> buffer) {
            return AbstractEvictingBufferedSubscriber$Buffer$.MODULE$.unapply(buffer);
        }

        public <A> Buffer(int length, Queue<A> queue) {
            this.length = length;
            this.queue = queue;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.length());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queue()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Buffer)) return false;
            Buffer buffer = (Buffer)object;
            if (this.length() != buffer.length()) return false;
            Queue<A> queue = this.queue();
            Queue<A> queue2 = buffer.queue();
            if (queue != null) {
                if (!queue.equals(queue2)) return false;
                return true;
            }
            if (queue2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Buffer;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Buffer";
        }

        public Object productElement(int n) {
            Queue<A> queue;
            int n2 = n;
            if (0 == n2) {
                queue = BoxesRunTime.boxToInteger((int)this._1());
            } else if (1 == n2) {
                queue = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return queue;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "length";
            } else if (1 == n2) {
                string = "queue";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public int length() {
            return this.length;
        }

        public Queue<A> queue() {
            return this.queue;
        }

        public <A> Buffer<A> copy(int length, Queue<A> queue) {
            return new Buffer<A>(length, queue);
        }

        public int copy$default$1() {
            return this.length();
        }

        public <A> Queue<A> copy$default$2() {
            return this.queue();
        }

        public int _1() {
            return this.length();
        }

        public Queue<A> _2() {
            return this.queue();
        }
    }

    private static final class ConcurrentBuffer<A> {
        private final OverflowStrategy.Evicted<Nothing$> strategy;
        private final AtomicAny<Buffer<A>> bufferRef;

        public <A> ConcurrentBuffer(OverflowStrategy.Evicted<Nothing$> strategy) {
            this.strategy = strategy;
            this.bufferRef = AtomicAny$.MODULE$.withPadding(AbstractEvictingBufferedSubscriber$.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$$emptyBuffer, (PaddingStrategy)PaddingStrategy.LeftRight256$.MODULE$);
        }

        public Queue<A> drain() {
            Buffer current = (Buffer)this.bufferRef.getAndSet(AbstractEvictingBufferedSubscriber$.monix$reactive$observers$buffers$AbstractEvictingBufferedSubscriber$$$emptyBuffer);
            return current.queue();
        }

        public int offer(A a) {
            int n;
            block11: {
                OverflowStrategy.Evicted<Nothing$> evicted;
                block12: {
                    int length;
                    ConcurrentBuffer concurrentBuffer = this;
                    while (true) {
                        Buffer current;
                        block15: {
                            Queue queue;
                            block14: {
                                block13: {
                                    current = (Buffer)concurrentBuffer.bufferRef.get();
                                    length = current.length();
                                    queue = current.queue();
                                    if (length < concurrentBuffer.strategy.bufferSize()) {
                                        Buffer update = AbstractEvictingBufferedSubscriber$Buffer$.MODULE$.apply(length + 1, queue.enqueue(a));
                                        if (!concurrentBuffer.bufferRef.compareAndSet((Object)current, update)) continue;
                                        n = 0;
                                        break block11;
                                    }
                                    evicted = concurrentBuffer.strategy;
                                    if (!(evicted instanceof OverflowStrategy.DropOld)) break block13;
                                    OverflowStrategy.DropOld dropOld = OverflowStrategy$DropOld$.MODULE$.unapply((OverflowStrategy.DropOld)evicted);
                                    int n2 = dropOld._1();
                                    break block14;
                                }
                                if (!(evicted instanceof OverflowStrategy.DropOldAndSignal)) break block15;
                                OverflowStrategy.DropOldAndSignal dropOldAndSignal = OverflowStrategy$DropOldAndSignal$.MODULE$.unapply((OverflowStrategy.DropOldAndSignal)evicted);
                                int n3 = dropOldAndSignal._1();
                                Function1 function1 = dropOldAndSignal._2();
                            }
                            Tuple2 tuple2 = queue.dequeue();
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Queue q = (Queue)tuple2._2();
                            Queue q2 = q;
                            Buffer update = AbstractEvictingBufferedSubscriber$Buffer$.MODULE$.apply(length, q2.enqueue(a));
                            if (!concurrentBuffer.bufferRef.compareAndSet((Object)current, update)) continue;
                            n = 1;
                            break block11;
                        }
                        if (evicted instanceof OverflowStrategy.ClearBuffer) {
                            OverflowStrategy.ClearBuffer clearBuffer = OverflowStrategy$ClearBuffer$.MODULE$.unapply((OverflowStrategy.ClearBuffer)evicted);
                            int n4 = clearBuffer._1();
                        } else {
                            if (!(evicted instanceof OverflowStrategy.ClearBufferAndSignal)) break block12;
                            OverflowStrategy.ClearBufferAndSignal clearBufferAndSignal = OverflowStrategy$ClearBufferAndSignal$.MODULE$.unapply((OverflowStrategy.ClearBufferAndSignal)evicted);
                            int n5 = clearBufferAndSignal._1();
                            Function1 function1 = clearBufferAndSignal._2();
                        }
                        Buffer update = AbstractEvictingBufferedSubscriber$Buffer$.MODULE$.apply(1, Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{a})));
                        if (concurrentBuffer.bufferRef.compareAndSet((Object)current, update)) break;
                    }
                    n = length;
                    break block11;
                }
                if (evicted instanceof OverflowStrategy.DropNew) {
                    OverflowStrategy.DropNew dropNew = OverflowStrategy$DropNew$.MODULE$.unapply((OverflowStrategy.DropNew)evicted);
                    int n6 = dropNew._1();
                } else {
                    if (!(evicted instanceof OverflowStrategy.DropNewAndSignal)) {
                        throw new MatchError(evicted);
                    }
                    OverflowStrategy.DropNewAndSignal dropNewAndSignal = OverflowStrategy$DropNewAndSignal$.MODULE$.unapply((OverflowStrategy.DropNewAndSignal)evicted);
                    int n7 = dropNewAndSignal._1();
                    Function1 function1 = dropNewAndSignal._2();
                }
                n = 1;
            }
            return n;
        }
    }
}

