/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.observers.buffers;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.execution.Ack;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicInt;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.exceptions.BufferOverflowException$;
import monix.execution.internal.collection.LowLevelConcurrentQueue;
import monix.reactive.observers.BufferedSubscriber;
import monix.reactive.observers.Subscriber;
import monix.reactive.observers.buffers.CommonBufferMembers;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public abstract class AbstractSimpleBufferedSubscriber<A>
extends CommonBufferMembers
implements BufferedSubscriber<A>,
Subscriber.Sync<A> {
    public final Subscriber<A> monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$out;
    private final int capacity;
    public final LowLevelConcurrentQueue<A> monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$queue;
    public final ExecutionModel monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$em;
    private final Scheduler scheduler;
    public final AtomicInt monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$itemsToPush;
    private final Runnable consumerLoop;

    public <A> AbstractSimpleBufferedSubscriber(Subscriber<A> out, LowLevelConcurrentQueue<A> _qRef, int capacity) {
        this.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$out = out;
        this.capacity = capacity;
        this.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$queue = _qRef;
        this.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$em = out.scheduler().executionModel();
        this.scheduler = out.scheduler();
        this.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$itemsToPush = AtomicBuilder.AtomicIntBuilder$.MODULE$.buildInstance(0, (PaddingStrategy)PaddingStrategy.LeftRight256$.MODULE$, true);
        this.consumerLoop = new Runnable(this){
            private final AbstractSimpleBufferedSubscriber $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.fastLoop(this.$outer.lastIterationAck, 0, 0);
            }

            private final Future signalNext(Object next) {
                Ack ack;
                block9: {
                    try {
                        Ack ack2;
                        block11: {
                            block10: {
                                Ack ack3 = ack2 = this.$outer.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$out.onNext(next);
                                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                                if (!(ack3 == null ? continue$ != null : !ack3.equals(continue$))) break block10;
                                Ack ack4 = ack2;
                                Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                                if (ack4 != null ? !ack4.equals(stop$) : stop$ != null) break block11;
                            }
                            ack = ack2;
                            break block9;
                        }
                        Option option = ack2.value();
                        if (option instanceof Some) {
                            Try try_ = (Try)((Some)option).value();
                            if (try_ instanceof Success) {
                                Ack success;
                                ack = success = (Ack)((Success)try_).value();
                                break block9;
                            }
                            if (try_ instanceof Failure) {
                                Throwable ex = ((Failure)try_).exception();
                                this.signalError(ex);
                                ack = Ack.Stop$.MODULE$;
                                break block9;
                            }
                        }
                        if (None$.MODULE$.equals(option)) {
                            ack = ack2;
                            break block9;
                        }
                        throw new MatchError((Object)option);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(ex)) {
                            this.signalError(ex);
                            ack = Ack.Stop$.MODULE$;
                        }
                        throw throwable;
                    }
                }
                return ack;
            }

            private final void signalComplete() {
                try {
                    this.$outer.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$out.onComplete();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(ex)) {
                        this.$outer.scheduler().reportFailure(ex);
                    }
                    throw throwable;
                }
            }

            private final void signalError(Throwable ex) {
                try {
                    this.$outer.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$out.onError(ex);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable err = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(err)) {
                        this.$outer.scheduler().reportFailure(err);
                    }
                    throw throwable;
                }
            }

            private void goAsync(Object next, Future ack, int processed) {
                ack.onComplete((Function1)((JProcedure1 & Serializable)arg_0 -> this.goAsync$$anonfun$1(next, ack, processed, arg_0)), (ExecutionContext)this.$outer.scheduler());
            }

            private void fastLoop(Future prevAck, int lastProcessed, int startIndex) {
                Ack.Continue$ ack;
                Ack.Continue$ continue$ = ack = prevAck == null ? Ack.Continue$.MODULE$ : prevAck;
                Ack.Continue$ continue$2 = Ack.Continue$.MODULE$;
                boolean isFirstIteration = !(continue$ != null ? !continue$.equals(continue$2) : continue$2 != null);
                int processed = lastProcessed;
                int nextIndex = startIndex;
                while (!this.$outer.downstreamIsComplete) {
                    Object next = this.$outer.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$queue.poll();
                    if (next != null) {
                        if (nextIndex > 0 || isFirstIteration) {
                            isFirstIteration = false;
                            Ack.Continue$ continue$3 = ack;
                            if (Ack.Continue$.MODULE$.equals(continue$3)) {
                                Ack.Continue$ continue$4 = ack = this.signalNext(next);
                                Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                                if (!(continue$4 != null ? !continue$4.equals(stop$) : stop$ != null)) {
                                    this.$outer.downstreamIsComplete = true;
                                    return;
                                }
                                Ack.Continue$ continue$5 = ack;
                                Ack.Continue$ continue$6 = Ack.Continue$.MODULE$;
                                boolean isSync = !(continue$5 != null ? !continue$5.equals(continue$6) : continue$6 != null);
                                nextIndex = isSync ? this.$outer.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$em.nextFrameIndex(nextIndex) : 0;
                                ++processed;
                                continue;
                            }
                            if (Ack.Stop$.MODULE$.equals(continue$3)) {
                                this.$outer.downstreamIsComplete = true;
                                return;
                            }
                            this.goAsync(next, (Future)ack, processed);
                            return;
                        }
                        this.goAsync(next, (Future)ack, processed);
                        return;
                    }
                    if (this.$outer.upstreamIsComplete) {
                        if (!this.$outer.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$queue.isEmpty()) continue;
                        this.$outer.downstreamIsComplete = true;
                        if (this.$outer.errorThrown != null) {
                            this.signalError(this.$outer.errorThrown);
                        } else {
                            this.signalComplete();
                        }
                        return;
                    }
                    this.$outer.lastIterationAck = ack;
                    int remaining = this.$outer.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$itemsToPush.decrementAndGet(processed);
                    processed = 0;
                    if (remaining > 0) continue;
                    return;
                }
            }

            /*
             * Unable to fully structure code
             */
            private final /* synthetic */ void goAsync$$anonfun$1(Object next$1, Future ack$1, int processed$1, Try x$1) {
                block7: {
                    block6: {
                        var5_5 = x$1;
                        if (!(var5_5 instanceof Success)) ** GOTO lbl-1000
                        var6_6 = (Ack)((Success)var5_5).value();
                        if (!Ack.Continue$.MODULE$.equals(var6_6)) break block6;
                        nextAck = this.signalNext(next$1);
                        v0 = ack$1;
                        var9_8 = Ack.Continue$.MODULE$;
                        if (!(v0 == null ? var9_8 != null : v0.equals(var9_8) == false)) ** GOTO lbl-1000
                        v1 = ack$1;
                        var10_9 = Ack.Stop$.MODULE$;
                        if (!(v1 != null ? v1.equals(var10_9) == false : var10_9 != null)) lbl-1000:
                        // 2 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        isSync = v2;
                        nextFrame = isSync != false ? this.$outer.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$em.nextFrameIndex(0) : 0;
                        this.fastLoop(nextAck, processed$1 + 1, nextFrame);
                        break block7;
                    }
                    if (Ack.Stop$.MODULE$.equals(var6_6)) {
                        this.$outer.downstreamIsComplete = true;
                    } else if (var5_5 instanceof Failure) {
                        ex = ((Failure)var5_5).exception();
                        this.$outer.downstreamIsComplete = true;
                        this.signalError(ex);
                    } else {
                        throw new MatchError((Object)var5_5);
                    }
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{goAsync$$anonfun$1(java.lang.Object scala.concurrent.Future int scala.util.Try )}, serializedLambda);
            }
        };
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public Ack onNext(A elem) {
        Ack.Stop$ stop$;
        if (!this.upstreamIsComplete && !this.downstreamIsComplete) {
            if (elem == null) {
                this.onError(new NullPointerException("Null not supported in onNext"));
                stop$ = Ack.Stop$.MODULE$;
            } else {
                try {
                    Ack.Continue$ continue$;
                    if (this.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$queue.offer(elem) == 0) {
                        this.pushToConsumer();
                        continue$ = Ack.Continue$.MODULE$;
                    } else {
                        this.onError((Throwable)BufferOverflowException$.MODULE$.apply("Downstream observer is too slow, buffer overflowed with a " + ("specified maximum capacity of " + this.capacity)));
                        continue$ = Ack.Stop$.MODULE$;
                    }
                    stop$ = (Ack)continue$;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(ex)) {
                        this.onError(ex);
                        stop$ = Ack.Stop$.MODULE$;
                    }
                    throw throwable;
                }
            }
        } else {
            stop$ = Ack.Stop$.MODULE$;
        }
        return stop$;
    }

    @Override
    public void onError(Throwable ex) {
        if (!this.upstreamIsComplete && !this.downstreamIsComplete) {
            this.errorThrown = ex;
            this.upstreamIsComplete = true;
            this.pushToConsumer();
        }
    }

    @Override
    public void onComplete() {
        if (!this.upstreamIsComplete && !this.downstreamIsComplete) {
            this.upstreamIsComplete = true;
            this.pushToConsumer();
        }
    }

    private void pushToConsumer() {
        int currentNr = this.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$itemsToPush.getAndIncrement(this.monix$reactive$observers$buffers$AbstractSimpleBufferedSubscriber$$itemsToPush.getAndIncrement$default$1());
        if (currentNr == 0) {
            this.scheduler().execute(this.consumerLoop);
        }
    }
}

