/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.observers.buffers;

import java.util.AbstractQueue;
import monix.execution.internal.jctools.queues.MessagePassingQueue;
import monix.reactive.observers.buffers.ConcurrentQueue$;
import scala.collection.mutable.Buffer;

public abstract class ConcurrentQueue<A> {
    public static <A> ConcurrentQueue<A> limited(int n) {
        return ConcurrentQueue$.MODULE$.limited(n);
    }

    public static <A> ConcurrentQueue<A> unbounded() {
        return ConcurrentQueue$.MODULE$.unbounded();
    }

    public abstract boolean isEmpty();

    public abstract A poll();

    public abstract boolean offer(A var1);

    public abstract void drainToBuffer(Buffer<A> var1, int var2);

    private static final class FromAbstractQueue<A>
    extends ConcurrentQueue<A> {
        private final AbstractQueue<A> underlying;

        public <A> FromAbstractQueue(AbstractQueue<A> underlying) {
            this.underlying = underlying;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean offer(A elem) {
            return this.underlying.offer(elem);
        }

        @Override
        public A poll() {
            return (A)this.underlying.poll();
        }

        @Override
        public void drainToBuffer(Buffer<A> buffer, int limit) {
            for (int fetched = 0; fetched < limit; ++fetched) {
                Object next = this.underlying.poll();
                if (next == null) {
                    return;
                }
                buffer.$plus$eq(next);
            }
        }
    }

    private static final class FromMessagePassingQueue<A>
    extends ConcurrentQueue<A> {
        private final MessagePassingQueue<A> underlying;

        public <A> FromMessagePassingQueue(MessagePassingQueue<A> underlying) {
            this.underlying = underlying;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean offer(A elem) {
            return this.underlying.relaxedOffer(elem);
        }

        @Override
        public A poll() {
            return (A)this.underlying.relaxedPoll();
        }

        @Override
        public void drainToBuffer(Buffer<A> buffer, int limit) {
            MessagePassingQueue.Consumer consumer = new MessagePassingQueue.Consumer<A>(buffer){
                private final Buffer buffer$1;
                {
                    this.buffer$1 = buffer$2;
                }

                public void accept(Object e) {
                    this.buffer$1.$plus$eq(e);
                }
            };
            this.underlying.drain(consumer, limit);
        }
    }
}

