/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive;

import java.io.PrintStream;
import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.cancelables.BooleanCancelable;
import monix.reactive.Observer$;
import monix.reactive.Observer$Extensions$;
import org.reactivestreams.Subscriber;
import scala.Function1;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.concurrent.Future;
import scala.util.control.NonFatal$;

public interface Observer<A>
extends Serializable {
    public static <A> Observer Extensions(Observer<A> observer) {
        return Observer$.MODULE$.Extensions(observer);
    }

    public static <A, B> Observer<B> contramap(Observer<A> observer, Function1<B, A> function1) {
        return Observer$.MODULE$.contramap(observer, function1);
    }

    public static <A> Sync<A> dump(String string, PrintStream printStream) {
        return Observer$.MODULE$.dump(string, printStream);
    }

    public static <A> Sync<A> empty(UncaughtExceptionReporter uncaughtExceptionReporter) {
        return Observer$.MODULE$.empty(uncaughtExceptionReporter);
    }

    public static <A> Future<Ack> feed(Observer<A> observer, BooleanCancelable booleanCancelable, Iterable<A> iterable, Scheduler scheduler) {
        return Observer$.MODULE$.feed(observer, booleanCancelable, iterable, scheduler);
    }

    public static <A> Future<Ack> feed(Observer<A> observer, BooleanCancelable booleanCancelable, Iterator<A> iterator, Scheduler scheduler) {
        return Observer$.MODULE$.feed(observer, booleanCancelable, iterator, scheduler);
    }

    public static <A> Future<Ack> feed(Observer<A> observer, Iterable<A> iterable, Scheduler scheduler) {
        return Observer$.MODULE$.feed(observer, iterable, scheduler);
    }

    public static <A> Future<Ack> feed(Observer<A> observer, Iterator<A> iterator, Scheduler scheduler) {
        return Observer$.MODULE$.feed(observer, iterator, scheduler);
    }

    public static <A> Observer<A> fromReactiveSubscriber(Subscriber<A> subscriber, Cancelable cancelable, Scheduler scheduler) {
        return Observer$.MODULE$.fromReactiveSubscriber(subscriber, cancelable, scheduler);
    }

    public static <A> Sync<A> stopped() {
        return Observer$.MODULE$.stopped();
    }

    public static <A> Subscriber<A> toReactiveSubscriber(Observer<A> observer, int n, Scheduler scheduler) {
        return Observer$.MODULE$.toReactiveSubscriber(observer, n, scheduler);
    }

    public static <A> Subscriber<A> toReactiveSubscriber(Observer<A> observer, Scheduler scheduler) {
        return Observer$.MODULE$.toReactiveSubscriber(observer, scheduler);
    }

    public static <A> PrintStream dump$default$2() {
        return Observer$.MODULE$.dump$default$2();
    }

    public Future<Ack> onNext(A var1);

    public void onError(Throwable var1);

    public void onComplete();

    private static final class ContravariantObserver<A, B>
    implements Observer<B> {
        private final Observer<A> source;
        private final Function1<B, A> f;
        private boolean isDone;

        public ContravariantObserver(Observer<A> source, Function1<B, A> f) {
            this.source = source;
            this.f = f;
            this.isDone = false;
        }

        @Override
        public Future<Ack> onNext(B elem) {
            Ack.Stop$ stop$;
            if (this.isDone) {
                stop$ = Ack.Stop$.MODULE$;
            } else {
                boolean streamError = true;
                try {
                    Object b = this.f.apply(elem);
                    streamError = false;
                    stop$ = this.source.onNext(b);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = (Throwable)option.get();
                        if (streamError) {
                            this.onError(ex);
                            stop$ = Ack.Stop$.MODULE$;
                        }
                    }
                    throw throwable;
                }
            }
            return stop$;
        }

        @Override
        public void onError(Throwable ex) {
            if (!this.isDone) {
                this.isDone = true;
                this.source.onError(ex);
            }
        }

        @Override
        public void onComplete() {
            if (!this.isDone) {
                this.isDone = true;
                this.source.onComplete();
            }
        }
    }

    public static class DumpObserver<A>
    implements Sync<A> {
        private final String prefix;
        private final PrintStream out;
        private int pos;

        public DumpObserver(String prefix, PrintStream out) {
            this.prefix = prefix;
            this.out = out;
            this.pos = 0;
        }

        @Override
        public Ack onNext(A elem) {
            this.out.println(new StringBuilder(7).append(this.pos).append(": ").append(this.prefix).append(" --> ").append(elem).toString());
            ++this.pos;
            return Ack.Continue$.MODULE$;
        }

        @Override
        public void onError(Throwable ex) {
            this.out.println(new StringBuilder(7).append(this.pos).append(": ").append(this.prefix).append(" --> ").append(ex).toString());
            ++this.pos;
        }

        @Override
        public void onComplete() {
            this.out.println(new StringBuilder(12).append(this.pos).append(": ").append(this.prefix).append(" completed").toString());
            ++this.pos;
        }
    }

    public static final class Extensions<A> {
        private final Observer target;

        public static <B, A> Observer<B> contramap$extension(Observer observer, Function1<B, A> function1) {
            return Observer$Extensions$.MODULE$.contramap$extension(observer, function1);
        }

        public static <A> boolean equals$extension(Observer observer, Object object) {
            return Observer$Extensions$.MODULE$.equals$extension(observer, object);
        }

        public static <A> Future<Ack> feed$extension(Observer observer, BooleanCancelable booleanCancelable, Iterable<A> iterable, Scheduler scheduler) {
            return Observer$Extensions$.MODULE$.feed$extension(observer, booleanCancelable, iterable, scheduler);
        }

        public static <A> Future<Ack> feed$extension(Observer observer, BooleanCancelable booleanCancelable, Iterator<A> iterator, Scheduler scheduler) {
            return Observer$Extensions$.MODULE$.feed$extension(observer, booleanCancelable, iterator, scheduler);
        }

        public static <A> Future<Ack> feed$extension(Observer observer, Iterable<A> iterable, Scheduler scheduler) {
            return Observer$Extensions$.MODULE$.feed$extension(observer, iterable, scheduler);
        }

        public static <A> Future<Ack> feed$extension(Observer observer, Iterator<A> iterator, Scheduler scheduler) {
            return Observer$Extensions$.MODULE$.feed$extension(observer, iterator, scheduler);
        }

        public static <A> int hashCode$extension(Observer observer) {
            return Observer$Extensions$.MODULE$.hashCode$extension(observer);
        }

        public static <A> Future<Ack> onNextAll$extension(Observer observer, Iterable<A> iterable, Scheduler scheduler) {
            return Observer$Extensions$.MODULE$.onNextAll$extension(observer, iterable, scheduler);
        }

        public static <A> Subscriber<A> toReactive$extension(Observer observer, int n, Scheduler scheduler) {
            return Observer$Extensions$.MODULE$.toReactive$extension(observer, n, scheduler);
        }

        public static <A> Subscriber<A> toReactive$extension(Observer observer, Scheduler scheduler) {
            return Observer$Extensions$.MODULE$.toReactive$extension(observer, scheduler);
        }

        public Extensions(Observer<A> target) {
            this.target = target;
        }

        public int hashCode() {
            return Observer$Extensions$.MODULE$.hashCode$extension(this.target());
        }

        public boolean equals(Object x$0) {
            return Observer$Extensions$.MODULE$.equals$extension(this.target(), x$0);
        }

        public Observer<A> target() {
            return this.target;
        }

        public Subscriber<A> toReactive(Scheduler s) {
            return Observer$Extensions$.MODULE$.toReactive$extension(this.target(), s);
        }

        public Subscriber<A> toReactive(int requestCount, Scheduler s) {
            return Observer$Extensions$.MODULE$.toReactive$extension(this.target(), requestCount, s);
        }

        public Future<Ack> onNextAll(Iterable<A> xs, Scheduler s) {
            return Observer$Extensions$.MODULE$.onNextAll$extension(this.target(), xs, s);
        }

        public Future<Ack> feed(Iterable<A> iterable, Scheduler s) {
            return Observer$Extensions$.MODULE$.feed$extension(this.target(), iterable, s);
        }

        public Future<Ack> feed(BooleanCancelable subscription, Iterable<A> iterable, Scheduler s) {
            return Observer$Extensions$.MODULE$.feed$extension(this.target(), subscription, iterable, s);
        }

        public Future<Ack> feed(Iterator<A> iterator, Scheduler s) {
            return Observer$Extensions$.MODULE$.feed$extension(this.target(), iterator, s);
        }

        public Future<Ack> feed(BooleanCancelable subscription, Iterator<A> iterator, Scheduler s) {
            return Observer$Extensions$.MODULE$.feed$extension(this.target(), subscription, iterator, s);
        }

        public <B> Observer<B> contramap(Function1<B, A> f) {
            return Observer$Extensions$.MODULE$.contramap$extension(this.target(), f);
        }
    }

    public static interface Sync<A>
    extends Observer<A> {
        public Ack onNext(A var1);
    }
}

