/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.compression.internal.operators;

import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import monix.reactive.compression.CompressionException$;
import monix.reactive.compression.internal.operators.Gunzipper$;
import monix.reactive.compression.package$;
import monix.reactive.compression.package$gzipCompressionMethod$;
import monix.reactive.compression.package$gzipFlag$;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Gunzipper {
    public final int monix$reactive$compression$internal$operators$Gunzipper$$bufferSize;
    private State state;

    public Gunzipper(int bufferSize) {
        this.monix$reactive$compression$internal$operators$Gunzipper$$bufferSize = bufferSize;
        this.state = new ParseHeaderStep(this, Array$.MODULE$.emptyByteArray(), new CRC32());
    }

    public void close() {
        this.state.close();
    }

    public byte[] onChunk(byte[] c) {
        byte[] byArray;
        try {
            Tuple2<State, byte[]> tuple2 = this.state.feed(c);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            State newState = (State)tuple2._1();
            byte[] output = (byte[])tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)newState, (Object)output);
            State newState2 = (State)tuple22._1();
            byte[] output2 = (byte[])tuple22._2();
            this.state = newState2;
            byArray = output2;
        }
        catch (DataFormatException e) {
            throw CompressionException$.MODULE$.apply(e);
        }
        return byArray;
    }

    public byte[] finish() {
        if (this.state.isInProgress()) {
            throw CompressionException$.MODULE$.apply("Stream closed before completion.", CompressionException$.MODULE$.apply$default$2());
        }
        return Array$.MODULE$.emptyByteArray();
    }

    public State monix$reactive$compression$internal$operators$Gunzipper$$nextStep(byte[] acc, boolean checkCrc16, CRC32 crc32, boolean parseExtra, int commentsToSkip) {
        return parseExtra ? new ParseExtraStep(this, acc, crc32, checkCrc16, commentsToSkip) : (commentsToSkip > 0 ? new SkipCommentsStep(this, checkCrc16, crc32, commentsToSkip) : (checkCrc16 ? new CheckCrc16Step(this, Array$.MODULE$.emptyByteArray(), crc32.getValue()) : new Decompress()));
    }

    private class CheckCrc16Step
    implements State {
        private final byte[] pastCrc16Bytes;
        private final long crcValue;
        private final /* synthetic */ Gunzipper $outer;

        public CheckCrc16Step(Gunzipper $outer, byte[] pastCrc16Bytes, long crcValue) {
            this.pastCrc16Bytes = pastCrc16Bytes;
            this.crcValue = crcValue;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Tuple2<State, byte[]> feed(byte[] chunkBytes) {
            Tuple2<State, byte[]> tuple2;
            Object object = Predef$.MODULE$.byteArrayOps(this.pastCrc16Bytes);
            Object object2 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)chunkBytes, ClassTag$.MODULE$.apply(Byte.TYPE)));
            Tuple2 tuple22 = ArrayOps$.MODULE$.splitAt$extension(object2, 2);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            byte[] crc16Bytes = (byte[])tuple22._1();
            byte[] leftover = (byte[])tuple22._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)crc16Bytes, (Object)leftover);
            byte[] crc16Bytes2 = (byte[])tuple23._1();
            byte[] leftover2 = (byte[])tuple23._2();
            if (crc16Bytes2.length < 2) {
                tuple2 = Tuple2$.MODULE$.apply((Object)new CheckCrc16Step(this.$outer, crc16Bytes2, this.crcValue), (Object)Array$.MODULE$.emptyByteArray());
            } else {
                int computedCrc16 = (int)(this.crcValue & 0xFFFFL);
                int expectedCrc = Gunzipper$.MODULE$.monix$reactive$compression$internal$operators$Gunzipper$$$u16(crc16Bytes2[0], crc16Bytes2[1]);
                if (computedCrc16 != expectedCrc) {
                    throw CompressionException$.MODULE$.apply("Invalid header CRC16", CompressionException$.MODULE$.apply$default$2());
                }
                tuple2 = this.$outer.new Decompress().feed(leftover2);
            }
            return tuple2;
        }

        public final /* synthetic */ Gunzipper monix$reactive$compression$internal$operators$Gunzipper$CheckCrc16Step$$$outer() {
            return this.$outer;
        }
    }

    private class CheckTrailerStep
    implements State {
        private final byte[] acc;
        private final long expectedCrc32;
        private final long expectedIsize;
        private final /* synthetic */ Gunzipper $outer;

        public CheckTrailerStep(Gunzipper $outer, byte[] acc, long expectedCrc32, long expectedIsize) {
            this.acc = acc;
            this.expectedCrc32 = expectedCrc32;
            this.expectedIsize = expectedIsize;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        private int readInt(byte[] a) {
            return Gunzipper$.MODULE$.monix$reactive$compression$internal$operators$Gunzipper$$$u32(a[0], a[1], a[2], a[3]);
        }

        @Override
        public Tuple2<State, byte[]> feed(byte[] chunkBytes) {
            Tuple2<State, byte[]> tuple2;
            Object object = Predef$.MODULE$.byteArrayOps(this.acc);
            byte[] bytes = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)chunkBytes, ClassTag$.MODULE$.apply(Byte.TYPE));
            if (bytes.length < 8) {
                tuple2 = Tuple2$.MODULE$.apply((Object)new CheckTrailerStep(this.$outer, bytes, this.expectedCrc32, this.expectedIsize), (Object)Array$.MODULE$.emptyByteArray());
            } else {
                Object object2 = Predef$.MODULE$.byteArrayOps(bytes);
                Tuple2 tuple22 = ArrayOps$.MODULE$.splitAt$extension(object2, 8);
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                byte[] trailerBytes = (byte[])tuple22._1();
                byte[] leftover = (byte[])tuple22._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)trailerBytes, (Object)leftover);
                byte[] trailerBytes2 = (byte[])tuple23._1();
                byte[] leftover2 = (byte[])tuple23._2();
                Object object3 = Predef$.MODULE$.byteArrayOps(trailerBytes2);
                int crc32 = this.readInt((byte[])ArrayOps$.MODULE$.take$extension(object3, 4));
                Object object4 = Predef$.MODULE$.byteArrayOps(trailerBytes2);
                int isize = this.readInt((byte[])ArrayOps$.MODULE$.drop$extension(object4, 4));
                if ((int)this.expectedCrc32 != crc32) {
                    throw CompressionException$.MODULE$.apply("Invalid CRC32", CompressionException$.MODULE$.apply$default$2());
                }
                if ((int)this.expectedIsize != isize) {
                    throw CompressionException$.MODULE$.apply("Invalid ISIZE", CompressionException$.MODULE$.apply$default$2());
                }
                tuple2 = new ParseHeaderStep(this.$outer, Array$.MODULE$.emptyByteArray(), new CRC32()).feed(leftover2);
            }
            return tuple2;
        }

        public final /* synthetic */ Gunzipper monix$reactive$compression$internal$operators$Gunzipper$CheckTrailerStep$$$outer() {
            return this.$outer;
        }
    }

    private class Decompress
    implements State {
        private final Inflater inflater;
        private final CRC32 crc32;
        private final byte[] buffer;

        public Decompress() {
            if (Gunzipper.this == null) {
                throw new NullPointerException();
            }
            this.inflater = new Inflater(true);
            this.crc32 = new CRC32();
            this.buffer = new byte[Gunzipper.this.monix$reactive$compression$internal$operators$Gunzipper$$bufferSize];
        }

        private byte[] pullOutput(Inflater inflater, byte[] buffer) {
            return inflater.needsInput() ? Array$.MODULE$.emptyByteArray() : this.next$1(inflater, buffer, Array$.MODULE$.emptyByteArray());
        }

        @Override
        public void close() {
            this.inflater.end();
        }

        @Override
        public Tuple2<State, byte[]> feed(byte[] chunkBytes) {
            Tuple2 tuple2;
            this.inflater.setInput(chunkBytes);
            byte[] newChunk = this.pullOutput(this.inflater, this.buffer);
            if (this.inflater.finished()) {
                Object object = Predef$.MODULE$.byteArrayOps(chunkBytes);
                byte[] leftover = (byte[])ArrayOps$.MODULE$.takeRight$extension(object, this.inflater.getRemaining());
                Tuple2<State, byte[]> tuple22 = new CheckTrailerStep(Gunzipper.this, Array$.MODULE$.emptyByteArray(), this.crc32.getValue(), this.inflater.getBytesWritten()).feed(leftover);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                State state = (State)tuple22._1();
                byte[] nextChunks = (byte[])tuple22._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)state, (Object)nextChunks);
                State state2 = (State)tuple23._1();
                byte[] nextChunks2 = (byte[])tuple23._2();
                Object object2 = Predef$.MODULE$.byteArrayOps(newChunk);
                tuple2 = Tuple2$.MODULE$.apply((Object)state2, ArrayOps$.MODULE$.$plus$plus$extension(object2, (Object)nextChunks2, ClassTag$.MODULE$.apply(Byte.TYPE)));
            } else {
                tuple2 = Tuple2$.MODULE$.apply((Object)this, (Object)newChunk);
            }
            return tuple2;
        }

        public final /* synthetic */ Gunzipper monix$reactive$compression$internal$operators$Gunzipper$Decompress$$$outer() {
            return Gunzipper.this;
        }

        private final byte[] next$1(Inflater inflater$1, byte[] buffer$1, byte[] prev) {
            byte[] pulled;
            byte[] byArray = prev;
            while (true) {
                int read = inflater$1.inflate(buffer$1);
                byte[] newBytes = Arrays.copyOf(buffer$1, read);
                this.crc32.update(newBytes);
                Object object = Predef$.MODULE$.byteArrayOps(byArray);
                pulled = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)newBytes, ClassTag$.MODULE$.apply(Byte.TYPE));
                if (read <= 0 || inflater$1.getRemaining() <= 0) break;
                byArray = pulled;
            }
            return pulled;
        }
    }

    private class ParseExtraStep
    implements State {
        private final byte[] acc;
        private final CRC32 crc32;
        private final boolean checkCrc16;
        private final int commentsToSkip;
        private final /* synthetic */ Gunzipper $outer;

        public ParseExtraStep(Gunzipper $outer, byte[] acc, CRC32 crc32, boolean checkCrc16, int commentsToSkip) {
            this.acc = acc;
            this.crc32 = crc32;
            this.checkCrc16 = checkCrc16;
            this.commentsToSkip = commentsToSkip;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Tuple2<State, byte[]> feed(byte[] chunkBytes) {
            Tuple2<State, byte[]> tuple2;
            Object object = Predef$.MODULE$.byteArrayOps(this.acc);
            byte[] bytes = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)chunkBytes, ClassTag$.MODULE$.apply(Byte.TYPE));
            if (bytes.length < 12) {
                tuple2 = Tuple2$.MODULE$.apply((Object)new ParseExtraStep(this.$outer, bytes, this.crc32, this.checkCrc16, this.commentsToSkip), (Object)Array$.MODULE$.emptyByteArray());
            } else {
                int xlenLenght = 2;
                int extraBytes = Gunzipper$.MODULE$.monix$reactive$compression$internal$operators$Gunzipper$$$u16(bytes[Gunzipper$.monix$reactive$compression$internal$operators$Gunzipper$$$fixedHeaderLength], bytes[Gunzipper$.monix$reactive$compression$internal$operators$Gunzipper$$$fixedHeaderLength + 1]);
                int headerWithExtraLength = Gunzipper$.monix$reactive$compression$internal$operators$Gunzipper$$$fixedHeaderLength + xlenLenght + extraBytes;
                if (bytes.length < headerWithExtraLength) {
                    tuple2 = Tuple2$.MODULE$.apply((Object)new ParseExtraStep(this.$outer, bytes, this.crc32, this.checkCrc16, this.commentsToSkip), (Object)Array$.MODULE$.emptyByteArray());
                } else {
                    Object object2 = Predef$.MODULE$.byteArrayOps(bytes);
                    Tuple2 tuple22 = ArrayOps$.MODULE$.splitAt$extension(object2, headerWithExtraLength);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    byte[] headerWithExtra = (byte[])tuple22._1();
                    byte[] leftover = (byte[])tuple22._2();
                    Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)headerWithExtra, (Object)leftover);
                    byte[] headerWithExtra2 = (byte[])tuple23._1();
                    byte[] leftover2 = (byte[])tuple23._2();
                    Object object3 = Predef$.MODULE$.byteArrayOps(headerWithExtra2);
                    this.crc32.update((byte[])ArrayOps$.MODULE$.drop$extension(object3, Gunzipper$.monix$reactive$compression$internal$operators$Gunzipper$$$fixedHeaderLength));
                    tuple2 = this.$outer.monix$reactive$compression$internal$operators$Gunzipper$$nextStep(headerWithExtra2, this.checkCrc16, this.crc32, false, this.commentsToSkip).feed(leftover2);
                }
            }
            return tuple2;
        }

        public final /* synthetic */ Gunzipper monix$reactive$compression$internal$operators$Gunzipper$ParseExtraStep$$$outer() {
            return this.$outer;
        }
    }

    private class ParseHeaderStep
    implements State {
        private final byte[] acc;
        private final CRC32 crc32;
        private final /* synthetic */ Gunzipper $outer;

        public ParseHeaderStep(Gunzipper $outer, byte[] acc, CRC32 crc32) {
            this.acc = acc;
            this.crc32 = crc32;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Tuple2<State, byte[]> feed(byte[] chunkBytes) {
            Tuple2<State, byte[]> tuple2;
            Object object = Predef$.MODULE$.byteArrayOps(this.acc);
            byte[] bytes = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)chunkBytes, ClassTag$.MODULE$.apply(Byte.TYPE));
            if (bytes.length < Gunzipper$.monix$reactive$compression$internal$operators$Gunzipper$$$fixedHeaderLength) {
                tuple2 = Tuple2$.MODULE$.apply((Object)new ParseHeaderStep(this.$outer, bytes, this.crc32), (Object)Array$.MODULE$.emptyByteArray());
            } else {
                Object object2 = Predef$.MODULE$.byteArrayOps(bytes);
                Tuple2 tuple22 = ArrayOps$.MODULE$.splitAt$extension(object2, Gunzipper$.monix$reactive$compression$internal$operators$Gunzipper$$$fixedHeaderLength);
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                byte[] header = (byte[])tuple22._1();
                byte[] leftover = (byte[])tuple22._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)header, (Object)leftover);
                byte[] header2 = (byte[])tuple23._1();
                byte[] leftover2 = (byte[])tuple23._2();
                this.crc32.update(header2);
                if (header2[0] != package$.MODULE$.gzipMagicFirstByte() || header2[1] != package$.MODULE$.gzipMagicSecondByte()) {
                    throw CompressionException$.MODULE$.apply("Invalid GZIP header", CompressionException$.MODULE$.apply$default$2());
                }
                if (header2[2] != package$gzipCompressionMethod$.MODULE$.DEFLATE()) {
                    throw CompressionException$.MODULE$.apply(new StringBuilder(59).append("Only deflate (8) compression method is supported, present: ").append(header2[2]).toString(), CompressionException$.MODULE$.apply$default$2());
                }
                byte flags = header2[3];
                boolean checkCrc16 = package$gzipFlag$.MODULE$.fhcrc(flags);
                boolean hasExtra = package$gzipFlag$.MODULE$.fextra(flags);
                boolean skipFileName = package$gzipFlag$.MODULE$.fname(flags);
                boolean skipFileComment = package$gzipFlag$.MODULE$.fcomment(flags);
                int commentsToSkip = (skipFileName ? 1 : 0) + (skipFileComment ? 1 : 0);
                tuple2 = this.$outer.monix$reactive$compression$internal$operators$Gunzipper$$nextStep(header2, checkCrc16, this.crc32, hasExtra, commentsToSkip).feed(leftover2);
            }
            return tuple2;
        }

        @Override
        public boolean isInProgress() {
            Object object = Predef$.MODULE$.byteArrayOps(this.acc);
            return ArrayOps$.MODULE$.nonEmpty$extension(object);
        }

        public final /* synthetic */ Gunzipper monix$reactive$compression$internal$operators$Gunzipper$ParseHeaderStep$$$outer() {
            return this.$outer;
        }
    }

    private class SkipCommentsStep
    implements State {
        private final boolean checkCrc16;
        private final CRC32 crc32;
        private final int commentsToSkip;
        private final /* synthetic */ Gunzipper $outer;

        public SkipCommentsStep(Gunzipper $outer, boolean checkCrc16, CRC32 crc32, int commentsToSkip) {
            this.checkCrc16 = checkCrc16;
            this.crc32 = crc32;
            this.commentsToSkip = commentsToSkip;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Tuple2<State, byte[]> feed(byte[] chunkBytes) {
            Tuple2 tuple2;
            Tuple2 tuple22;
            Object object = Predef$.MODULE$.byteArrayOps(chunkBytes);
            int idx = ArrayOps$.MODULE$.indexOf$extension(object, (Object)BoxesRunTime.boxToByte((byte)0), ArrayOps$.MODULE$.indexOf$default$2$extension(object));
            if (idx == -1) {
                tuple22 = Tuple2$.MODULE$.apply((Object)chunkBytes, (Object)Array$.MODULE$.emptyByteArray());
            } else {
                Object object2 = Predef$.MODULE$.byteArrayOps(chunkBytes);
                tuple22 = tuple2 = ArrayOps$.MODULE$.splitAt$extension(object2, idx + 1);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] upTo0 = (byte[])tuple2._1();
            byte[] leftover = (byte[])tuple2._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)upTo0, (Object)leftover);
            byte[] upTo02 = (byte[])tuple23._1();
            byte[] leftover2 = (byte[])tuple23._2();
            this.crc32.update(upTo02);
            return this.$outer.monix$reactive$compression$internal$operators$Gunzipper$$nextStep(Array$.MODULE$.emptyByteArray(), this.checkCrc16, this.crc32, false, this.commentsToSkip - 1).feed(leftover2);
        }

        public final /* synthetic */ Gunzipper monix$reactive$compression$internal$operators$Gunzipper$SkipCommentsStep$$$outer() {
            return this.$outer;
        }
    }

    private static interface State {
        public static void close$(State $this) {
            $this.close();
        }

        default public void close() {
        }

        public Tuple2<State, byte[]> feed(byte[] var1);

        public static boolean isInProgress$(State $this) {
            return $this.isInProgress();
        }

        default public boolean isInProgress() {
            return true;
        }
    }
}

