/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.cancelables.CompositeCancelable;
import monix.execution.cancelables.CompositeCancelable$;
import monix.execution.cancelables.MultiAssignCancelable;
import monix.execution.cancelables.MultiAssignCancelable$;
import monix.execution.cancelables.SingleAssignCancelable;
import monix.execution.cancelables.SingleAssignCancelable$;
import monix.reactive.Observable;
import monix.reactive.internal.operators.DebounceObservable$;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class DebounceObservable<A>
extends Observable<A> {
    private final Observable<A> source;
    public final FiniteDuration monix$reactive$internal$operators$DebounceObservable$$timeout;
    public final boolean monix$reactive$internal$operators$DebounceObservable$$repeat;

    public DebounceObservable(Observable<A> source, FiniteDuration timeout, boolean repeat) {
        this.source = source;
        this.monix$reactive$internal$operators$DebounceObservable$$timeout = timeout;
        this.monix$reactive$internal$operators$DebounceObservable$$repeat = repeat;
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> out) {
        MultiAssignCancelable task = MultiAssignCancelable$.MODULE$.apply();
        SingleAssignCancelable mainTask = SingleAssignCancelable$.MODULE$.apply();
        CompositeCancelable composite = CompositeCancelable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Cancelable[]{mainTask, task}));
        mainTask.$colon$eq(this.source.unsafeSubscribeFn(new Subscriber.Sync<A>(out, task, mainTask, this){
            private final Subscriber out$2;
            private final MultiAssignCancelable task$2;
            private final SingleAssignCancelable mainTask$2;
            private final Scheduler scheduler;
            private final long timeoutMillis;
            private boolean isDone;
            private Object lastEvent;
            private long lastTSInMillis;
            private boolean hasValue;
            private final /* synthetic */ DebounceObservable $outer;
            {
                this.out$2 = out$1;
                this.task$2 = task$1;
                this.mainTask$2 = mainTask$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.scheduler = out$1.scheduler();
                this.timeoutMillis = $outer.monix$reactive$internal$operators$DebounceObservable$$timeout.toMillis();
                this.isDone = false;
                this.lastTSInMillis = 0L;
                this.hasValue = false;
                this.scheduleNext(this.timeoutMillis);
                Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
            }

            public Scheduler scheduler() {
                return this.scheduler;
            }

            public void scheduleNext(long delayMillis) {
                this.task$2.$colon$eq(this.scheduler().scheduleOnce(delayMillis, TimeUnit.MILLISECONDS, (Runnable)this));
            }

            public void run() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.isDone) {
                        if (this.lastEvent == null || !this.hasValue) {
                            this.scheduleNext(this.timeoutMillis);
                        } else {
                            long rightNow = this.scheduler().clockMonotonic(package$.MODULE$.MILLISECONDS());
                            long sinceLastOnNext = rightNow - this.lastTSInMillis;
                            if (sinceLastOnNext >= this.timeoutMillis) {
                                this.hasValue = this.$outer.monix$reactive$internal$operators$DebounceObservable$$repeat;
                                Future future = Ack$.MODULE$.AckExtensions(this.out$2.onNext(this.lastEvent));
                                Ack.AckExtensions$.MODULE$.syncFlatMap$extension(future, (Function1 & Serializable)x$1 -> {
                                    Ack.Continue$ continue$;
                                    Ack ack = x$1;
                                    if (Ack.Continue$.MODULE$.equals(ack)) {
                                        long executionTime = this.scheduler().clockMonotonic(package$.MODULE$.MILLISECONDS()) - rightNow;
                                        long delay = this.timeoutMillis > executionTime ? this.timeoutMillis - executionTime : 0L;
                                        this.scheduleNext(delay);
                                        continue$ = Ack.Continue$.MODULE$;
                                    } else if (Ack.Stop$.MODULE$.equals(ack)) {
                                        $anon$1 var9_6 = this;
                                        synchronized (var9_6) {
                                            this.isDone = true;
                                            this.mainTask$2.cancel();
                                        }
                                        continue$ = Ack.Stop$.MODULE$;
                                    } else {
                                        throw new MatchError((Object)ack);
                                    }
                                    return (Future)continue$;
                                }, (UncaughtExceptionReporter)this.scheduler());
                            } else {
                                long remainingTime = this.timeoutMillis - sinceLastOnNext;
                                this.scheduleNext(remainingTime);
                            }
                        }
                    }
                }
            }

            public Ack onNext(Object elem) {
                Ack ack;
                $anon$1 var2_2 = this;
                synchronized (var2_2) {
                    Ack.Stop$ stop$;
                    if (!this.isDone) {
                        this.lastEvent = elem;
                        this.lastTSInMillis = this.scheduler().clockMonotonic(package$.MODULE$.MILLISECONDS());
                        this.hasValue = true;
                        stop$ = Ack.Continue$.MODULE$;
                    } else {
                        stop$ = Ack.Stop$.MODULE$;
                    }
                    ack = (Ack)stop$;
                }
                return ack;
            }

            public void onError(Throwable ex) {
                $anon$1 var2_2 = this;
                synchronized (var2_2) {
                    BoxedUnit boxedUnit;
                    if (!this.isDone) {
                        this.isDone = true;
                        this.task$2.cancel();
                        this.out$2.onError(ex);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            public void onComplete() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    BoxedUnit boxedUnit;
                    if (!this.isDone) {
                        this.isDone = true;
                        this.task$2.cancel();
                        this.out$2.onComplete();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{run$$anonfun$1(long monix.execution.Ack )}, serializedLambda);
            }
        }));
        return composite;
    }
}

