/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.observables;

import monix.execution.Cancelable;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.reactive.Observable;
import monix.reactive.observables.CachedObservable$;
import monix.reactive.observers.Subscriber;
import monix.reactive.observers.Subscriber$;
import monix.reactive.subjects.ReplaySubject;
import monix.reactive.subjects.ReplaySubject$;
import scala.runtime.ScalaRunTime$;

public final class CachedObservable<A>
extends Observable<A> {
    private final Observable<A> source;
    private final AtomicBoolean isStarted;
    private final ReplaySubject<A> subject;

    public static <A> Observable<A> create(Observable<A> observable) {
        return CachedObservable$.MODULE$.create(observable);
    }

    public static <A> Observable<A> create(Observable<A> observable, int n) {
        return CachedObservable$.MODULE$.create(observable, n);
    }

    public CachedObservable(Observable<A> source, int maxCapacity) {
        this.source = source;
        this.isStarted = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
        this.subject = maxCapacity > 0 ? ReplaySubject$.MODULE$.createLimited(maxCapacity) : ReplaySubject$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> subscriber) {
        if (this.isStarted.compareAndSet(false, true)) {
            this.source.unsafeSubscribeFn(Subscriber$.MODULE$.apply(this.subject, subscriber.scheduler()));
        }
        return this.subject.unsafeSubscribeFn(subscriber);
    }
}

