/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.observers;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.Cancelable;
import monix.execution.CancelableFuture;
import monix.execution.CancelableFuture$;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.reactive.Observable$;
import monix.reactive.observers.ConnectableSubscriber$;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ConnectableSubscriber<A>
implements Subscriber<A> {
    public final Subscriber<A> monix$reactive$observers$ConnectableSubscriber$$underlying;
    private final Scheduler scheduler;
    private ArrayBuffer<A> queue;
    public boolean monix$reactive$observers$ConnectableSubscriber$$scheduledDone;
    public Throwable monix$reactive$observers$ConnectableSubscriber$$scheduledError;
    private boolean isConnectionStarted;
    private boolean wasCanceled;
    private Promise<Ack> connectedPromise;
    private Future<Ack> connectedFuture;
    private volatile boolean isConnected;
    private CancelableFuture<Ack> connectionRef;

    public static <A> ConnectableSubscriber<A> apply(Subscriber<A> subscriber) {
        return ConnectableSubscriber$.MODULE$.apply(subscriber);
    }

    public ConnectableSubscriber(Subscriber<A> underlying) {
        this.monix$reactive$observers$ConnectableSubscriber$$underlying = underlying;
        this.scheduler = underlying.scheduler();
        this.queue = ArrayBuffer$.MODULE$.empty();
        this.monix$reactive$observers$ConnectableSubscriber$$scheduledDone = false;
        this.monix$reactive$observers$ConnectableSubscriber$$scheduledError = null;
        this.isConnectionStarted = false;
        this.wasCanceled = false;
        this.connectedPromise = Promise$.MODULE$.apply();
        this.connectedFuture = this.connectedPromise.future();
        this.isConnected = false;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    public CancelableFuture<Ack> connect() {
        CancelableFuture<Ack> cancelableFuture;
        ConnectableSubscriber connectableSubscriber = this;
        synchronized (connectableSubscriber) {
            if (!this.isConnected && !this.isConnectionStarted) {
                this.isConnectionStarted = true;
                Promise bufferWasDrained = Promise$.MODULE$.apply();
                Cancelable cancelable = Observable$.MODULE$.fromIterable(this.queue).unsafeSubscribeFn(new Subscriber<A>(bufferWasDrained, this){
                    private final Promise bufferWasDrained$2;
                    private final Scheduler scheduler;
                    private Future ack;
                    private final /* synthetic */ ConnectableSubscriber $outer;
                    {
                        this.bufferWasDrained$2 = bufferWasDrained$1;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.scheduler = $outer.monix$reactive$observers$ConnectableSubscriber$$underlying.scheduler();
                        this.ack = Ack.Continue$.MODULE$;
                        bufferWasDrained$1.future().onComplete((Function1)((JProcedure1 & Serializable)arg_0 -> ConnectableSubscriber.monix$reactive$observers$ConnectableSubscriber$$anon$1$$_$$lessinit$greater$$anonfun$1($outer, arg_0)), (ExecutionContext)this.scheduler());
                    }

                    public Scheduler scheduler() {
                        return this.scheduler;
                    }

                    public Future onNext(Object elem) {
                        Future future = Ack$.MODULE$.AckExtensions(this.$outer.monix$reactive$observers$ConnectableSubscriber$$underlying.onNext(elem));
                        this.ack = Ack.AckExtensions$.MODULE$.syncOnStopFollow$extension(future, this.bufferWasDrained$2, (Object)Ack.Stop$.MODULE$);
                        return this.ack;
                    }

                    public void onComplete() {
                        BoxedUnit boxedUnit;
                        if (!this.$outer.monix$reactive$observers$ConnectableSubscriber$$scheduledDone) {
                            Future future = Ack$.MODULE$.AckExtensions(this.ack);
                            boxedUnit = Ack.AckExtensions$.MODULE$.syncOnContinue$extension(future, (Function0)((JFunction0.mcV.sp & Serializable)this::onComplete$$anonfun$1), (UncaughtExceptionReporter)this.scheduler());
                        } else if (this.$outer.monix$reactive$observers$ConnectableSubscriber$$scheduledError != null) {
                            if (this.bufferWasDrained$2.trySuccess((Object)Ack.Stop$.MODULE$)) {
                                this.$outer.monix$reactive$observers$ConnectableSubscriber$$underlying.onError(this.$outer.monix$reactive$observers$ConnectableSubscriber$$scheduledError);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else if (this.bufferWasDrained$2.trySuccess((Object)Ack.Stop$.MODULE$)) {
                            this.$outer.monix$reactive$observers$ConnectableSubscriber$$underlying.onComplete();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }

                    public void onError(Throwable ex) {
                        if (this.$outer.monix$reactive$observers$ConnectableSubscriber$$scheduledError != null) {
                            this.scheduler().reportFailure(ex);
                        } else {
                            this.$outer.monix$reactive$observers$ConnectableSubscriber$$scheduledDone = true;
                            this.$outer.monix$reactive$observers$ConnectableSubscriber$$scheduledError = ex;
                            if (this.bufferWasDrained$2.trySuccess((Object)Ack.Stop$.MODULE$)) {
                                this.$outer.monix$reactive$observers$ConnectableSubscriber$$underlying.onError(ex);
                            } else {
                                this.scheduler().reportFailure(ex);
                            }
                        }
                    }

                    private final void onComplete$$anonfun$1() {
                        this.bufferWasDrained$2.trySuccess((Object)Ack.Continue$.MODULE$);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{monix$reactive$observers$ConnectableSubscriber$$anon$1$$_$$lessinit$greater$$anonfun$1(monix.reactive.observers.ConnectableSubscriber scala.util.Try ), onComplete$$anonfun$1()}, serializedLambda);
                    }
                });
                this.connectionRef = CancelableFuture$.MODULE$.apply(bufferWasDrained.future(), cancelable);
            }
            cancelableFuture = this.connectionRef;
        }
        return cancelableFuture;
    }

    public void pushFirst(A elem) {
        ConnectableSubscriber connectableSubscriber = this;
        synchronized (connectableSubscriber) {
            block5: {
                if (!this.isConnected && !this.isConnectionStarted) break block5;
                throw new IllegalStateException("Observer was already connected, so cannot pushFirst");
            }
            if (!this.monix$reactive$observers$ConnectableSubscriber$$scheduledDone) {
                this.queue.$plus$eq(elem);
            }
        }
    }

    public <U extends A> void pushFirstAll(Iterable<U> xs) {
        ConnectableSubscriber connectableSubscriber = this;
        synchronized (connectableSubscriber) {
            block5: {
                if (!this.isConnected && !this.isConnectionStarted) break block5;
                throw new IllegalStateException("Observer was already connected, so cannot pushFirst");
            }
            if (!this.monix$reactive$observers$ConnectableSubscriber$$scheduledDone) {
                this.queue.appendAll(xs);
            }
        }
    }

    public void pushComplete() {
        ConnectableSubscriber connectableSubscriber = this;
        synchronized (connectableSubscriber) {
            BoxedUnit boxedUnit;
            block6: {
                if (!this.isConnected && !this.isConnectionStarted) break block6;
                throw new IllegalStateException("Observer was already connected, so cannot pushFirst");
            }
            if (!this.monix$reactive$observers$ConnectableSubscriber$$scheduledDone) {
                this.monix$reactive$observers$ConnectableSubscriber$$scheduledDone = true;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void pushError(Throwable ex) {
        ConnectableSubscriber connectableSubscriber = this;
        synchronized (connectableSubscriber) {
            BoxedUnit boxedUnit;
            block6: {
                if (!this.isConnected && !this.isConnectionStarted) break block6;
                throw new IllegalStateException("Observer was already connected, so cannot pushFirst");
            }
            if (!this.monix$reactive$observers$ConnectableSubscriber$$scheduledDone) {
                this.monix$reactive$observers$ConnectableSubscriber$$scheduledDone = true;
                this.monix$reactive$observers$ConnectableSubscriber$$scheduledError = ex;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public Future<Ack> onNext(A elem) {
        Future<Ack> future;
        if (!this.isConnected) {
            this.connectedFuture = this.connectedFuture.flatMap((Function1 & Serializable)x$1 -> {
                Ack.Stop$ stop$;
                Ack ack = x$1;
                if (Ack.Continue$.MODULE$.equals(ack)) {
                    stop$ = this.monix$reactive$observers$ConnectableSubscriber$$underlying.onNext(elem);
                } else if (Ack.Stop$.MODULE$.equals(ack)) {
                    stop$ = Ack.Stop$.MODULE$;
                } else {
                    throw new MatchError((Object)ack);
                }
                return stop$;
            }, (ExecutionContext)this.scheduler());
            future = this.connectedFuture;
        } else {
            future = !this.wasCanceled ? this.monix$reactive$observers$ConnectableSubscriber$$underlying.onNext(elem) : Ack.Stop$.MODULE$;
        }
        return future;
    }

    @Override
    public void onComplete() {
        Future future = Ack$.MODULE$.AckExtensions(this.connectedFuture);
        Future future2 = Ack$.MODULE$.AckExtensions(Ack.AckExtensions$.MODULE$.syncTryFlatten$extension(future, (UncaughtExceptionReporter)this.scheduler()));
        Ack.AckExtensions$.MODULE$.syncOnContinue$extension(future2, (Function0)((JFunction0.mcV.sp & Serializable)this::onComplete$$anonfun$2), (UncaughtExceptionReporter)this.scheduler());
    }

    @Override
    public void onError(Throwable ex) {
        Future future = Ack$.MODULE$.AckExtensions(this.connectedFuture);
        Future future2 = Ack$.MODULE$.AckExtensions(Ack.AckExtensions$.MODULE$.syncTryFlatten$extension(future, (UncaughtExceptionReporter)this.scheduler()));
        Ack.AckExtensions$.MODULE$.syncOnContinue$extension(future2, (Function0)((JFunction0.mcV.sp & Serializable)() -> this.onError$$anonfun$1(ex)), (UncaughtExceptionReporter)this.scheduler());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void monix$reactive$observers$ConnectableSubscriber$$anon$1$$_$$lessinit$greater$$anonfun$1(ConnectableSubscriber $outer$1, Try x$1) {
        Try try_ = x$1;
        if (try_ instanceof Success) {
            Ack ack = (Ack)((Success)try_).value();
            if (Ack.Continue$.MODULE$.equals(ack)) {
                $outer$1.connectedPromise.success((Object)Ack.Continue$.MODULE$);
                $outer$1.isConnected = true;
                $outer$1.queue = null;
                $outer$1.connectedPromise = null;
                $outer$1.connectionRef = CancelableFuture$.MODULE$.successful((Object)Ack.Continue$.MODULE$);
                return;
            }
            if (Ack.Stop$.MODULE$.equals(ack)) {
                $outer$1.wasCanceled = true;
                $outer$1.connectedPromise.success((Object)Ack.Stop$.MODULE$);
                $outer$1.isConnected = true;
                $outer$1.queue = null;
                $outer$1.connectedPromise = null;
                $outer$1.connectionRef = CancelableFuture$.MODULE$.successful((Object)Ack.Stop$.MODULE$);
                return;
            }
        }
        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
        Throwable ex = ((Failure)try_).exception();
        $outer$1.wasCanceled = true;
        $outer$1.connectedPromise.failure(ex);
        $outer$1.isConnected = true;
        $outer$1.queue = null;
        $outer$1.connectedPromise = null;
        $outer$1.connectionRef = CancelableFuture$.MODULE$.failed(ex);
    }

    private final void onComplete$$anonfun$2() {
        this.monix$reactive$observers$ConnectableSubscriber$$underlying.onComplete();
    }

    private final void onError$$anonfun$1(Throwable ex$1) {
        this.monix$reactive$observers$ConnectableSubscriber$$underlying.onError(ex$1);
    }
}

