/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.observers.buffers;

import java.io.Serializable;
import monix.execution.internal.Platform$;
import monix.execution.internal.atomic.UnsafeAccess;
import monix.execution.internal.jctools.queues.MessagePassingQueue;
import monix.execution.internal.jctools.queues.MpscArrayQueue;
import monix.execution.internal.jctools.queues.MpscChunkedArrayQueue;
import monix.execution.internal.jctools.queues.MpscUnboundedArrayQueue;
import monix.execution.internal.jctools.queues.atomic.MpscAtomicArrayQueue;
import monix.execution.internal.jctools.queues.atomic.MpscLinkedAtomicQueue;
import monix.execution.internal.math$;
import monix.reactive.observers.buffers.ConcurrentQueue;
import scala.math.package$;
import scala.runtime.ModuleSerializationProxy;

public final class ConcurrentQueue$
implements Serializable {
    public static final ConcurrentQueue$ MODULE$ = new ConcurrentQueue$();

    private ConcurrentQueue$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ConcurrentQueue$.class);
    }

    public <A> ConcurrentQueue<A> limited(int capacity) {
        ConcurrentQueue concurrentQueue;
        int maxCapacity = package$.MODULE$.max(4, math$.MODULE$.nextPowerOf2(capacity));
        if (UnsafeAccess.IS_OPENJDK_COMPATIBLE) {
            MpscArrayQueue mpscArrayQueue;
            if (maxCapacity <= Platform$.MODULE$.recommendedBufferChunkSize()) {
                mpscArrayQueue = new MpscArrayQueue(maxCapacity);
            } else {
                int initialCapacity = package$.MODULE$.min(Platform$.MODULE$.recommendedBufferChunkSize(), maxCapacity / 2);
                mpscArrayQueue = new MpscChunkedArrayQueue(initialCapacity, maxCapacity);
            }
            concurrentQueue = new ConcurrentQueue.FromMessagePassingQueue((MessagePassingQueue)mpscArrayQueue);
        } else {
            concurrentQueue = new ConcurrentQueue.FromAbstractQueue(new MpscAtomicArrayQueue(maxCapacity));
        }
        return concurrentQueue;
    }

    public <A> ConcurrentQueue<A> unbounded() {
        ConcurrentQueue concurrentQueue;
        if (UnsafeAccess.IS_OPENJDK_COMPATIBLE) {
            int size = Platform$.MODULE$.recommendedBufferChunkSize();
            concurrentQueue = new ConcurrentQueue.FromMessagePassingQueue(new MpscUnboundedArrayQueue(size));
        } else {
            MpscLinkedAtomicQueue ref = new MpscLinkedAtomicQueue();
            concurrentQueue = new ConcurrentQueue.FromAbstractQueue(ref);
        }
        return concurrentQueue;
    }
}

