/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.execution.schedulers.ExecutionModel;
import monix.reactive.Observable;
import monix.reactive.exceptions.MultipleSubscribersException;
import monix.reactive.observables.ObservableLike;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005}a!B\u0001\u0003\u0005\u0019Q!!F%oaV$8\u000b\u001e:fC6|%m]3sm\u0006\u0014G.\u001a\u0006\u0003\u0007\u0011\t\u0001BY;jY\u0012,'o\u001d\u0006\u0003\u000b\u0019\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000f!\t\u0001B]3bGRLg/\u001a\u0006\u0002\u0013\u0005)Qn\u001c8jqN\u0019\u0001aC\t\u0011\u00051yQ\"A\u0007\u000b\u00039\tQa]2bY\u0006L!\u0001E\u0007\u0003\r\u0005s\u0017PU3g!\r\u00112#F\u0007\u0002\r%\u0011AC\u0002\u0002\u000b\u001f\n\u001cXM\u001d<bE2,\u0007c\u0001\u0007\u00171%\u0011q#\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0019eI!AG\u0007\u0003\t\tKH/\u001a\u0005\t9\u0001\u0011\t\u0011)A\u0005=\u0005\u0011\u0011N\\\u0002\u0001!\tyB%D\u0001!\u0015\t\t#%\u0001\u0002j_*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005-Ie\u000e];u'R\u0014X-Y7\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\n\u0011b\u00195v].\u001c\u0016N_3\u0011\u00051I\u0013B\u0001\u0016\u000e\u0005\rIe\u000e\u001e\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079\u0002\u0014\u0007\u0005\u00020\u00015\t!\u0001C\u0003\u001dW\u0001\u0007a\u0004C\u0003(W\u0001\u0007\u0001\u0006\u0003\u00044\u0001\u0001\u0006I\u0001N\u0001\u000eo\u0006\u001c8+\u001e2tGJL'-\u001a3\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014AB1u_6L7M\u0003\u0002:\u0011\u0005IQ\r_3dkRLwN\\\u0005\u0003wY\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\"B\u001f\u0001\t\u0003q\u0014!E;og\u00064WmU;cg\u000e\u0014\u0018NY3G]R\u0011qh\u0011\t\u0003\u0001\u0006k\u0011\u0001O\u0005\u0003\u0005b\u0012!bQ1oG\u0016d\u0017M\u00197f\u0011\u0015!E\b1\u0001F\u0003\ryW\u000f\u001e\t\u0004\r&+R\"A$\u000b\u0005!3\u0011!C8cg\u0016\u0014h/\u001a:t\u0013\tQuI\u0001\u0006Tk\n\u001c8M]5cKJDQ\u0001\u0014\u0001\u0005\n5\u000b!B]3tG\",G-\u001e7f)\u0019quK\u00193f[R\u0011qJ\u0015\t\u0003\u0019AK!!U\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u0006'.\u0003\u001d\u0001V\u0001\u0002gB\u0011\u0001)V\u0005\u0003-b\u0012\u0011bU2iK\u0012,H.\u001a:\t\u000ba[\u0005\u0019A-\u0002\u0007\u0005\u001c7\u000eE\u0002[;~k\u0011a\u0017\u0006\u000396\t!bY8oGV\u0014(/\u001a8u\u0013\tq6L\u0001\u0004GkR,(/\u001a\t\u0003\u0001\u0002L!!\u0019\u001d\u0003\u0007\u0005\u001b7\u000eC\u0003d\u0017\u0002\u0007Q#A\u0001c\u0011\u0015!5\n1\u0001F\u0011\u001517\n1\u0001h\u0003\u0005\u0019\u0007C\u00015l\u001b\u0005I'B\u000169\u0003-\u0019\u0017M\\2fY\u0006\u0014G.Z:\n\u00051L'!\u0005\"p_2,\u0017M\\\"b]\u000e,G.\u00192mK\")an\u0013a\u0001_\u0006\u0011Q-\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003eb\n!b]2iK\u0012,H.\u001a:t\u0013\t!\u0018O\u0001\bFq\u0016\u001cW\u000f^5p]6{G-\u001a7\t\u000bY\u0004A\u0011B<\u0002\u0011\u0019\f7\u000f\u001e'p_B$b\u0001\u001f>}{z|HCA(z\u0011\u0015\u0019V\u000fq\u0001U\u0011\u0015YX\u000f1\u0001\u0016\u0003\u0019\u0011WO\u001a4fe\")A)\u001ea\u0001\u000b\")a-\u001ea\u0001O\")a.\u001ea\u0001_\"1\u0011\u0011A;A\u0002!\n\u0011b]=oG&sG-\u001a=)\u0007U\f)\u0001\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tY!D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\b\u0003\u0013\u0011q\u0001^1jYJ,7\rC\u0004\u0002\u0014\u0001!I!!\u0006\u0002\u001bQ\u0014\u0018nZ4fe\u000e\u000bgnY3m)\ry\u0015q\u0003\u0005\b'\u0006E\u0001\u0019AA\r!\r\u0001\u00151D\u0005\u0004\u0003;A$!G+oG\u0006,x\r\u001b;Fq\u000e,\u0007\u000f^5p]J+\u0007o\u001c:uKJ\u0004")
public final class InputStreamObservable
implements Observable<byte[]> {
    private final InputStream in;
    private final int chunkSize;
    private final AtomicBoolean wasSubscribed;

    /*
     * WARNING - void declaration
     */
    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<byte[]> out) {
        Cancelable cancelable;
        if (this.wasSubscribed.getAndSet(true)) {
            out.onError(new MultipleSubscribersException("InputStreamObservable"));
            cancelable = Cancelable$.MODULE$.empty();
        } else {
            void var3_3;
            ExecutionModel em;
            byte[] buffer = new byte[this.chunkSize];
            BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
            ExecutionModel executionModel = em = out.scheduler().executionModel();
            ExecutionModel.AlwaysAsyncExecution$ alwaysAsyncExecution$ = ExecutionModel.AlwaysAsyncExecution$.MODULE$;
            if (!(executionModel != null ? !executionModel.equals(alwaysAsyncExecution$) : alwaysAsyncExecution$ != null)) {
                this.reschedule((Future<Ack>)Ack.Continue$.MODULE$, buffer, out, cancelable2, em, out.scheduler());
            } else {
                this.fastLoop(buffer, out, cancelable2, em, 0, out.scheduler());
            }
            cancelable = var3_3;
        }
        return cancelable;
    }

    private void reschedule(Future<Ack> ack, byte[] b, Subscriber<byte[]> out, BooleanCancelable c, ExecutionModel em, Scheduler s) {
        ack.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            InputStreamObservable.$anonfun$reschedule$1(this, b, out, c, em, s, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)s);
    }

    private void fastLoop(byte[] buffer, Subscriber<byte[]> out, BooleanCancelable c, ExecutionModel em, int syncIndex, Scheduler s) {
        block17: {
            BoxedUnit boxedUnit;
            boolean streamErrors;
            Throwable errorThrown;
            block16: {
                Ack.Stop$ ack;
                while (true) {
                    int nextIndex;
                    int n;
                    errorThrown = null;
                    ack = Ack.Continue$.MODULE$;
                    streamErrors = true;
                    try {
                        Ack.Stop$ stop$;
                        int length = BoxesRunTime.unboxToInt((Object)package$.MODULE$.blocking((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.in.read(buffer)));
                        streamErrors = false;
                        if (length >= 0) {
                            byte[] next = Arrays.copyOf(buffer, length);
                            stop$ = out.onNext(next);
                        } else {
                            Throwable ex = this.liftedTree1$1();
                            if (ex == null) {
                                out.onComplete();
                            } else {
                                out.onError(ex);
                            }
                            stop$ = Ack.Stop$.MODULE$;
                        }
                        ack = stop$;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable ex;
                            errorThrown = ex = (Throwable)option.get();
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        }
                        throw throwable;
                    }
                    if (errorThrown != null) break block16;
                    Ack.Stop$ stop$ = ack;
                    Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                    if (!(stop$ != null ? !stop$.equals(continue$) : continue$ != null)) {
                        n = em.nextFrameIndex(syncIndex);
                    } else {
                        Ack.Stop$ stop$2 = ack;
                        Ack.Stop$ stop$3 = Ack.Stop$.MODULE$;
                        n = !(stop$2 != null ? !stop$2.equals(stop$3) : stop$3 != null) ? -1 : (nextIndex = 0);
                    }
                    if (nextIndex < 0 || c.isCanceled()) {
                        this.triggerCancel((UncaughtExceptionReporter)s);
                        boxedUnit = BoxedUnit.UNIT;
                        break block17;
                    }
                    if (nextIndex <= 0) break;
                    syncIndex = nextIndex;
                }
                this.reschedule((Future<Ack>)ack, buffer, out, c, em, s);
                boxedUnit = BoxedUnit.UNIT;
                break block17;
            }
            try {
                if (streamErrors) {
                    out.onError(errorThrown);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    s.reportFailure(errorThrown);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                this.triggerCancel((UncaughtExceptionReporter)s);
            }
        }
    }

    private void triggerCancel(UncaughtExceptionReporter s) {
        try {
            package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.in.close());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable ex = (Throwable)option.get();
                s.reportFailure(ex);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$reschedule$1(InputStreamObservable $this, byte[] b$1, Subscriber out$1, BooleanCancelable c$1, ExecutionModel em$1, Scheduler s$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            Ack next;
            Success success = (Success)try_;
            Ack ack = next = (Ack)success.value();
            Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
            if (!(ack != null ? !ack.equals(continue$) : continue$ != null) && !c$1.isCanceled()) {
                $this.fastLoop(b$1, out$1, c$1, em$1, 0, s$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.triggerCancel((UncaughtExceptionReporter)s$1);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            try {
                s$1.reportFailure(ex);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                $this.triggerCancel((UncaughtExceptionReporter)s$1);
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private final Throwable liftedTree1$1() {
        Throwable throwable;
        try {
            package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.in.close());
            throwable = null;
        }
        catch (Throwable throwable2) {
            Throwable err;
            Throwable throwable3 = throwable2;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (option.isEmpty()) {
                throw throwable2;
            }
            Throwable throwable4 = err = (Throwable)option.get();
            throwable = throwable4;
        }
        return throwable;
    }

    public InputStreamObservable(InputStream in, int chunkSize) {
        this.in = in;
        this.chunkSize = chunkSize;
        ObservableLike.$init$(this);
        Observable.$init$(this);
        this.wasSubscribed = (AtomicBoolean)AtomicBuilder$.MODULE$.AtomicBooleanBuilder().buildInstance((Object)BoxesRunTime.boxToBoolean((boolean)false), (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$);
    }
}

