/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.execution.schedulers.ExecutionModel;
import monix.reactive.Observable;
import monix.reactive.exceptions.MultipleSubscribersException;
import monix.reactive.observables.ObservableLike;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub!B\u0001\u0003\u0005\u0019Q!\u0001F%uKJ\fGo\u001c:Bg>\u00137/\u001a:wC\ndWM\u0003\u0002\u0004\t\u0005A!-^5mI\u0016\u00148O\u0003\u0002\u0006\r\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\b\u0011\u0005A!/Z1di&4XMC\u0001\n\u0003\u0015iwN\\5y+\tY\u0001dE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007cA\n\u0015-5\ta!\u0003\u0002\u0016\r\tQqJY:feZ\f'\r\\3\u0011\u0005]AB\u0002\u0001\u0003\u00063\u0001\u0011\ra\u0007\u0002\u0002)\u000e\u0001\u0011C\u0001\u000f !\tiQ$\u0003\u0002\u001f\u001d\t9aj\u001c;iS:<\u0007CA\u0007!\u0013\t\tcBA\u0002B]fD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\tSR,'/\u0019;peB\u0019Q%\f\f\u000f\u0005\u0019ZcBA\u0014+\u001b\u0005A#BA\u0015\u001b\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002-\u001d\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u00180\u0005!IE/\u001a:bi>\u0014(B\u0001\u0017\u000f\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014\u0001C8o\r&t\u0017n\u001d5\u0011\u0005M2T\"\u0001\u001b\u000b\u0005UB\u0011!C3yK\u000e,H/[8o\u0013\t9DG\u0001\u0006DC:\u001cW\r\\1cY\u0016DQ!\u000f\u0001\u0005\u0002i\na\u0001P5oSRtDcA\u001e>}A\u0019A\b\u0001\f\u000e\u0003\tAQa\t\u001dA\u0002\u0011BQ!\r\u001dA\u0002IBa\u0001\u0011\u0001!\u0002\u0013\t\u0015!D<bgN+(m]2sS\n,G\r\u0005\u0002C\u000b6\t1I\u0003\u0002Ei\u00051\u0011\r^8nS\u000eL!AR\"\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011\u0015A\u0005\u0001\"\u0001J\u0003E)hn]1gKN+(m]2sS\n,gI\u001c\u000b\u0003e)CQaS$A\u00021\u000b1a\\;u!\ri\u0005KF\u0007\u0002\u001d*\u0011qJB\u0001\n_\n\u001cXM\u001d<feNL!!\u0015(\u0003\u0015M+(m]2sS\n,'\u000fC\u0003T\u0001\u0011%A+A\u0005ti\u0006\u0014H\u000fT8paR\u0011!'\u0016\u0005\u0006-J\u0003\r\u0001T\u0001\u000bgV\u00147o\u0019:jE\u0016\u0014\b\"\u0002-\u0001\t\u0013I\u0016!\u0004;sS\u001e<WM]\"b]\u000e,G\u000e\u0006\u0002[;B\u0011QbW\u0005\u00039:\u0011A!\u00168ji\")al\u0016a\u0001?\u0006\t1\u000f\u0005\u00024A&\u0011\u0011\r\u000e\u0002\n'\u000eDW\rZ;mKJDQa\u0019\u0001\u0005\n\u0011\f!B]3tG\",G-\u001e7f)\u0019)wM\u001d;v{R\u0011!L\u001a\u0005\u0006=\n\u0004\u001da\u0018\u0005\u0006Q\n\u0004\r![\u0001\u0004C\u000e\\\u0007c\u00016n_6\t1N\u0003\u0002m\u001d\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u00059\\'A\u0002$viV\u0014X\r\u0005\u00024a&\u0011\u0011\u000f\u000e\u0002\u0004\u0003\u000e\\\u0007\"B:c\u0001\u0004!\u0013\u0001B5uKJDQa\u00132A\u00021CQA\u001e2A\u0002]\f\u0011a\u0019\t\u0003qnl\u0011!\u001f\u0006\u0003uR\n1bY1oG\u0016d\u0017M\u00197fg&\u0011A0\u001f\u0002\u0012\u0005>|G.Z1o\u0007\u0006t7-\u001a7bE2,\u0007\"\u0002@c\u0001\u0004y\u0018AA3n!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003i\u0005Q1o\u00195fIVdWM]:\n\t\u0005%\u00111\u0001\u0002\u000f\u000bb,7-\u001e;j_:lu\u000eZ3m\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001f\t\u0001BZ1ti2{w\u000e\u001d\u000b\r\u0003#\t)\"a\u0006\u0002\u001a\u0005m\u0011Q\u0004\u000b\u00045\u0006M\u0001B\u00020\u0002\f\u0001\u000fq\f\u0003\u0004t\u0003\u0017\u0001\r\u0001\n\u0005\u0007\u0017\u0006-\u0001\u0019\u0001'\t\rY\fY\u00011\u0001x\u0011\u0019q\u00181\u0002a\u0001\u007f\"A\u0011qDA\u0006\u0001\u0004\t\t#A\u0005ts:\u001c\u0017J\u001c3fqB\u0019Q\"a\t\n\u0007\u0005\u0015bBA\u0002J]RDC!a\u0003\u0002*A!\u00111FA\u0019\u001b\t\tiCC\u0002\u000209\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019$!\f\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0002")
public final class IteratorAsObservable<T>
implements Observable<T> {
    private final Iterator<T> iterator;
    private final Cancelable onFinish;
    private final AtomicBoolean wasSubscribed;

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<T> out) {
        Cancelable cancelable;
        if (this.wasSubscribed.getAndSet(true)) {
            out.onError(new MultipleSubscribersException("InputStreamObservable"));
            cancelable = Cancelable$.MODULE$.empty();
        } else {
            cancelable = this.startLoop(out);
        }
        return cancelable;
    }

    private Cancelable startLoop(Subscriber<T> subscriber) {
        Cancelable cancelable;
        block7: {
            boolean streamErrors = true;
            try {
                boolean isEmpty = this.iterator.isEmpty();
                streamErrors = false;
                if (isEmpty) {
                    subscriber.onComplete();
                    cancelable = Cancelable$.MODULE$.empty();
                    break block7;
                }
                BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
                this.fastLoop(this.iterator, subscriber, cancelable2, subscriber.scheduler().executionModel(), 0, subscriber.scheduler());
                cancelable = cancelable2;
            }
            catch (Throwable throwable) {
                Cancelable cancelable3;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    if (streamErrors) {
                        subscriber.onError(ex);
                        cancelable3 = Cancelable$.MODULE$.empty();
                    } else {
                        this.triggerCancel(subscriber.scheduler());
                        subscriber.scheduler().reportFailure(ex);
                        cancelable3 = Cancelable$.MODULE$.empty();
                    }
                } else {
                    throw throwable;
                }
                Cancelable cancelable4 = cancelable3;
                cancelable = cancelable4;
            }
        }
        return cancelable;
    }

    private void triggerCancel(Scheduler s) {
        try {
            this.onFinish.cancel();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable ex = (Throwable)option.get();
                s.reportFailure(ex);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void reschedule(Future<Ack> ack, Iterator<T> iter, Subscriber<T> out, BooleanCancelable c, ExecutionModel em, Scheduler s) {
        ack.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            IteratorAsObservable.$anonfun$reschedule$1(this, iter, out, c, em, s, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)s);
    }

    private void fastLoop(Iterator<T> iter, Subscriber<T> out, BooleanCancelable c, ExecutionModel em, int syncIndex, Scheduler s) {
        block20: {
            int nextIndex;
            BoxedUnit boxedUnit;
            Future<Ack> ack;
            while (true) {
                int n;
                Throwable iteratorTriggeredError;
                block21: {
                    ack = Ack.Continue$.MODULE$;
                    boolean streamErrors = true;
                    boolean iteratorIsDone = false;
                    iteratorTriggeredError = null;
                    try {
                        if (iter.hasNext()) {
                            Object next = iter.next();
                            streamErrors = false;
                            ack = out.onNext(next);
                        } else {
                            iteratorIsDone = true;
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable ex = (Throwable)option.get();
                            if (streamErrors) {
                                iteratorTriggeredError = ex;
                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            }
                        }
                        throw throwable;
                    }
                    if (!iteratorIsDone) break block21;
                    streamErrors = true;
                    try {
                        this.onFinish.cancel();
                        streamErrors = false;
                        out.onComplete();
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Throwable ex;
                        block23: {
                            block22: {
                                Throwable throwable3 = throwable;
                                Option option = NonFatal$.MODULE$.unapply(throwable3);
                                if (option.isEmpty()) break block22;
                                ex = (Throwable)option.get();
                                if (streamErrors) break block23;
                            }
                            throw throwable;
                        }
                        out.onError(ex);
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    break block20;
                }
                if (iteratorTriggeredError != null) {
                    this.triggerCancel(s);
                    if (!c.isCanceled()) {
                        out.onError(iteratorTriggeredError);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    break block20;
                }
                Future<Ack> future = ack;
                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                if (!(future != null ? !future.equals((Object)continue$) : continue$ != null)) {
                    n = em.nextFrameIndex(syncIndex);
                } else {
                    Future<Ack> future2 = ack;
                    Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                    n = !(future2 != null ? !future2.equals((Object)stop$) : stop$ != null) ? -1 : (nextIndex = 0);
                }
                if (nextIndex <= 0) break;
                syncIndex = nextIndex;
            }
            if (nextIndex == 0 && !c.isCanceled()) {
                this.reschedule(ack, iter, out, c, em, s);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.triggerCancel(s);
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$reschedule$1(IteratorAsObservable $this, Iterator iter$1, Subscriber out$1, BooleanCancelable c$1, ExecutionModel em$1, Scheduler s$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            Ack next;
            Success success = (Success)try_;
            Ack ack = next = (Ack)success.value();
            Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
            if (!(ack != null ? !ack.equals(continue$) : continue$ != null)) {
                try {
                    $this.fastLoop(iter$1, out$1, c$1, em$1, 0, s$1);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable ex = (Throwable)option.get();
                    $this.triggerCancel(s$1);
                    s$1.reportFailure(ex);
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                $this.triggerCancel(s$1);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            $this.triggerCancel(s$1);
            s$1.reportFailure(ex);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public IteratorAsObservable(Iterator<T> iterator, Cancelable onFinish) {
        this.iterator = iterator;
        this.onFinish = onFinish;
        ObservableLike.$init$(this);
        Observable.$init$(this);
        this.wasSubscribed = (AtomicBoolean)AtomicBuilder$.MODULE$.AtomicBooleanBuilder().buildInstance((Object)BoxesRunTime.boxToBoolean((boolean)false), (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$);
    }
}

