/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.rstreams;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Ack$Continue$;
import monix.execution.Scheduler;
import monix.reactive.observers.Subscriber;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005e4Q\u0001D\u0007\u0003#UA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\ty\u0001\u0011\t\u0011)A\u0005{!)\u0001\t\u0001C\u0001\u0003\"1a\t\u0001Q\u0001\f\u001dCa!\u0014\u0001!B\u0013q\u0005BB)\u0001A\u0003&!\u000b\u0003\u0004V\u0001\u0001\u0006KA\u0016\u0005\u0006;\u0002!\tA\u0018\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006o\u0002!\t\u0001\u001f\u0002#'ft7mU;cg\u000e\u0014\u0018NY3s\u0003N\u0014V-Y2uSZ,7+\u001e2tGJL'-\u001a:\u000b\u00059y\u0011\u0001\u0003:tiJ,\u0017-\\:\u000b\u0005A\t\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005I\u0019\u0012\u0001\u0003:fC\u000e$\u0018N^3\u000b\u0003Q\tQ!\\8oSb,\"AF\u0014\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0004=\r*S\"A\u0010\u000b\u0005\u0001\n\u0013a\u0004:fC\u000e$\u0018N^3tiJ,\u0017-\\:\u000b\u0003\t\n1a\u001c:h\u0013\t!sD\u0001\u0006Tk\n\u001c8M]5cKJ\u0004\"AJ\u0014\r\u0001\u0011)\u0001\u0006\u0001b\u0001U\t\t\u0011i\u0001\u0001\u0012\u0005-r\u0003C\u0001\r-\u0013\ti\u0013DA\u0004O_RD\u0017N\\4\u0011\u0005ay\u0013B\u0001\u0019\u001a\u0005\r\te._\u0001\u0007i\u0006\u0014x-\u001a;\u0011\u0007MJTE\u0004\u00025o5\tQG\u0003\u00027#\u0005IqNY:feZ,'o]\u0005\u0003qU\n!bU;cg\u000e\u0014\u0018NY3s\u0013\tQ4H\u0001\u0003Ts:\u001c'B\u0001\u001d6\u00031\u0011X-];fgR\u001cu.\u001e8u!\tAb(\u0003\u0002@3\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\r\u0011E)\u0012\t\u0004\u0007\u0002)S\"A\u0007\t\u000bE\u001a\u0001\u0019\u0001\u001a\t\u000bq\u001a\u0001\u0019A\u001f\u0002\u0003M\u0004\"\u0001S&\u000e\u0003%S!AS\n\u0002\u0013\u0015DXmY;uS>t\u0017B\u0001'J\u0005%\u00196\r[3ek2,'/\u0001\u0007tk\n\u001c8M]5qi&|g\u000e\u0005\u0002\u001f\u001f&\u0011\u0001k\b\u0002\r'V\u00147o\u0019:jaRLwN\\\u0001\u000fKb\u0004Xm\u0019;j]\u001e\u001cu.\u001e8u!\tA2+\u0003\u0002U3\t!Aj\u001c8h\u0003)I7oQ1oG\u0016dW\r\u001a\t\u00031]K!\u0001W\r\u0003\u000f\t{w\u000e\\3b]\"\u0012qA\u0017\t\u00031mK!\u0001X\r\u0003\u0011Y|G.\u0019;jY\u0016\f1b\u001c8Tk\n\u001c8M]5cKR\u0011qL\u0019\t\u00031\u0001L!!Y\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006\r\"\u0001\rAT\u0001\u0007_:tU\r\u001f;\u0015\u0005}+\u0007\"\u00024\n\u0001\u0004)\u0013\u0001B3mK6\fqa\u001c8FeJ|'\u000f\u0006\u0002`S\")!N\u0003a\u0001W\u0006\u0011Q\r\u001f\t\u0003YRt!!\u001c:\u000f\u00059\fX\"A8\u000b\u0005AL\u0013A\u0002\u001fs_>$h(C\u0001\u001b\u0013\t\u0019\u0018$A\u0004qC\u000e\\\u0017mZ3\n\u0005U4(!\u0003+ie><\u0018M\u00197f\u0015\t\u0019\u0018$\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016$\u0012a\u0018")
public final class SyncSubscriberAsReactiveSubscriber<A>
implements Subscriber<A> {
    private final Subscriber.Sync<A> target;
    private final int requestCount;
    private final Scheduler s;
    private Subscription subscription;
    private long expectingCount;
    private volatile boolean isCanceled;
    private volatile byte bitmap$init$0;

    public void onSubscribe(Subscription s) {
        if (this.subscription == null && !this.isCanceled) {
            this.subscription = s;
            this.expectingCount = this.requestCount;
            s.request((long)this.requestCount);
        } else {
            s.cancel();
        }
    }

    public void onNext(A elem) {
        if (this.subscription == null) {
            throw new NullPointerException("onSubscription never happened, see rule 2.13 in the Reactive Streams spec");
        }
        if (elem == null) {
            throw new NullPointerException("onNext(null) is forbidden, see rule 2.13 in the Reactive Streams spec");
        }
        if (!this.isCanceled) {
            Ack ack;
            if (this.expectingCount > 0L) {
                --this.expectingCount;
            }
            if (Ack$Continue$.MODULE$.equals(ack = this.target.onNext(elem))) {
                BoxedUnit boxedUnit;
                if (this.expectingCount == 0L) {
                    this.expectingCount = this.requestCount;
                    this.subscription.request((long)this.requestCount);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (Ack.Stop$.MODULE$.equals(ack)) {
                this.isCanceled = true;
                this.subscription.cancel();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)ack);
            }
        }
    }

    public void onError(Throwable ex) {
        block1: {
            if (ex == null) {
                throw new NullPointerException("onError(null) is forbidden, see rule 2.13 in the Reactive Streams spec");
            }
            if (this.isCanceled) break block1;
            this.isCanceled = true;
            this.target.onError(ex);
        }
    }

    public void onComplete() {
        block0: {
            if (this.isCanceled) break block0;
            this.isCanceled = true;
            this.target.onComplete();
        }
    }

    public SyncSubscriberAsReactiveSubscriber(Subscriber.Sync<A> target, int requestCount) {
        this.target = target;
        this.requestCount = requestCount;
        Predef$.MODULE$.require(requestCount > 0, (Function0 & Serializable)() -> "requestCount must be strictly positive, according to the Reactive Streams contract");
        this.s = target.scheduler();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.subscription = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.expectingCount = 0L;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.isCanceled = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

