/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.batches;

import monix.tail.batches.BatchCursor;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.Iterator;

public final class IteratorCursor<A>
extends BatchCursor<A> {
    private final Iterator<A> underlying;
    private final int recommendedBatchSize;

    public IteratorCursor(Iterator<A> underlying, int recommendedBatchSize) {
        this.underlying = underlying;
        this.recommendedBatchSize = recommendedBatchSize;
    }

    @Override
    public int recommendedBatchSize() {
        return this.recommendedBatchSize;
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public A next() {
        return (A)this.underlying.next();
    }

    @Override
    public BatchCursor<A> take(int n) {
        return new IteratorCursor<A>(this.underlying.take(n), this.recommendedBatchSize());
    }

    @Override
    public BatchCursor<A> drop(int n) {
        return new IteratorCursor<A>(this.underlying.drop(n), this.recommendedBatchSize());
    }

    @Override
    public BatchCursor<A> slice(int from, int until) {
        return new IteratorCursor<A>(this.underlying.slice(from, until), this.recommendedBatchSize());
    }

    @Override
    public <B> BatchCursor<B> map(Function1<A, B> f) {
        return new IteratorCursor<A>(this.underlying.map(f), this.recommendedBatchSize());
    }

    @Override
    public BatchCursor<A> filter(Function1<A, Object> p) {
        return new IteratorCursor<A>(this.underlying.filter(p), this.recommendedBatchSize());
    }

    @Override
    public <B> BatchCursor<B> collect(PartialFunction<A, B> pf) {
        return new IteratorCursor<A>(this.underlying.collect(pf), this.recommendedBatchSize());
    }

    @Override
    public Iterator<A> toIterator() {
        return this.underlying;
    }
}

