/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.internal;

import cats.effect.Sync;
import cats.syntax.package;
import monix.tail.Iterant;
import monix.tail.Iterant$;
import monix.tail.Iterant$NextCursor$;
import monix.tail.Iterant$Suspend$;
import monix.tail.batches.BatchCursor;
import monix.tail.internal.IterantDrop$;
import monix.tail.internal.package$;
import monix.tail.internal.package$ConcatExtensions$;
import monix.tail.internal.package$ScopeExtensions$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;

public final class IterantDrop {
    public static <F, A> Iterant<F, A> apply(Iterant<F, A> iterant, int n, Sync<F> sync) {
        return IterantDrop$.MODULE$.apply(iterant, n, sync);
    }

    private static final class Loop<F, A>
    extends Iterant.Visitor<F, A, Iterant<F, A>> {
        private final Sync<F> F;
        private int toDrop;

        public Loop(int n, Sync<F> F) {
            this.F = F;
            this.toDrop = n;
        }

        @Override
        public Iterant<F, A> visit(Iterant.Next<F, A> ref) {
            Iterant iterant;
            if (this.toDrop <= 0) {
                iterant = ref;
            } else {
                --this.toDrop;
                iterant = Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> visit(Iterant.NextBatch<F, A> ref) {
            return this.toDrop <= 0 ? ref : this.dropFromCursor(ref.toNextCursor());
        }

        @Override
        public Iterant<F, A> visit(Iterant.NextCursor<F, A> ref) {
            return this.toDrop <= 0 ? ref : this.dropFromCursor(ref);
        }

        @Override
        public Iterant<F, A> visit(Iterant.Suspend<F, A> ref) {
            return this.toDrop <= 0 ? ref : Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
        }

        @Override
        public Iterant<F, A> visit(Iterant.Concat<F, A> ref) {
            Iterant.Concat<F, Object> concat;
            if (this.toDrop <= 0) {
                concat = ref;
            } else {
                Iterant.Concat concat2 = package$.MODULE$.ConcatExtensions(ref);
                concat = package$ConcatExtensions$.MODULE$.runMap$extension(concat2, this, this.F);
            }
            return concat;
        }

        @Override
        public <S> Iterant<F, A> visit(Iterant.Scope<F, S, A> ref) {
            Iterant iterant;
            if (this.toDrop <= 0) {
                iterant = ref;
            } else {
                Iterant.Scope scope = package$.MODULE$.ScopeExtensions(ref);
                iterant = package$ScopeExtensions$.MODULE$.runMap$extension(scope, this, this.F);
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> visit(Iterant.Last<F, A> ref) {
            Iterant iterant;
            if (this.toDrop <= 0) {
                iterant = ref;
            } else {
                --this.toDrop;
                iterant = Iterant$.MODULE$.empty();
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> visit(Iterant.Halt<F, A> ref) {
            return ref;
        }

        @Override
        public Iterant<F, A> fail(Throwable e) {
            return Iterant$.MODULE$.raiseError(e);
        }

        private Iterant<F, A> dropFromCursor(Iterant.NextCursor<F, A> ref) {
            Iterant.NextCursor<F, A> nextCursor = ref;
            if (nextCursor == null) {
                throw new MatchError(nextCursor);
            }
            Iterant.NextCursor<F, A> nextCursor2 = Iterant$NextCursor$.MODULE$.unapply(nextCursor);
            BatchCursor<A> batchCursor = nextCursor2._1();
            F f = nextCursor2._2();
            BatchCursor<A> cursor = batchCursor;
            F rest = f;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(cursor, rest);
            BatchCursor cursor2 = (BatchCursor)tuple2._1();
            Object rest2 = tuple2._2();
            int limit = scala.math.package$.MODULE$.min(cursor2.recommendedBatchSize(), this.toDrop);
            int droppedNow = 0;
            while (droppedNow < limit && cursor2.hasNext()) {
                cursor2.next();
                ++droppedNow;
                --this.toDrop;
            }
            Object next = droppedNow == limit && cursor2.hasNext() ? this.F.pure(ref) : rest2;
            return Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(next, this.F).map((Function1)this));
        }
    }
}

