/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.internal;

import cats.effect.ExitCase;
import cats.effect.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import java.io.Serializable;
import monix.execution.atomic.Atomic;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.internal.Platform$;
import monix.tail.Iterant;
import monix.tail.Iterant$;
import monix.tail.Iterant$Concat$;
import monix.tail.Iterant$Next$;
import monix.tail.Iterant$NextBatch$;
import monix.tail.Iterant$NextCursor$;
import monix.tail.Iterant$Scope$;
import monix.tail.Iterant$Suspend$;
import monix.tail.batches.Batch$;
import monix.tail.batches.BatchCursor;
import monix.tail.internal.IterantOnErrorHandleWith$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class IterantOnErrorHandleWith {
    public static <F, A> Iterant<F, A> apply(Iterant<F, A> iterant, Function1<Throwable, Iterant<F, A>> function1, Sync<F> sync) {
        return IterantOnErrorHandleWith$.MODULE$.apply(iterant, function1, sync);
    }

    private static final class Loop<F, A>
    extends Iterant.Visitor<F, A, Iterant<F, A>> {
        private final Function1<Throwable, Iterant<F, A>> handler;
        private final Sync<F> F;
        private boolean wasErrorHandled;
        private final Function1<Throwable, Iterant<F, A>> f;

        public Loop(Function1<Throwable, Iterant<F, A>> handler, Sync<F> F) {
            this.handler = handler;
            this.F = F;
            this.wasErrorHandled = false;
            this.f = (Function1 & Serializable)e -> {
                Iterant iterant;
                this.wasErrorHandled = true;
                try {
                    iterant = (Iterant)handler.apply(e);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable e2 = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(e)) {
                        iterant = Iterant$.MODULE$.raiseError(Platform$.MODULE$.composeErrors(e, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Throwable[]{e2})));
                    }
                    throw throwable;
                }
                return iterant;
            };
        }

        @Override
        public Iterant<F, A> visit(Iterant.Next<F, A> ref) {
            return Iterant$Next$.MODULE$.apply(ref.item(), this.continueWith(ref.rest()));
        }

        @Override
        public Iterant<F, A> visit(Iterant.NextBatch<F, A> ref) {
            Object object;
            boolean handleError = true;
            try {
                BatchCursor<A> cursor = ref.batch().cursor();
                handleError = false;
                object = this.visit(Iterant$NextCursor$.MODULE$.apply(cursor, ref.rest()));
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable e = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(e) && handleError) {
                    object = (Iterant)this.f.apply((Object)e);
                }
                throw throwable;
            }
            return object;
        }

        @Override
        public Iterant<F, A> visit(Iterant.NextCursor<F, A> ref) {
            Iterant iterant;
            try {
                F next;
                Object array = this.extractFromCursor(ref.cursor());
                Object object = next = ref.cursor().hasNext() ? package.all$.MODULE$.toFunctorOps(this.F.pure(ref), this.F).map((Function1)this) : this.continueWith(ref.rest());
                iterant = ScalaRunTime$.MODULE$.array_length(array) != 0 ? Iterant$NextBatch$.MODULE$.apply(Batch$.MODULE$.fromArray(array), next) : Iterant$Suspend$.MODULE$.apply(next);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable e = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(e)) {
                    iterant = (Iterant.Suspend)this.f.apply((Object)e);
                }
                throw throwable;
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> visit(Iterant.Suspend<F, A> ref) {
            return Iterant$Suspend$.MODULE$.apply(this.continueWith(ref.rest()));
        }

        @Override
        public Iterant<F, A> visit(Iterant.Concat<F, A> ref) {
            return Iterant$Concat$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.lh(), this.F).map((Function1)this), this.F.defer(() -> this.visit$$anonfun$1(ref)));
        }

        @Override
        public <S> Iterant<F, A> visit(Iterant.Scope<F, S, A> ref) {
            Iterant.Scope<F, S, A> scope = ref;
            if (scope == null) {
                throw new MatchError(scope);
            }
            Iterant.Scope<F, S, A> scope2 = Iterant$Scope$.MODULE$.unapply(scope);
            F f = scope2._1();
            Function1<S, F> function1 = scope2._2();
            Function2<S, ExitCase<Throwable>, F> function2 = scope2._3();
            F acquire = f;
            Function1<S, F> use = function1;
            Function2<S, ExitCase<Throwable>, F> release = function2;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply(acquire, use, release);
            Object acquire2 = tuple3._1();
            Function1 use2 = (Function1)tuple3._2();
            Function2 release2 = (Function2)tuple3._3();
            return Iterant$Suspend$.MODULE$.apply(this.F.delay(() -> this.visit$$anonfun$2(acquire2, use2, release2)));
        }

        @Override
        public Iterant<F, A> visit(Iterant.Last<F, A> ref) {
            return ref;
        }

        @Override
        public Iterant<F, A> visit(Iterant.Halt<F, A> ref) {
            Iterant iterant;
            Option<Throwable> option = ref.e();
            if (None$.MODULE$.equals(option)) {
                iterant = ref;
            } else if (option instanceof Some) {
                Throwable e = (Throwable)((Some)option).value();
                iterant = (Iterant)this.f.apply((Object)e);
            } else {
                throw new MatchError(option);
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> fail(Throwable e) {
            this.wasErrorHandled = true;
            return Iterant$.MODULE$.raiseError(e);
        }

        private F continueWith(F rest) {
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(rest, this.F);
            return (F)package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.handleError$extension(object, this.f, this.F), this.F).map((Function1)this);
        }

        private Object extractFromCursor(BatchCursor<A> ref) {
            ArrayBuffer buffer = ArrayBuffer$.MODULE$.empty();
            for (int size = ref.recommendedBatchSize(); size > 0 && ref.hasNext(); --size) {
                buffer.$plus$eq(ref.next());
            }
            return buffer.toArray(ClassTag$.MODULE$.Any());
        }

        private void pushError(Atomic<Throwable> ref, Throwable e) {
            Throwable update;
            Throwable current;
            Loop loop = this;
            do {
                Throwable throwable;
                Throwable throwable2;
                if ((throwable2 = (current = (Throwable)ref.get())) == null) {
                    throwable = e;
                    continue;
                }
                Throwable e0 = throwable2;
                throwable = update = Platform$.MODULE$.composeErrors(e0, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Throwable[]{e}));
            } while (!ref.compareAndSet((Object)current, (Object)update));
        }

        private final Object visit$$anonfun$1(Iterant.Concat ref$1) {
            return this.wasErrorHandled ? this.F.pure(Iterant$.MODULE$.empty()) : package.all$.MODULE$.toFunctorOps(ref$1.rh(), this.F).map((Function1)this);
        }

        private final void $anonfun$2$$anonfun$2(AtomicAny errors$6, Throwable e$1) {
            this.pushError((Atomic<Throwable>)errors$6, e$1);
        }

        private final Iterant visit$$anonfun$2$$anonfun$1(AtomicAny errors$7) {
            Throwable err = (Throwable)errors$7.getAndSet(null);
            return err != null && !this.wasErrorHandled ? (Iterant)this.f.apply((Object)err) : Iterant$.MODULE$.empty();
        }

        private final Iterant.Concat visit$$anonfun$2(Object acquire$1, Function1 use$1, Function2 release$1) {
            Object initialValue$proxy1 = null;
            AtomicBuilder builder$proxy1 = AtomicBuilder$.MODULE$.AtomicRefBuilder();
            AtomicAny errors = (AtomicAny)builder$proxy1.buildInstance(initialValue$proxy1, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(acquire$1, this.F);
            Iterant.Scope lh = Iterant$Scope$.MODULE$.apply(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.F), (Function1 & Serializable)es -> package.all$.MODULE$.toFlatMapOps(this.F.pure(es), this.F).flatMap((Function1 & Serializable)x$1 -> {
                Object object;
                Either either = x$1;
                if (either instanceof Left) {
                    Throwable e2 = (Throwable)((Left)either).value();
                    this.pushError((Atomic<Throwable>)errors, e2);
                    object = this.F.pure(Iterant$.MODULE$.empty());
                } else if (either instanceof Right) {
                    Object s = ((Right)either).value();
                    try {
                        Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(use$1.apply(s), this.F);
                        object = package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.handleError$extension(object2, (Function1 & Serializable)e -> {
                            this.pushError((Atomic<Throwable>)errors, (Throwable)e);
                            return Iterant$.MODULE$.empty();
                        }, this.F), this.F).map((Function1)this);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable e3 = throwable3 = (Throwable)option.get();
                            this.pushError((Atomic<Throwable>)errors, e3);
                            object = this.F.pure(Iterant$.MODULE$.empty());
                        }
                        throw throwable;
                    }
                } else {
                    throw new MatchError((Object)either);
                }
                return object;
            }), (Function2 & Serializable)(es, exit) -> {
                Object object;
                Either either = es;
                if (either instanceof Left) {
                    object = this.F.unit();
                } else if (either instanceof Right) {
                    Object s = ((Right)either).value();
                    try {
                        object = this.F.handleError(release$1.apply(s, exit), (Function1)(JProcedure1 & Serializable)e -> this.pushError((Atomic<Throwable>)errors, (Throwable)e));
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable e2 = throwable3 = (Throwable)option.get();
                            object = this.F.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$2$$anonfun$2(errors, e2)));
                        }
                        throw throwable;
                    }
                } else {
                    throw new MatchError((Object)either);
                }
                return object;
            });
            return Iterant$Concat$.MODULE$.apply(this.F.pure(lh), this.F.delay(() -> this.visit$$anonfun$2$$anonfun$1(errors)));
        }
    }
}

