/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.internal;

import cats.effect.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import java.io.Serializable;
import monix.execution.internal.collection.ChunkedArrayStack;
import monix.execution.internal.collection.ChunkedArrayStack$;
import monix.tail.Iterant;
import monix.tail.Iterant$;
import monix.tail.Iterant$Suspend$;
import monix.tail.batches.BatchCursor;
import monix.tail.internal.IterantScanEval$;
import monix.tail.internal.package$;
import monix.tail.internal.package$ScopeExtensions$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;

public final class IterantScanEval {
    public static <F, A, S> Iterant<F, S> apply(Iterant<F, A> iterant, Object object, Function2<S, A, Object> function2, Sync<F> sync) {
        return IterantScanEval$.MODULE$.apply(iterant, object, function2, sync);
    }

    private static class Loop<F, S, A>
    extends Iterant.Visitor<F, A, Iterant<F, S>> {
        private final Function2<S, A, F> ff;
        private final Sync<F> F;
        private S state;
        private ChunkedArrayStack<F> stackRef;

        public Loop(S seed, Function2<S, A, Object> ff, Sync<F> F) {
            this.ff = ff;
            this.F = F;
            this.state = seed;
        }

        private void stackPush(F item) {
            if (this.stackRef == null) {
                this.stackRef = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
            }
            this.stackRef.push(item);
        }

        private F stackPop() {
            return (F)(this.stackRef != null ? this.stackRef.pop() : null);
        }

        @Override
        public Iterant<F, S> visit(Iterant.Next<F, A> ref) {
            return this.processHead(ref.item(), ref.rest());
        }

        @Override
        public Iterant<F, S> visit(Iterant.NextBatch<F, A> ref) {
            return this.visit((Iterant.NextCursor)ref.toNextCursor());
        }

        @Override
        public Iterant<F, S> visit(Iterant.NextCursor<F, A> ref) {
            Iterant iterant;
            BatchCursor<A> cursor = ref.cursor();
            if (!cursor.hasNext()) {
                iterant = Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
            } else {
                A head = cursor.next();
                F tail = cursor.hasNext() ? this.F.pure(ref) : ref.rest();
                iterant = this.processHead(head, tail);
            }
            return iterant;
        }

        @Override
        public Iterant<F, S> visit(Iterant.Suspend<F, A> ref) {
            return Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
        }

        @Override
        public Iterant<F, S> visit(Iterant.Concat<F, A> ref) {
            this.stackPush(ref.rh());
            return Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.lh(), this.F).map((Function1)this));
        }

        @Override
        public <R> Iterant<F, S> visit(Iterant.Scope<F, R, A> ref) {
            Iterant.Scope scope = package$.MODULE$.ScopeExtensions(ref);
            return package$ScopeExtensions$.MODULE$.runMap$extension(scope, this, this.F);
        }

        @Override
        public Iterant<F, S> visit(Iterant.Last<F, A> ref) {
            Iterant<F, S> iterant;
            F f = this.stackPop();
            if (f == null) {
                Object fa = this.ff.apply(this.state, ref.item());
                iterant = Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(fa, this.F).map((Function1 & Serializable)s -> Iterant$.MODULE$.lastS(s)));
            } else {
                F some = f;
                iterant = this.processHead(ref.item(), some);
            }
            return iterant;
        }

        @Override
        public Iterant<F, S> visit(Iterant.Halt<F, A> ref) {
            Iterant.Suspend suspend;
            Option<Throwable> option = ref.e();
            if (option instanceof Some) {
                suspend = (Iterant.Suspend)((Object)ref);
            } else if (None$.MODULE$.equals(option)) {
                F f = this.stackPop();
                if (f == null) {
                    suspend = ref;
                } else {
                    F next = f;
                    suspend = Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(next, this.F).map((Function1)this));
                }
            } else {
                throw new MatchError(option);
            }
            return suspend;
        }

        @Override
        public Iterant<F, S> fail(Throwable e) {
            return Iterant$.MODULE$.raiseError(e);
        }

        private Iterant<F, S> processHead(A a, F rest) {
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFunctorOps(this.ff.apply(this.state, a), this.F).map((Function1 & Serializable)s -> {
                this.state = s;
                return Iterant$.MODULE$.nextS(s, package.all$.MODULE$.toFunctorOps(rest, this.F).map((Function1)this));
            }), this.F);
            Object next = ApplicativeErrorOps$.MODULE$.handleError$extension(object, (Function1 & Serializable)ex -> Iterant$.MODULE$.raiseError((Throwable)ex), this.F);
            return Iterant$Suspend$.MODULE$.apply(next);
        }
    }
}

