/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.internal;

import cats.effect.Sync;
import cats.syntax.package;
import monix.tail.Iterant;
import monix.tail.Iterant$;
import monix.tail.Iterant$Concat$;
import monix.tail.Iterant$Next$;
import monix.tail.Iterant$NextCursor$;
import monix.tail.Iterant$Suspend$;
import monix.tail.batches.BatchCursor;
import monix.tail.batches.BatchCursor$;
import monix.tail.internal.IterantTakeWhile$;
import monix.tail.internal.package$;
import monix.tail.internal.package$ScopeExtensions$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class IterantTakeWhile {
    public static <F, A> Iterant<F, A> apply(Iterant<F, A> iterant, Function1<A, Object> function1, Sync<F> sync) {
        return IterantTakeWhile$.MODULE$.apply(iterant, function1, sync);
    }

    private static class Loop<F, A>
    extends Iterant.Visitor<F, A, Iterant<F, A>> {
        private final Function1<A, Object> p;
        private final Sync<F> F;
        private boolean isActive;

        public Loop(Function1<A, Object> p, Sync<F> F) {
            this.p = p;
            this.F = F;
            this.isActive = true;
        }

        @Override
        public Iterant<F, A> visit(Iterant.Next<F, A> ref) {
            Iterant iterant;
            A item = ref.item();
            if (BoxesRunTime.unboxToBoolean((Object)this.p.apply(item))) {
                iterant = Iterant$Next$.MODULE$.apply(item, package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
            } else {
                this.isActive = false;
                iterant = Iterant$.MODULE$.empty();
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> visit(Iterant.NextBatch<F, A> ref) {
            return this.visit((Iterant.NextCursor)ref.toNextCursor());
        }

        @Override
        public Iterant<F, A> visit(Iterant.Suspend<F, A> ref) {
            return Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
        }

        @Override
        public Iterant<F, A> visit(Iterant.Concat<F, A> ref) {
            return Iterant$Concat$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.lh(), this.F).map((Function1)this), this.F.defer(() -> this.visit$$anonfun$1(ref)));
        }

        @Override
        public <S> Iterant<F, A> visit(Iterant.Scope<F, S, A> ref) {
            Iterant.Scope scope = package$.MODULE$.ScopeExtensions(ref);
            return package$ScopeExtensions$.MODULE$.runMap$extension(scope, this, this.F);
        }

        @Override
        public Iterant<F, A> visit(Iterant.Last<F, A> ref) {
            Iterant iterant;
            A item = ref.item();
            if (BoxesRunTime.unboxToBoolean((Object)this.p.apply(item))) {
                iterant = ref;
            } else {
                this.isActive = false;
                iterant = Iterant$.MODULE$.empty();
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> visit(Iterant.Halt<F, A> ref) {
            return ref;
        }

        @Override
        public Iterant<F, A> fail(Throwable e) {
            return Iterant$.MODULE$.raiseError(e);
        }

        @Override
        public Iterant<F, A> visit(Iterant.NextCursor<F, A> ref) {
            Iterant iterant;
            Iterant.NextCursor<F, A> nextCursor = ref;
            if (nextCursor == null) {
                throw new MatchError(nextCursor);
            }
            Iterant.NextCursor<F, A> nextCursor2 = Iterant$NextCursor$.MODULE$.unapply(nextCursor);
            BatchCursor<A> batchCursor = nextCursor2._1();
            F f = nextCursor2._2();
            BatchCursor<A> cursor = batchCursor;
            F rest = f;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(cursor, rest);
            BatchCursor cursor2 = (BatchCursor)tuple2._1();
            Object rest2 = tuple2._2();
            int batchSize = cursor2.recommendedBatchSize();
            if (!cursor2.hasNext()) {
                iterant = Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(rest2, this.F).map((Function1)this));
            } else if (batchSize <= 1) {
                Object item = cursor2.next();
                if (BoxesRunTime.unboxToBoolean((Object)this.p.apply(item))) {
                    iterant = Iterant$Next$.MODULE$.apply(item, package.all$.MODULE$.toFunctorOps(this.F.pure(ref), this.F).map((Function1)this));
                } else {
                    this.isActive = false;
                    iterant = Iterant$.MODULE$.empty();
                }
            } else {
                ArrayBuffer buffer = ArrayBuffer$.MODULE$.empty();
                boolean bl = true;
                int idx = 0;
                while (bl && idx < batchSize && cursor2.hasNext()) {
                    Object item = cursor2.next();
                    if (BoxesRunTime.unboxToBoolean((Object)this.p.apply(item))) {
                        buffer.$plus$eq(item);
                        ++idx;
                        continue;
                    }
                    bl = false;
                }
                BatchCursor bufferCursor = BatchCursor$.MODULE$.fromArray(buffer.toArray(ClassTag$.MODULE$.Any()));
                this.isActive = bl;
                if (bl) {
                    Object next = idx < batchSize ? rest2 : this.F.pure(ref);
                    iterant = Iterant$NextCursor$.MODULE$.apply(bufferCursor, package.all$.MODULE$.toFunctorOps(next, this.F).map((Function1)this));
                } else {
                    iterant = Iterant$NextCursor$.MODULE$.apply(bufferCursor, this.F.pure(Iterant$.MODULE$.empty()));
                }
            }
            return iterant;
        }

        private final Object visit$$anonfun$1(Iterant.Concat ref$1) {
            return this.isActive ? package.all$.MODULE$.toFunctorOps(ref$1.rh(), this.F).map((Function1)this) : this.F.pure(Iterant$.MODULE$.empty());
        }
    }
}

