/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.subscriptions;

import io.moquette.broker.subscriptions.INode;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class CNode
implements Comparable<CNode> {
    private final Token token;
    private final List<INode> children;
    List<Subscription> subscriptions;

    CNode(Token token) {
        this.children = new ArrayList<INode>();
        this.subscriptions = new ArrayList<Subscription>();
        this.token = token;
    }

    private CNode(Token token, List<INode> children, List<Subscription> subscriptions) {
        this.token = token;
        this.subscriptions = new ArrayList<Subscription>(subscriptions);
        this.children = new ArrayList<INode>(children);
    }

    public Token getToken() {
        return this.token;
    }

    List<INode> allChildren() {
        return new ArrayList<INode>(this.children);
    }

    Optional<INode> childOf(Token token) {
        int idx = this.findIndexForToken(token);
        if (idx < 0) {
            return Optional.empty();
        }
        return Optional.of(this.children.get(idx));
    }

    private int findIndexForToken(Token token) {
        INode tempTokenNode = new INode(new CNode(token));
        return Collections.binarySearch(this.children, tempTokenNode, (node, tokenHolder) -> node.mainNode().token.compareTo(tokenHolder.mainNode().token));
    }

    private boolean equalsToken(Token token) {
        return token != null && this.token != null && this.token.equals(token);
    }

    public int hashCode() {
        return Objects.hash(this.token);
    }

    CNode copy() {
        return new CNode(this.token, this.children, this.subscriptions);
    }

    public void add(INode newINode) {
        int idx = this.findIndexForToken(newINode.mainNode().token);
        if (idx < 0) {
            this.children.add(-1 - idx, newINode);
        } else {
            this.children.add(idx, newINode);
        }
    }

    public void remove(INode node) {
        int idx = this.findIndexForToken(node.mainNode().token);
        this.children.remove(idx);
    }

    CNode addSubscription(Subscription newSubscription) {
        int idx = Collections.binarySearch(this.subscriptions, newSubscription);
        if (idx >= 0) {
            Subscription existing = this.subscriptions.get(idx);
            if (existing.getRequestedQos().value() < newSubscription.getRequestedQos().value()) {
                this.subscriptions.set(idx, newSubscription);
            }
        } else {
            this.subscriptions.add(-1 - idx, new Subscription(newSubscription));
        }
        return this;
    }

    boolean containsOnly(String clientId) {
        for (Subscription sub : this.subscriptions) {
            if (sub.clientId.equals(clientId)) continue;
            return false;
        }
        return !this.subscriptions.isEmpty();
    }

    public boolean contains(String clientId) {
        for (Subscription sub : this.subscriptions) {
            if (!sub.clientId.equals(clientId)) continue;
            return true;
        }
        return false;
    }

    void removeSubscriptionsFor(String clientId) {
        HashSet<Subscription> toRemove = new HashSet<Subscription>();
        for (Subscription sub : this.subscriptions) {
            if (!sub.clientId.equals(clientId)) continue;
            toRemove.add(sub);
        }
        this.subscriptions.removeAll(toRemove);
    }

    @Override
    public int compareTo(CNode o) {
        return this.token.compareTo(o.token);
    }
}

