/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util;

import io.mosip.biometrics.util.ConvertRequestDto;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jnbis.api.model.Bitmap;
import org.jnbis.internal.WsqDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUtil.class);

    public static BufferedImage getBufferedImage(ConvertRequestDto convertRequestDto) throws Exception {
        BufferedImage bufferedImage = null;
        switch (convertRequestDto.getImageType()) {
            case 0: {
                bufferedImage = ImageIO.read(new ByteArrayInputStream(convertRequestDto.getInputBytes()));
                break;
            }
            case 1: {
                WsqDecoder decoder = new WsqDecoder();
                Bitmap bitmap = decoder.decode(convertRequestDto.getInputBytes());
                bufferedImage = CommonUtil.convert(bitmap);
            }
        }
        return bufferedImage;
    }

    private static BufferedImage convert(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        byte[] data = bitmap.getPixels();
        BufferedImage image = new BufferedImage(width, height, 10);
        WritableRaster raster = image.getRaster();
        raster.setDataElements(0, 0, width, height, data);
        return image;
    }

    public static byte[] convertJP2ToJPEGBytes(byte[] jp2000Bytes) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)ImageIO.read(new ByteArrayInputStream(jp2000Bytes)), "jpg", baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Failed to get jpg image", (Throwable)e);
                return null;
            }
        }
        baos.close();
        return byArray;
    }
}

