/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.face;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.face.FaceCaptureDeviceTechnology;
import io.mosip.biometrics.util.face.FaceCaptureDeviceType;
import io.mosip.biometrics.util.face.FaceCaptureDeviceVendor;
import io.mosip.biometrics.util.face.FaceCertificationFlag;
import io.mosip.biometrics.util.face.FaceFormatIdentifier;
import io.mosip.biometrics.util.face.FaceQualityBlock;
import io.mosip.biometrics.util.face.FaceVersionNumber;
import io.mosip.biometrics.util.face.FacialInformation;
import io.mosip.biometrics.util.face.GeneralHeader;
import io.mosip.biometrics.util.face.ImageInformation;
import io.mosip.biometrics.util.face.LandmarkPoints;
import io.mosip.biometrics.util.face.Representation;
import io.mosip.biometrics.util.face.TemporalSequenceFlags;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class FaceBDIR
extends AbstractImageInfo {
    private GeneralHeader generalHeader;
    private Representation representation;

    public FaceBDIR(FaceFormatIdentifier formatIdentifier, FaceVersionNumber versionNumber, FaceCertificationFlag certificationFlag, TemporalSequenceFlags temporalSemantics, Date captureDate, int noOfRepresentations, FaceQualityBlock[] qualityBlocks, FacialInformation facialInformation, LandmarkPoints[] landmarkPoints, ImageInformation imageInformation, byte[] image) {
        this.setRepresentation(new Representation(captureDate, qualityBlocks, facialInformation, landmarkPoints, imageInformation, image));
        int totalRepresentationLength = this.getRepresentation().getRecordLength();
        this.setGeneralHeader(new GeneralHeader(formatIdentifier, versionNumber, totalRepresentationLength, noOfRepresentations, certificationFlag, temporalSemantics));
    }

    public FaceBDIR(FaceFormatIdentifier formatIdentifier, FaceVersionNumber versionNumber, FaceCertificationFlag certificationFlag, TemporalSequenceFlags temporalSemantics, FaceCaptureDeviceTechnology sourceType, FaceCaptureDeviceVendor deviceVendor, FaceCaptureDeviceType deviceType, Date captureDate, int noOfRepresentations, FaceQualityBlock[] qualityBlocks, FacialInformation facialInformation, LandmarkPoints[] landmarkPoints, ImageInformation imageInformation, byte[] image) {
        this.setRepresentation(new Representation(captureDate, sourceType, deviceVendor, deviceType, qualityBlocks, facialInformation, landmarkPoints, imageInformation, image));
        int totalRepresentationLength = this.getRepresentation().getRecordLength();
        this.setGeneralHeader(new GeneralHeader(formatIdentifier, versionNumber, totalRepresentationLength, noOfRepresentations, certificationFlag, temporalSemantics));
    }

    public FaceBDIR(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    public int getRecordLength() {
        return this.getGeneralHeader().getRecordLength() + 1 * this.getRepresentation().getRecordLength();
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setGeneralHeader(new GeneralHeader(inputStream));
        int generalHeaderLength = this.getGeneralHeader().getRecordLength();
        int noOfRepresentations = this.getGeneralHeader().getNoOfRepresentations();
        int totalRepresentationLength = this.getGeneralHeader().getTotalRepresentationLength();
        if (noOfRepresentations == 1) {
            this.setRepresentation(new Representation(inputStream));
        }
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        this.getGeneralHeader().writeObject(outputStream);
        this.getRepresentation().writeObject(outputStream);
        outputStream.flush();
    }

    public GeneralHeader getGeneralHeader() {
        return this.generalHeader;
    }

    public void setGeneralHeader(GeneralHeader generalHeader) {
        this.generalHeader = generalHeader;
    }

    public Representation getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(Representation representation) {
        this.representation = representation;
    }

    public String toString() {
        return "\nFaceBDIR [generalHeader=" + this.generalHeader + ", representation=" + this.representation + "]\n";
    }
}

