/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.face;

import io.mosip.biometrics.util.CommonUtil;
import io.mosip.biometrics.util.ConvertRequestDto;
import io.mosip.biometrics.util.face.FaceBDIR;
import io.mosip.biometrics.util.face.ImageData;
import io.mosip.biometrics.util.face.ImageDataType;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaceDecoder.class);

    private static FaceBDIR getFaceBDIRISO19794_5_2011(byte[] isoData) throws Exception {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(isoData);){
            FaceBDIR faceBDIR;
            try (DataInputStream inputStream = new DataInputStream(bais);){
                FaceBDIR faceBDIR2 = new FaceBDIR(inputStream);
                LOGGER.info("faceBDIR :: ", (Object)faceBDIR2);
                faceBDIR = faceBDIR2;
            }
            return faceBDIR;
        }
    }

    public static FaceBDIR getFaceBDIR(ConvertRequestDto convertRequestDto) throws Exception {
        switch (convertRequestDto.getVersion()) {
            case "ISO19794_5_2011": {
                return FaceDecoder.getFaceBDIRISO19794_5_2011(convertRequestDto.getInputBytes());
            }
        }
        throw new UnsupportedOperationException();
    }

    private static byte[] convertFaceISO19794_5_2011ToImage(byte[] isoData) throws Exception {
        byte[] byArray;
        ImageData imageData = FaceDecoder.getFaceBDIRISO19794_5_2011(isoData).getRepresentation().getRepresentationData().getImageData();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)ImageIO.read(new ByteArrayInputStream(imageData.getImage())), "jpg", baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Failed to get jpg image", (Throwable)e);
                return imageData.getImage();
            }
        }
        baos.close();
        return byArray;
    }

    public static BufferedImage convertFaceISOToBufferedImage(ConvertRequestDto convertRequestDto) throws Exception {
        switch (convertRequestDto.getVersion()) {
            case "ISO19794_5_2011": {
                FaceBDIR faceBDIR = FaceDecoder.getFaceBDIRISO19794_5_2011(convertRequestDto.getInputBytes());
                return ImageIO.read(new ByteArrayInputStream(faceBDIR.getRepresentation().getRepresentationData().getImageData().getImage()));
            }
        }
        throw new UnsupportedOperationException();
    }

    public static byte[] convertFaceISOToImageBytes(ConvertRequestDto convertRequestDto) throws Exception {
        switch (convertRequestDto.getVersion()) {
            case "ISO19794_5_2011": {
                FaceBDIR faceBDIR = FaceDecoder.getFaceBDIRISO19794_5_2011(convertRequestDto.getInputBytes());
                ImageDataType imageDataType = faceBDIR.getRepresentation().getRepresentationHeader().getImageInformation().getImageDataType();
                switch (imageDataType) {
                    case JPEG2000_LOSSY: 
                    case JPEG2000_LOSS_LESS: {
                        return CommonUtil.convertJP2ToJPEGBytes(faceBDIR.getRepresentation().getRepresentationData().getImageData().getImage());
                    }
                }
                return faceBDIR.getRepresentation().getRepresentationData().getImageData().getImage();
            }
        }
        throw new UnsupportedOperationException();
    }
}

