/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.face;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.face.FaceQualityAlgorithmIdentifier;
import io.mosip.biometrics.util.face.FaceQualityAlgorithmVendorIdentifier;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceQualityBlock
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaceQualityBlock.class);
    private int qualityScore;
    private FaceQualityAlgorithmVendorIdentifier qualityAlgorithmVendorIdentifier;
    private FaceQualityAlgorithmIdentifier qualityAlgorithmIdentifier;

    public FaceQualityBlock(int qualityScore) {
        this.setQualityScore(qualityScore);
        this.setQualityAlgorithmVendorIdentifier(FaceQualityAlgorithmVendorIdentifier.ALGORITHM_VENDOR_IDENTIFIER);
        this.setQualityAlgorithmIdentifier(FaceQualityAlgorithmIdentifier.ALGORITHM_IDENTIFIER);
    }

    public FaceQualityBlock(int qualityScore, FaceQualityAlgorithmVendorIdentifier qualityAlgorithmVendorIdentifier, FaceQualityAlgorithmIdentifier qualityAlgorithmIdentifier) {
        this.setQualityScore(qualityScore);
        this.setQualityAlgorithmVendorIdentifier(qualityAlgorithmVendorIdentifier);
        this.setQualityAlgorithmIdentifier(qualityAlgorithmIdentifier);
    }

    public FaceQualityBlock(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setQualityScore(inputStream.readUnsignedByte());
        this.setQualityAlgorithmVendorIdentifier(FaceQualityAlgorithmVendorIdentifier.fromValue(inputStream.readUnsignedShort()));
        this.setQualityAlgorithmIdentifier(FaceQualityAlgorithmIdentifier.fromValue(inputStream.readUnsignedShort()));
    }

    @Override
    public int getRecordLength() {
        return 5;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeByte(this.getQualityScore());
        outputStream.writeShort(this.getQualityAlgorithmVendorIdentifier().value());
        outputStream.writeShort(this.getQualityAlgorithmIdentifier().value());
        outputStream.flush();
    }

    public int getQualityScore() {
        return this.qualityScore;
    }

    public void setQualityScore(int qualityScore) {
        this.qualityScore = qualityScore;
    }

    public FaceQualityAlgorithmVendorIdentifier getQualityAlgorithmVendorIdentifier() {
        return this.qualityAlgorithmVendorIdentifier;
    }

    public void setQualityAlgorithmVendorIdentifier(FaceQualityAlgorithmVendorIdentifier qualityAlgorithmVendorIdentifier) {
        this.qualityAlgorithmVendorIdentifier = qualityAlgorithmVendorIdentifier;
    }

    public FaceQualityAlgorithmIdentifier getQualityAlgorithmIdentifier() {
        return this.qualityAlgorithmIdentifier;
    }

    public void setQualityAlgorithmIdentifier(FaceQualityAlgorithmIdentifier qualityAlgorithmIdentifier) {
        this.qualityAlgorithmIdentifier = qualityAlgorithmIdentifier;
    }

    public String toString() {
        return "\nQualityBlock [QualityBlockRecordLength=" + this.getRecordLength() + ", qualityScore=" + this.qualityScore + ", qualityAlgorithmVendorIdentifier=" + this.qualityAlgorithmVendorIdentifier + ", qualityAlgorithmIdentifier=" + this.qualityAlgorithmIdentifier + "]\n";
    }
}

