/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.face;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.face.Expression;
import io.mosip.biometrics.util.face.EyeColour;
import io.mosip.biometrics.util.face.Features;
import io.mosip.biometrics.util.face.Gender;
import io.mosip.biometrics.util.face.HairColour;
import io.mosip.biometrics.util.face.HeightCodes;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacialInformation
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(FacialInformation.class);
    private static final int YAW = 0;
    private static final int PITCH = 1;
    private static final int ROLL = 2;
    private int noOfLandMarkPoints;
    private Gender gender;
    private EyeColour eyeColor;
    private HairColour hairColor;
    private HeightCodes subjectHeight;
    private Features featuresMask;
    private Expression expressionMask;
    private int[] poseAngle = new int[3];
    private int[] poseAngleUncertainty = new int[3];

    public FacialInformation(int noOfLandMarkPoints, int[] poseAngle, int[] poseAngleUncertainty) {
        this.setNoOfLandMarkPoints(noOfLandMarkPoints);
        this.setGender(Gender.UNSPECIFIED);
        this.setEyeColor(EyeColour.UNSPECIFIED);
        this.setHairColor(HairColour.UNSPECIFIED);
        this.setSubjectHeight(HeightCodes.UNSPECIFIED);
        this.setFeaturesMask(Features.FEATURES_ARE_SPECIFIED);
        this.setExpressionMask(Expression.UNSPECIFIED);
        this.setPoseAngle(new int[3]);
        System.arraycopy(poseAngle, 0, poseAngle, 0, 3);
        this.setPoseAngleUncertainty(new int[3]);
        System.arraycopy(poseAngleUncertainty, 0, poseAngleUncertainty, 0, 3);
    }

    public FacialInformation(int noOflandMarkPoints, Gender gender, EyeColour eyeColor, HairColour hairColor, HeightCodes subjectHeight, Features propertyMask, Expression expressionMask, int[] poseAngle, int[] poseAngleUncertainty) {
        this.setNoOfLandMarkPoints(noOflandMarkPoints);
        this.setGender(gender);
        this.setEyeColor(eyeColor);
        this.setHairColor(hairColor);
        this.setSubjectHeight(subjectHeight);
        this.setFeaturesMask(propertyMask);
        this.setExpressionMask(expressionMask);
        this.setPoseAngle(new int[3]);
        System.arraycopy(poseAngle, 0, poseAngle, 0, 3);
        this.setPoseAngleUncertainty(new int[3]);
        System.arraycopy(poseAngleUncertainty, 0, poseAngleUncertainty, 0, 3);
    }

    public FacialInformation(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        int br;
        int bp;
        int by;
        this.setNoOfLandMarkPoints(inputStream.readUnsignedShort());
        this.setGender(Gender.fromValue(inputStream.readUnsignedByte()));
        this.setEyeColor(EyeColour.fromValue(inputStream.readUnsignedByte()));
        this.setHairColor(HairColour.fromValue(inputStream.readUnsignedByte()));
        this.setSubjectHeight(HeightCodes.fromValue(inputStream.readUnsignedByte()));
        int featureMask = inputStream.readUnsignedByte();
        featureMask = featureMask << 16 | inputStream.readUnsignedShort();
        this.setFeaturesMask(Features.fromValue(featureMask));
        this.setExpressionMask(Expression.fromValue(inputStream.readUnsignedShort()));
        this.poseAngle = new int[3];
        this.poseAngle[0] = by = inputStream.readUnsignedByte();
        this.poseAngle[1] = bp = inputStream.readUnsignedByte();
        this.poseAngle[2] = br = inputStream.readUnsignedByte();
        this.setPoseAngle(this.poseAngle);
        this.poseAngleUncertainty = new int[3];
        this.poseAngleUncertainty[0] = inputStream.readUnsignedByte();
        this.poseAngleUncertainty[1] = inputStream.readUnsignedByte();
        this.poseAngleUncertainty[2] = inputStream.readUnsignedByte();
        this.setPoseAngleUncertainty(this.poseAngleUncertainty);
    }

    @Override
    public int getRecordLength() {
        return 17;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        int i;
        outputStream.writeShort(this.getNoOfLandMarkPoints());
        outputStream.writeByte(this.getGender().value());
        outputStream.writeByte(this.getEyeColor().value());
        outputStream.writeByte(this.getHairColor().value());
        outputStream.writeByte(this.getSubjectHeight().value());
        outputStream.writeByte((byte)(((long)this.getFeaturesMask().value() & 0xFF0000L) >> 16));
        outputStream.writeByte((byte)(((long)this.getFeaturesMask().value() & 0xFF00L) >> 8));
        outputStream.writeByte((byte)((long)this.getFeaturesMask().value() & 0xFFL));
        outputStream.writeShort(this.getExpressionMask().value());
        for (i = 0; i < 3; ++i) {
            int b = this.poseAngle[i];
            outputStream.writeByte(b);
        }
        for (i = 0; i < 3; ++i) {
            outputStream.writeByte(this.poseAngleUncertainty[i]);
        }
        outputStream.flush();
    }

    public int getNoOfLandMarkPoints() {
        return this.noOfLandMarkPoints;
    }

    public void setNoOfLandMarkPoints(int noOfLandMarkPoints) {
        this.noOfLandMarkPoints = noOfLandMarkPoints;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public EyeColour getEyeColor() {
        return this.eyeColor;
    }

    public void setEyeColor(EyeColour eyeColor) {
        this.eyeColor = eyeColor;
    }

    public HairColour getHairColor() {
        return this.hairColor;
    }

    public void setHairColor(HairColour hairColor) {
        this.hairColor = hairColor;
    }

    public HeightCodes getSubjectHeight() {
        return this.subjectHeight;
    }

    public void setSubjectHeight(HeightCodes subjectHeight) {
        this.subjectHeight = subjectHeight;
    }

    public Features getFeaturesMask() {
        return this.featuresMask;
    }

    public void setFeaturesMask(Features featuresMask) {
        this.featuresMask = featuresMask;
    }

    public Expression getExpressionMask() {
        return this.expressionMask;
    }

    public void setExpressionMask(Expression expressionMask) {
        this.expressionMask = expressionMask;
    }

    public int[] getPoseAngle() {
        return this.poseAngle;
    }

    public void setPoseAngle(int[] poseAngle) {
        this.poseAngle = poseAngle;
    }

    public int[] getPoseAngleUncertainty() {
        return this.poseAngleUncertainty;
    }

    public void setPoseAngleUncertainty(int[] poseAngleUncertainty) {
        this.poseAngleUncertainty = poseAngleUncertainty;
    }

    public String toString() {
        return "\nFacialInformation [FacialInformationRecordLength=" + this.getRecordLength() + ", noOfLandMarkPoints=" + this.noOfLandMarkPoints + ", gender=" + this.gender + ", eyeColor=" + this.eyeColor + ", hairColor=" + this.hairColor + ", subjectHeight=" + this.subjectHeight + ", featuresMask=" + this.featuresMask + ", expressionMask=" + this.expressionMask + ", poseAngle=" + Arrays.toString(this.poseAngle) + ", poseAngleUncertainty=" + Arrays.toString(this.poseAngleUncertainty) + "]\n";
    }
}

