/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.face;

public class FeaturePoint {
    private int type;
    private int majorCode;
    private int minorCode;
    private int x;
    private int y;

    public FeaturePoint(int type, int majorCode, int minorCode, int x, int y) {
        this.type = type;
        this.majorCode = majorCode;
        this.minorCode = minorCode;
        this.x = x;
        this.y = y;
    }

    FeaturePoint(int type, byte code, int x, int y) {
        this(type, (code & 0xF0) >> 4, code & 0xF, x, y);
    }

    public int getMajorCode() {
        return this.majorCode;
    }

    public int getMinorCode() {
        return this.minorCode;
    }

    public int getType() {
        return this.type;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("( point: ");
        out.append(this.getMajorCode());
        out.append(".");
        out.append(this.getMinorCode());
        out.append(", ");
        out.append("type: ");
        out.append(Integer.toHexString(this.type));
        out.append(", ");
        out.append("(");
        out.append(this.x);
        out.append(", ");
        out.append(this.y);
        out.append(")");
        out.append(")");
        return out.toString();
    }
}

