/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.face;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.face.FaceCertificationFlag;
import io.mosip.biometrics.util.face.FaceFormatIdentifier;
import io.mosip.biometrics.util.face.FaceVersionNumber;
import io.mosip.biometrics.util.face.TemporalSequenceFlags;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralHeader
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralHeader.class);
    private FaceFormatIdentifier formatIdentifier;
    private FaceVersionNumber versionNumber;
    private int totalRepresentationLength;
    private int noOfRepresentations;
    private FaceCertificationFlag certificationFlag;
    private TemporalSequenceFlags temporalSemantics;

    public GeneralHeader(int totalRepresentationLength, int noOfRepresentations) {
        this.setFormatIdentifier(FaceFormatIdentifier.FORMAT_FAC);
        this.setVersionNumber(FaceVersionNumber.VERSION_030);
        this.setTotalRepresentationLength(totalRepresentationLength);
        this.setNoOfRepresentations(noOfRepresentations);
        this.setCertificationFlag(FaceCertificationFlag.UNSPECIFIED);
        this.setTemporalSemantics(TemporalSequenceFlags.ONE_REPRESENTATION);
    }

    public GeneralHeader(FaceFormatIdentifier formatIdentifier, FaceVersionNumber versionNumber, int totalRepresentationLength, int noOfRepresentations, FaceCertificationFlag certificationFlag, TemporalSequenceFlags temporalSemantics) {
        this.setFormatIdentifier(formatIdentifier);
        this.setVersionNumber(versionNumber);
        this.setTotalRepresentationLength(totalRepresentationLength);
        this.setNoOfRepresentations(noOfRepresentations);
        this.setCertificationFlag(certificationFlag);
        this.setTemporalSemantics(temporalSemantics);
    }

    public GeneralHeader(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setFormatIdentifier(FaceFormatIdentifier.fromValue((int)((long)inputStream.readInt() & 0xFFFFFFFFL)));
        this.setVersionNumber(FaceVersionNumber.fromValue((int)((long)inputStream.readInt() & 0xFFFFFFFFL)));
        this.setTotalRepresentationLength((int)(((long)inputStream.readInt() & 0xFFFFFFFFL) - (long)this.getRecordLength()));
        this.setNoOfRepresentations(inputStream.readUnsignedShort());
        this.setCertificationFlag(FaceCertificationFlag.fromValue(inputStream.readUnsignedByte()));
        this.setTemporalSemantics(TemporalSequenceFlags.fromValue(inputStream.readUnsignedShort()));
    }

    @Override
    public int getRecordLength() {
        return 17;
    }

    @Override
    protected void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.getFormatIdentifier().value());
        outputStream.writeInt(this.getVersionNumber().value());
        outputStream.writeInt(this.getRecordLength() + this.getTotalRepresentationLength());
        outputStream.writeShort(this.getNoOfRepresentations());
        outputStream.writeByte(this.getCertificationFlag().value());
        outputStream.writeShort(this.getTemporalSemantics().value());
        outputStream.flush();
    }

    public FaceFormatIdentifier getFormatIdentifier() {
        return this.formatIdentifier;
    }

    public void setFormatIdentifier(FaceFormatIdentifier formatIdentifier) {
        this.formatIdentifier = formatIdentifier;
    }

    public FaceVersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(FaceVersionNumber versionNumber) {
        this.versionNumber = versionNumber;
    }

    public int getTotalRepresentationLength() {
        return this.totalRepresentationLength;
    }

    public void setTotalRepresentationLength(int totalRepresentationLength) {
        this.totalRepresentationLength = totalRepresentationLength;
    }

    public int getNoOfRepresentations() {
        return this.noOfRepresentations;
    }

    public void setNoOfRepresentations(int noOfRepresentations) {
        this.noOfRepresentations = noOfRepresentations;
    }

    public FaceCertificationFlag getCertificationFlag() {
        return this.certificationFlag;
    }

    public void setCertificationFlag(FaceCertificationFlag certificationFlag) {
        this.certificationFlag = certificationFlag;
    }

    public TemporalSequenceFlags getTemporalSemantics() {
        return this.temporalSemantics;
    }

    public void setTemporalSemantics(TemporalSequenceFlags temporalSemantics) {
        this.temporalSemantics = temporalSemantics;
    }

    public String toString() {
        return "\nFaceGeneralHeader [GeneralHeaderRecordLength=" + this.getRecordLength() + ", formatIdentifier=" + this.formatIdentifier + ", versionNumber=" + this.versionNumber + ", totalRepresentationLength=" + this.totalRepresentationLength + ", noOfRepresentations=" + this.noOfRepresentations + ", certificationFlag=" + this.certificationFlag + ", temporalSemantics=" + this.temporalSemantics + "]\n";
    }
}

