/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.face;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.face.CrossReference;
import io.mosip.biometrics.util.face.FaceImageType;
import io.mosip.biometrics.util.face.ImageColourSpace;
import io.mosip.biometrics.util.face.ImageDataType;
import io.mosip.biometrics.util.face.PostAcquisitionProcessing;
import io.mosip.biometrics.util.face.SpatialSamplingRateLevel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageInformation
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageInformation.class);
    private FaceImageType faceImageType;
    private ImageDataType imageDataType;
    private int width;
    private int height;
    private SpatialSamplingRateLevel spatialSamplingRateLevel;
    private PostAcquisitionProcessing postAcquistionProcessing;
    private CrossReference crossReference;
    private ImageColourSpace imageColorSpace;

    public ImageInformation(int width, int height) {
        this.setFaceImageType(FaceImageType.BASIC);
        this.setImageDataType(ImageDataType.JPEG2000_LOSS_LESS);
        this.setWidth(width);
        this.setHeight(height);
        this.setSpatialSamplingRateLevel(SpatialSamplingRateLevel.SPATIAL_SAMPLING_RATE_LEVEL_180);
        this.setPostAcquistionProcessing(PostAcquisitionProcessing.CROPPED);
        this.setCrossReference(CrossReference.BASIC);
        this.setImageColorSpace(ImageColourSpace.UNSPECIFIED);
    }

    public ImageInformation(FaceImageType faceImageType, ImageDataType imageDataType, int width, int height, SpatialSamplingRateLevel spatialSamplingRateLevel, PostAcquisitionProcessing postAcquistionProcessing, CrossReference crossReference, ImageColourSpace imageColorSpace) {
        this.setFaceImageType(faceImageType);
        this.setImageDataType(imageDataType);
        this.setWidth(width);
        this.setHeight(height);
        this.setSpatialSamplingRateLevel(spatialSamplingRateLevel);
        this.setPostAcquistionProcessing(postAcquistionProcessing);
        this.setCrossReference(crossReference);
        this.setImageColorSpace(imageColorSpace);
    }

    public ImageInformation(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setFaceImageType(FaceImageType.fromValue(inputStream.readUnsignedByte()));
        this.setImageDataType(ImageDataType.fromValue(inputStream.readUnsignedByte()));
        this.setWidth(inputStream.readUnsignedShort());
        this.setHeight(inputStream.readUnsignedShort());
        this.setSpatialSamplingRateLevel(SpatialSamplingRateLevel.fromValue(inputStream.readUnsignedByte()));
        this.setPostAcquistionProcessing(PostAcquisitionProcessing.fromValue(inputStream.readUnsignedShort()));
        this.setCrossReference(CrossReference.fromValue(inputStream.readUnsignedByte()));
        this.setImageColorSpace(ImageColourSpace.fromValue(inputStream.readUnsignedByte()));
    }

    @Override
    public int getRecordLength() {
        return 11;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeByte(this.getFaceImageType().value());
        outputStream.writeByte(this.getImageDataType().value());
        outputStream.writeShort(this.getWidth());
        outputStream.writeShort(this.getHeight());
        outputStream.writeByte(this.getSpatialSamplingRateLevel().value());
        outputStream.writeShort(this.getPostAcquistionProcessing().value());
        outputStream.writeByte(this.getCrossReference().value());
        outputStream.writeByte(this.getImageColorSpace().value());
        outputStream.flush();
    }

    public FaceImageType getFaceImageType() {
        return this.faceImageType;
    }

    public void setFaceImageType(FaceImageType faceImageType) {
        this.faceImageType = faceImageType;
    }

    public ImageDataType getImageDataType() {
        return this.imageDataType;
    }

    public void setImageDataType(ImageDataType imageDataType) {
        this.imageDataType = imageDataType;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public SpatialSamplingRateLevel getSpatialSamplingRateLevel() {
        return this.spatialSamplingRateLevel;
    }

    public void setSpatialSamplingRateLevel(SpatialSamplingRateLevel spatialSamplingRateLevel) {
        this.spatialSamplingRateLevel = spatialSamplingRateLevel;
    }

    public PostAcquisitionProcessing getPostAcquistionProcessing() {
        return this.postAcquistionProcessing;
    }

    public void setPostAcquistionProcessing(PostAcquisitionProcessing postAcquistionProcessing) {
        this.postAcquistionProcessing = postAcquistionProcessing;
    }

    public CrossReference getCrossReference() {
        return this.crossReference;
    }

    public void setCrossReference(CrossReference crossReference) {
        this.crossReference = crossReference;
    }

    public ImageColourSpace getImageColorSpace() {
        return this.imageColorSpace;
    }

    public void setImageColorSpace(ImageColourSpace imageColorSpace) {
        this.imageColorSpace = imageColorSpace;
    }

    public String toString() {
        return "\nImageInformation [ImageInformationRecordLength=" + this.getRecordLength() + ", faceImageType=" + this.faceImageType + ", imageDataType=" + this.imageDataType + ", width=" + this.width + ", height=" + this.height + ", spatialSamplingRateLevel=" + this.spatialSamplingRateLevel + ", postAcquistionProcessing=" + this.postAcquistionProcessing + ", crossReference=" + this.crossReference + ", imageColorSpace=" + this.imageColorSpace + "]\n";
    }
}

