/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.face;

import io.mosip.biometrics.util.AbstractImageInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LandmarkPoints
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(LandmarkPoints.class);
    private byte landmarkPointType;
    private byte landmarkPointCode;
    private short xCoordinate;
    private short yCoordinate;
    private short zCoordinate;

    public LandmarkPoints(byte landmarkPointType, byte landmarkPointCode, short xCoordinate, short yCoordinate, short zCoordinate) {
        this.setLandmarkPointType(landmarkPointType);
        this.setLandmarkPointCode(landmarkPointCode);
        this.setxCoordinate(xCoordinate);
        this.setyCoordinate(yCoordinate);
        this.setzCoordinate(zCoordinate);
    }

    public LandmarkPoints(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setLandmarkPointType((byte)inputStream.readUnsignedByte());
        this.setLandmarkPointCode((byte)inputStream.readUnsignedByte());
        this.setxCoordinate((short)inputStream.readUnsignedShort());
        this.setyCoordinate((short)inputStream.readUnsignedShort());
        this.setzCoordinate((short)inputStream.readUnsignedShort());
    }

    @Override
    public int getRecordLength() {
        return 8;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeByte(this.getLandmarkPointType());
        outputStream.writeByte(this.getLandmarkPointCode());
        outputStream.writeShort(this.getxCoordinate());
        outputStream.writeShort(this.getyCoordinate());
        outputStream.writeShort(this.getzCoordinate());
        outputStream.flush();
    }

    public byte getLandmarkPointType() {
        return this.landmarkPointType;
    }

    public void setLandmarkPointType(byte landmarkPointType) {
        this.landmarkPointType = landmarkPointType;
    }

    public byte getLandmarkPointCode() {
        return this.landmarkPointCode;
    }

    public void setLandmarkPointCode(byte landmarkPointCode) {
        this.landmarkPointCode = landmarkPointCode;
    }

    public short getxCoordinate() {
        return this.xCoordinate;
    }

    public void setxCoordinate(short xCoordinate) {
        this.xCoordinate = xCoordinate;
    }

    public short getyCoordinate() {
        return this.yCoordinate;
    }

    public void setyCoordinate(short yCoordinate) {
        this.yCoordinate = yCoordinate;
    }

    public short getzCoordinate() {
        return this.zCoordinate;
    }

    public void setzCoordinate(short zCoordinate) {
        this.zCoordinate = zCoordinate;
    }

    public String toString() {
        return "\nLandmarkPoints [LandmarkPointRecordLength=" + this.getRecordLength() + ", landmarkPointType=" + this.landmarkPointType + ", landmarkPointCode=" + this.landmarkPointCode + ", xCoordinate=" + this.xCoordinate + ", yCoordinate=" + this.yCoordinate + ", zCoordinate=" + this.zCoordinate + "]\n";
    }
}

