/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.face;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.face.FaceCaptureDeviceTechnology;
import io.mosip.biometrics.util.face.FaceCaptureDeviceType;
import io.mosip.biometrics.util.face.FaceCaptureDeviceVendor;
import io.mosip.biometrics.util.face.FaceQualityBlock;
import io.mosip.biometrics.util.face.FacialInformation;
import io.mosip.biometrics.util.face.ImageData;
import io.mosip.biometrics.util.face.ImageInformation;
import io.mosip.biometrics.util.face.LandmarkPoints;
import io.mosip.biometrics.util.face.RepresentationData;
import io.mosip.biometrics.util.face.RepresentationHeader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class Representation
extends AbstractImageInfo {
    private RepresentationHeader representationHeader;
    private RepresentationData representationData;

    public Representation(Date captureDate, FaceQualityBlock[] qualityBlocks, FacialInformation facialInformation, LandmarkPoints[] landmarkPoints, ImageInformation imageInformation, byte[] image) {
        this.setRepresentationData(new RepresentationData(new ImageData(image)));
        this.setRepresentationHeader(new RepresentationHeader(this.getRepresentationData().getRecordLength(), captureDate, qualityBlocks, facialInformation, landmarkPoints, imageInformation));
    }

    public Representation(Date captureDate, FaceCaptureDeviceTechnology sourceType, FaceCaptureDeviceVendor deviceVendor, FaceCaptureDeviceType deviceType, FaceQualityBlock[] qualityBlocks, FacialInformation facialInformation, LandmarkPoints[] landmarkPoints, ImageInformation imageInformation, byte[] image) {
        this.setRepresentationData(new RepresentationData(new ImageData(image)));
        this.setRepresentationHeader(new RepresentationHeader(this.getRepresentationData().getRecordLength(), captureDate, sourceType, deviceVendor, deviceType, qualityBlocks, facialInformation, landmarkPoints, imageInformation));
    }

    public Representation(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setRepresentationHeader(new RepresentationHeader(inputStream));
        this.setRepresentationData(new RepresentationData(inputStream));
    }

    @Override
    public int getRecordLength() {
        return this.getRepresentationHeader().getRecordLength() + this.getRepresentationData().getRecordLength();
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        this.getRepresentationHeader().writeObject(outputStream);
        this.getRepresentationData().writeObject(outputStream);
        outputStream.flush();
    }

    public RepresentationHeader getRepresentationHeader() {
        return this.representationHeader;
    }

    public void setRepresentationHeader(RepresentationHeader representationHeader) {
        this.representationHeader = representationHeader;
    }

    public RepresentationData getRepresentationData() {
        return this.representationData;
    }

    public void setRepresentationData(RepresentationData representationData) {
        this.representationData = representationData;
    }

    public String toString() {
        return "\nRepresentation [RepresentationRecordLength=" + this.getRecordLength() + ", representationHeader=" + this.representationHeader + ", representationData=" + this.representationData + "]\n";
    }
}

