/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.face;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.face.FaceCaptureDeviceTechnology;
import io.mosip.biometrics.util.face.FaceCaptureDeviceType;
import io.mosip.biometrics.util.face.FaceCaptureDeviceVendor;
import io.mosip.biometrics.util.face.FaceQualityBlock;
import io.mosip.biometrics.util.face.FacialInformation;
import io.mosip.biometrics.util.face.ImageInformation;
import io.mosip.biometrics.util.face.LandmarkPoints;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepresentationHeader
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepresentationHeader.class);
    private int representationDataLength;
    private int representationLength;
    private Date captureDateTime;
    private int captureYear;
    private int captureMonth;
    private int captureDay;
    private int captureHour;
    private int captureMinute;
    private int captureSecond;
    private int captureMilliSecond;
    private FaceCaptureDeviceTechnology captureDeviceTechnologyIdentifier;
    private FaceCaptureDeviceVendor captureDeviceVendorIdentifier;
    private FaceCaptureDeviceType captureDeviceTypeIdentifier;
    private int noOfQualityBlocks;
    private FaceQualityBlock[] qualityBlocks;
    private FacialInformation facialInformation;
    private LandmarkPoints[] landmarkPoints;
    private ImageInformation imageInformation;

    public RepresentationHeader(int representationDataLength, Date captureDate, FaceQualityBlock[] qualityBlocks, FacialInformation facialInformation, LandmarkPoints[] landmarkPoints, ImageInformation imageInformation) {
        this.setRepresentationDataLength(representationDataLength);
        this.setCaptureDateTime(captureDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(captureDate);
        this.setCaptureYear(calendar.get(1));
        this.setCaptureMonth(calendar.get(2));
        this.setCaptureDay(calendar.get(5));
        this.setCaptureHour(calendar.get(11));
        this.setCaptureMinute(calendar.get(12));
        this.setCaptureSecond(calendar.get(13));
        this.setCaptureMilliSecond(calendar.get(14));
        this.setCaptureDeviceTechnologyIdentifier(FaceCaptureDeviceTechnology.UNSPECIFIED);
        this.setCaptureDeviceVendorIdentifier(FaceCaptureDeviceVendor.UNSPECIFIED);
        this.setCaptureDeviceTypeIdentifier(FaceCaptureDeviceType.UNSPECIFIED);
        this.setNoOfQualityBlocks(qualityBlocks.length);
        this.setQualityBlocks(qualityBlocks);
        this.setFacialInformation(facialInformation);
        this.setLandmarkPoints(landmarkPoints);
        this.setImageInformation(imageInformation);
    }

    public RepresentationHeader(int representationDataLength, Date captureDate, FaceCaptureDeviceTechnology captureDeviceTechnologyIdentifier, FaceCaptureDeviceVendor captureDeviceVendorIdentifier, FaceCaptureDeviceType captureDeviceTypeIdentifier, FaceQualityBlock[] qualityBlocks, FacialInformation facialInformation, LandmarkPoints[] landmarkPoints, ImageInformation imageInformation) {
        this.setRepresentationDataLength(representationDataLength);
        this.setCaptureDateTime(captureDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(captureDate);
        this.setCaptureYear(calendar.get(1));
        this.setCaptureMonth(calendar.get(2));
        this.setCaptureDay(calendar.get(5));
        this.setCaptureHour(calendar.get(11));
        this.setCaptureMinute(calendar.get(12));
        this.setCaptureSecond(calendar.get(13));
        this.setCaptureMilliSecond(calendar.get(14));
        this.setCaptureDeviceTechnologyIdentifier(captureDeviceTechnologyIdentifier);
        this.setCaptureDeviceVendorIdentifier(captureDeviceVendorIdentifier);
        this.setCaptureDeviceTypeIdentifier(captureDeviceTypeIdentifier);
        this.setNoOfQualityBlocks(qualityBlocks.length);
        this.setQualityBlocks(qualityBlocks);
        this.setFacialInformation(facialInformation);
        this.setLandmarkPoints(landmarkPoints);
        this.setImageInformation(imageInformation);
    }

    public RepresentationHeader(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setRepresentationDataLength((int)((long)inputStream.readInt() & 0xFFFFFFFFL));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        this.setCaptureYear(inputStream.readUnsignedShort());
        this.setCaptureMonth(inputStream.readUnsignedByte());
        this.setCaptureDay(inputStream.readUnsignedByte());
        this.setCaptureHour(inputStream.readUnsignedByte());
        this.setCaptureMinute(inputStream.readUnsignedByte());
        this.setCaptureSecond(inputStream.readUnsignedByte());
        this.setCaptureMilliSecond(inputStream.readUnsignedShort());
        calendar.set(1, this.getCaptureYear());
        calendar.set(2, this.getCaptureMonth() - 1);
        calendar.set(5, this.getCaptureDay());
        calendar.set(11, this.getCaptureHour());
        calendar.set(12, this.getCaptureMinute());
        calendar.set(13, this.getCaptureSecond());
        calendar.set(14, this.getCaptureMilliSecond());
        this.setCaptureDateTime(calendar.getTime());
        this.setCaptureDeviceTechnologyIdentifier(FaceCaptureDeviceTechnology.fromValue(inputStream.readUnsignedByte()));
        this.setCaptureDeviceVendorIdentifier(FaceCaptureDeviceVendor.fromValue(inputStream.readUnsignedShort()));
        this.setCaptureDeviceTypeIdentifier(FaceCaptureDeviceType.fromValue(inputStream.readUnsignedShort()));
        this.setNoOfQualityBlocks(inputStream.readUnsignedByte());
        FaceQualityBlock[] qualityBlock = new FaceQualityBlock[this.getNoOfQualityBlocks()];
        for (int index = 0; index < this.getNoOfQualityBlocks(); ++index) {
            qualityBlock[index] = new FaceQualityBlock(inputStream);
        }
        this.setQualityBlocks(qualityBlock);
        this.setFacialInformation(new FacialInformation(inputStream));
        int noOfLandMarkPoints = this.getFacialInformation().getNoOfLandMarkPoints();
        if (noOfLandMarkPoints > 0) {
            LandmarkPoints[] landmarkPoints = new LandmarkPoints[noOfLandMarkPoints];
            for (int index = 0; index < noOfLandMarkPoints; ++index) {
                landmarkPoints[index] = new LandmarkPoints(inputStream);
            }
            this.setLandmarkPoints(landmarkPoints);
        }
        this.setImageInformation(new ImageInformation(inputStream));
    }

    @Override
    public int getRecordLength() {
        int qualityBlockRecordLength = 0;
        if (this.getQualityBlocks() != null && this.getQualityBlocks().length > 0) {
            for (int index = 0; index < this.getQualityBlocks().length; ++index) {
                qualityBlockRecordLength += this.getQualityBlocks()[index].getRecordLength();
            }
        }
        int landMarkRecordLength = 0;
        if (this.getLandmarkPoints() != null && this.getLandmarkPoints().length > 0) {
            for (int index = 0; index < this.getLandmarkPoints().length; ++index) {
                landMarkRecordLength += this.getLandmarkPoints()[index].getRecordLength();
            }
        }
        return 19 + qualityBlockRecordLength + 17 + landMarkRecordLength + 11;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        int index;
        outputStream.writeInt(this.getRecordLength() + this.getRepresentationDataLength());
        outputStream.writeShort(this.getCaptureYear());
        outputStream.writeByte(this.getCaptureMonth() + 1);
        outputStream.writeByte(this.getCaptureDay());
        outputStream.writeByte(this.getCaptureHour());
        outputStream.writeByte(this.getCaptureMinute());
        outputStream.writeByte(this.getCaptureSecond());
        outputStream.writeShort(this.getCaptureMilliSecond());
        outputStream.writeByte(this.getCaptureDeviceTechnologyIdentifier().value());
        outputStream.writeShort(this.getCaptureDeviceVendorIdentifier().value());
        outputStream.writeShort(this.getCaptureDeviceTypeIdentifier().value());
        outputStream.writeByte(this.getNoOfQualityBlocks());
        if (this.getQualityBlocks() != null) {
            for (index = 0; index < this.getQualityBlocks().length; ++index) {
                this.getQualityBlocks()[index].writeObject(outputStream);
            }
        }
        this.getFacialInformation().writeObject(outputStream);
        if (this.getLandmarkPoints() != null) {
            for (index = 0; index < this.getLandmarkPoints().length; ++index) {
                this.getLandmarkPoints()[index].writeObject(outputStream);
            }
        }
        this.getImageInformation().writeObject(outputStream);
        outputStream.flush();
    }

    public int getRepresentationDataLength() {
        return this.representationDataLength;
    }

    public void setRepresentationDataLength(int representationDataLength) {
        this.representationDataLength = representationDataLength;
    }

    public int getRepresentationLength() {
        return this.representationLength;
    }

    public void setRepresentationLength(int representationLength) {
        this.representationLength = representationLength;
    }

    public Date getCaptureDateTime() {
        return this.captureDateTime;
    }

    public void setCaptureDateTime(Date captureDateTime) {
        this.captureDateTime = captureDateTime;
    }

    public int getCaptureYear() {
        return this.captureYear;
    }

    public void setCaptureYear(int captureYear) {
        this.captureYear = captureYear;
    }

    public int getCaptureMonth() {
        return this.captureMonth;
    }

    public void setCaptureMonth(int captureMonth) {
        this.captureMonth = captureMonth;
    }

    public int getCaptureDay() {
        return this.captureDay;
    }

    public void setCaptureDay(int captureDay) {
        this.captureDay = captureDay;
    }

    public int getCaptureHour() {
        return this.captureHour;
    }

    public void setCaptureHour(int captureHour) {
        this.captureHour = captureHour;
    }

    public int getCaptureMinute() {
        return this.captureMinute;
    }

    public void setCaptureMinute(int captureMinute) {
        this.captureMinute = captureMinute;
    }

    public int getCaptureSecond() {
        return this.captureSecond;
    }

    public void setCaptureSecond(int captureSecond) {
        this.captureSecond = captureSecond;
    }

    public int getCaptureMilliSecond() {
        return this.captureMilliSecond;
    }

    public void setCaptureMilliSecond(int captureMilliSecond) {
        this.captureMilliSecond = captureMilliSecond;
    }

    public FaceCaptureDeviceTechnology getCaptureDeviceTechnologyIdentifier() {
        return this.captureDeviceTechnologyIdentifier;
    }

    public void setCaptureDeviceTechnologyIdentifier(FaceCaptureDeviceTechnology captureDeviceTechnologyIdentifier) {
        this.captureDeviceTechnologyIdentifier = captureDeviceTechnologyIdentifier;
    }

    public FaceCaptureDeviceVendor getCaptureDeviceVendorIdentifier() {
        return this.captureDeviceVendorIdentifier;
    }

    public void setCaptureDeviceVendorIdentifier(FaceCaptureDeviceVendor captureDeviceVendorIdentifier) {
        this.captureDeviceVendorIdentifier = captureDeviceVendorIdentifier;
    }

    public FaceCaptureDeviceType getCaptureDeviceTypeIdentifier() {
        return this.captureDeviceTypeIdentifier;
    }

    public void setCaptureDeviceTypeIdentifier(FaceCaptureDeviceType captureDeviceTypeIdentifier) {
        this.captureDeviceTypeIdentifier = captureDeviceTypeIdentifier;
    }

    public int getNoOfQualityBlocks() {
        return this.noOfQualityBlocks;
    }

    public void setNoOfQualityBlocks(int noOfQualityBlocks) {
        this.noOfQualityBlocks = noOfQualityBlocks;
    }

    public FaceQualityBlock[] getQualityBlocks() {
        return this.qualityBlocks;
    }

    public void setQualityBlocks(FaceQualityBlock[] qualityBlocks) {
        this.qualityBlocks = qualityBlocks;
    }

    public FacialInformation getFacialInformation() {
        return this.facialInformation;
    }

    public void setFacialInformation(FacialInformation facialInformation) {
        this.facialInformation = facialInformation;
    }

    public LandmarkPoints[] getLandmarkPoints() {
        return this.landmarkPoints;
    }

    public void setLandmarkPoints(LandmarkPoints[] landmarkPoints) {
        this.landmarkPoints = landmarkPoints;
    }

    public ImageInformation getImageInformation() {
        return this.imageInformation;
    }

    public void setImageInformation(ImageInformation imageInformation) {
        this.imageInformation = imageInformation;
    }

    public String toString() {
        return "\nRepresentationHeader [RepresentationHeaderLength=" + this.getRecordLength() + ", representationDataLength=" + this.representationDataLength + ", representationLength=" + this.representationLength + ", captureDateTime=" + this.captureDateTime + ", captureYear=" + this.captureYear + ", captureMonth=" + this.captureMonth + ", captureDay=" + this.captureDay + ", captureHour=" + this.captureHour + ", captureMinute=" + this.captureMinute + ", captureSecond=" + this.captureSecond + ", captureMilliSecond=" + this.captureMilliSecond + ", captureDeviceTechnologyIdentifier=" + this.captureDeviceTechnologyIdentifier + ", captureDeviceVendorIdentifier=" + this.captureDeviceVendorIdentifier + ", captureDeviceTypeIdentifier=" + this.captureDeviceTypeIdentifier + ", noOfQualityBlocks=" + this.noOfQualityBlocks + ", qualityBlocks=" + Arrays.toString(this.qualityBlocks) + ", facialInformation=" + this.facialInformation + ", landmarkPoints=" + Arrays.toString(this.landmarkPoints) + ", imageInformation=" + this.imageInformation + "]\n";
    }
}

