/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.finger.AnnotationData;
import io.mosip.biometrics.util.finger.ExtendedDataBlock;
import io.mosip.biometrics.util.finger.ExtendedDataBlockIdentificationCode;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationBlock
extends ExtendedDataBlock {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationBlock.class);
    private int noOfAnnotationData;
    private AnnotationData[] annotationData;

    public AnnotationBlock(int noOfAnnotationData, AnnotationData[] annotationData) {
        this.setNoOfAnnotationData(noOfAnnotationData);
        this.setAnnotationData(annotationData);
        this.setExtendedDataBlockIdentificationCode(ExtendedDataBlockIdentificationCode.ANNOTATION);
        this.setLengthOfExtendedDataBlock(this.getRecordLength());
    }

    public AnnotationBlock(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setLengthOfExtendedDataBlock(inputStream.readUnsignedShort());
        this.setNoOfAnnotationData(inputStream.readUnsignedByte());
        if (this.getNoOfAnnotationData() > 0) {
            AnnotationData[] annotationData = new AnnotationData[this.getNoOfAnnotationData()];
            for (int index = 0; index < this.getNoOfAnnotationData(); ++index) {
                annotationData[index] = new AnnotationData(inputStream);
            }
            this.setAnnotationData(annotationData);
        }
    }

    @Override
    public int getRecordLength() {
        int recordLength = 0;
        if (this.getNoOfAnnotationData() > 0) {
            for (int index = 0; index < this.getNoOfAnnotationData(); ++index) {
                recordLength += this.getAnnotationData()[index].getRecordLength();
            }
        }
        return 5 + recordLength;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeShort(this.getExtendedDataBlockIdentificationCode().value());
        outputStream.writeShort(this.getLengthOfExtendedDataBlock());
        outputStream.writeByte(this.getNoOfAnnotationData());
        if (this.getNoOfAnnotationData() > 0) {
            for (int index = 0; index < this.getNoOfAnnotationData(); ++index) {
                this.getAnnotationData()[index].writeObject(outputStream);
            }
        }
        outputStream.flush();
    }

    public int getNoOfAnnotationData() {
        return this.noOfAnnotationData;
    }

    public void setNoOfAnnotationData(int noOfAnnotationData) {
        this.noOfAnnotationData = noOfAnnotationData;
    }

    public AnnotationData[] getAnnotationData() {
        return this.annotationData;
    }

    public void setAnnotationData(AnnotationData[] annotationData) {
        this.annotationData = annotationData;
    }

    @Override
    public String toString() {
        super.toString();
        return "\nAnnotationBlock [RecordLength=" + this.getRecordLength() + ", noOfAnnotationData=" + this.noOfAnnotationData + ", annotationData=" + Arrays.toString(this.annotationData) + "]\n";
    }
}

