/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.finger.AnnotationCode;
import io.mosip.biometrics.util.finger.FingerPosition;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationData
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationData.class);
    private FingerPosition fingerPosition;
    private AnnotationCode annotationCode;

    public AnnotationData() {
        this.setFingerPosition(FingerPosition.UNKNOWN);
        this.setAnnotationCode(AnnotationCode.AMPUTATED_FINGER);
    }

    public AnnotationData(FingerPosition fingerPosition, AnnotationCode annotationCode) {
        this.setFingerPosition(fingerPosition);
        this.setAnnotationCode(annotationCode);
    }

    public AnnotationData(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setFingerPosition(FingerPosition.fromValue(inputStream.readUnsignedByte()));
        this.setAnnotationCode(AnnotationCode.fromValue(inputStream.readUnsignedByte()));
    }

    @Override
    public int getRecordLength() {
        return 2;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeByte(this.getFingerPosition().value());
        outputStream.writeByte(this.getAnnotationCode().value());
        outputStream.flush();
    }

    public FingerPosition getFingerPosition() {
        return this.fingerPosition;
    }

    public void setFingerPosition(FingerPosition fingerPosition) {
        this.fingerPosition = fingerPosition;
    }

    public AnnotationCode getAnnotationCode() {
        return this.annotationCode;
    }

    public void setAnnotationCode(AnnotationCode annotationCode) {
        this.annotationCode = annotationCode;
    }

    public String toString() {
        return "\nAnnotationData [RecordLength=" + this.getRecordLength() + ", fingerPosition=" + this.fingerPosition + ", annotationCode=" + this.annotationCode + "]\n";
    }
}

