/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.finger.ExtendedDataBlock;
import io.mosip.biometrics.util.finger.ExtendedDataBlockIdentificationCode;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentBlock
extends ExtendedDataBlock {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommentBlock.class);
    private byte[] comment;

    public CommentBlock(byte[] comment) {
        this.setComment(comment);
        this.setExtendedDataBlockIdentificationCode(ExtendedDataBlockIdentificationCode.COMMENT_03);
        this.setLengthOfExtendedDataBlock(this.getRecordLength());
    }

    public CommentBlock(byte[] comment, ExtendedDataBlockIdentificationCode extendedDataBlockIdentificationCode) {
        this.setComment(comment);
        this.setExtendedDataBlockIdentificationCode(extendedDataBlockIdentificationCode);
        this.setLengthOfExtendedDataBlock(this.getRecordLength());
    }

    public CommentBlock(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setLengthOfExtendedDataBlock(inputStream.readUnsignedShort());
        this.setComment(new byte[this.getLengthOfExtendedDataBlock() - 4]);
        inputStream.readFully(this.getComment());
    }

    @Override
    public int getRecordLength() {
        return 4 + (this.getComment() != null && this.getComment().length > 0 ? this.getComment().length : 0);
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeShort(this.getExtendedDataBlockIdentificationCode().value());
        outputStream.writeShort(this.getLengthOfExtendedDataBlock());
        if (this.getComment() != null && this.getComment().length > 0) {
            outputStream.write(this.getComment(), 0, this.getComment().length);
        }
        outputStream.flush();
    }

    public byte[] getComment() {
        return this.comment;
    }

    public void setComment(byte[] comment) {
        this.comment = comment;
    }

    @Override
    public String toString() {
        super.toString();
        return "\nCommentBlock [RecordLength=" + this.getRecordLength() + ", CommentLength=" + this.getComment().length + ", Comment=" + (this.getComment() != null && this.getComment().length > 0 ? new String(this.getComment()) : "") + "]\n";
    }
}

