/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.finger.AnnotationBlock;
import io.mosip.biometrics.util.finger.CommentBlock;
import io.mosip.biometrics.util.finger.FingerCaptureDeviceTechnology;
import io.mosip.biometrics.util.finger.FingerCaptureDeviceType;
import io.mosip.biometrics.util.finger.FingerCaptureDeviceVendor;
import io.mosip.biometrics.util.finger.FingerCertificationBlock;
import io.mosip.biometrics.util.finger.FingerCertificationFlag;
import io.mosip.biometrics.util.finger.FingerFormatIdentifier;
import io.mosip.biometrics.util.finger.FingerImageBitDepth;
import io.mosip.biometrics.util.finger.FingerImageCompressionType;
import io.mosip.biometrics.util.finger.FingerImpressionType;
import io.mosip.biometrics.util.finger.FingerPosition;
import io.mosip.biometrics.util.finger.FingerQualityBlock;
import io.mosip.biometrics.util.finger.FingerScaleUnitType;
import io.mosip.biometrics.util.finger.FingerVersionNumber;
import io.mosip.biometrics.util.finger.GeneralHeader;
import io.mosip.biometrics.util.finger.Representation;
import io.mosip.biometrics.util.finger.SegmentationBlock;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class FingerBDIR
extends AbstractImageInfo {
    private GeneralHeader generalHeader;
    private Representation representation;

    public FingerBDIR(FingerFormatIdentifier formatIdentifier, FingerVersionNumber versionNumber, FingerCertificationFlag certificationFlag, Date captureDate, int noOfRepresentations, FingerQualityBlock[] qualityBlocks, FingerCertificationBlock[] certificationBlocks, FingerPosition fingerPosition, int representationNo, FingerScaleUnitType scaleUnitType, int noOfFingerPresent, byte[] image) {
        this.setRepresentation(new Representation(captureDate, qualityBlocks, certificationFlag, certificationBlocks, fingerPosition, representationNo, scaleUnitType, image));
        int totalRepresentationLength = this.getRepresentation().getRecordLength();
        this.setGeneralHeader(new GeneralHeader(formatIdentifier, versionNumber, totalRepresentationLength, noOfRepresentations, certificationFlag, noOfFingerPresent));
    }

    public FingerBDIR(FingerFormatIdentifier formatIdentifier, FingerVersionNumber versionNumber, FingerCertificationFlag certificationFlag, FingerCaptureDeviceTechnology sourceType, FingerCaptureDeviceVendor deviceVendor, FingerCaptureDeviceType deviceType, Date captureDate, int noOfRepresentations, FingerQualityBlock[] qualityBlocks, FingerCertificationBlock[] certificationBlocks, FingerPosition fingerPosition, int representationNo, FingerScaleUnitType scaleUnitType, int captureDeviceSpatialSamplingRateHorizontal, int captureDeviceSpatialSamplingRateVertical, int imageSpatialSamplingRateHorizontal, int imageSpatialSamplingRateVertical, FingerImageBitDepth bitDepth, FingerImageCompressionType compressionType, FingerImpressionType impressionType, int lineLengthHorizontal, int lineLengthVertical, int noOfFingerPresent, byte[] image, SegmentationBlock segmentationBlock, AnnotationBlock annotationBlock, CommentBlock commentBlock) {
        this.setRepresentation(new Representation(captureDate, sourceType, deviceVendor, deviceType, qualityBlocks, certificationFlag, certificationBlocks, fingerPosition, representationNo, scaleUnitType, captureDeviceSpatialSamplingRateHorizontal, captureDeviceSpatialSamplingRateVertical, imageSpatialSamplingRateHorizontal, imageSpatialSamplingRateVertical, bitDepth, compressionType, impressionType, lineLengthHorizontal, lineLengthVertical, image, segmentationBlock, annotationBlock, commentBlock));
        int totalRepresentationLength = this.getRepresentation().getRecordLength();
        this.setGeneralHeader(new GeneralHeader(formatIdentifier, versionNumber, totalRepresentationLength, noOfRepresentations, certificationFlag, noOfFingerPresent));
    }

    public FingerBDIR(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    public int getRecordLength() {
        return this.getGeneralHeader().getRecordLength() + 1 * this.getRepresentation().getRecordLength();
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setGeneralHeader(new GeneralHeader(inputStream));
        int generalHeaderLength = this.getGeneralHeader().getRecordLength();
        int noOfRepresentations = this.getGeneralHeader().getNoOfRepresentations();
        int totalRepresentationLength = this.getGeneralHeader().getTotalRepresentationLength();
        if (noOfRepresentations == 1) {
            this.setRepresentation(new Representation(inputStream, this.getGeneralHeader().getCertificationFlag()));
        }
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        this.getGeneralHeader().writeObject(outputStream);
        this.getRepresentation().writeObject(outputStream);
        outputStream.flush();
    }

    public GeneralHeader getGeneralHeader() {
        return this.generalHeader;
    }

    public void setGeneralHeader(GeneralHeader generalHeader) {
        this.generalHeader = generalHeader;
    }

    public Representation getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(Representation representation) {
        this.representation = representation;
    }

    public String toString() {
        return "\nFingerBDIR [generalHeader=" + this.generalHeader + ", representation=" + this.representation + "]\n";
    }
}

