/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.finger.FingerCertificationAuthorityID;
import io.mosip.biometrics.util.finger.FingerCertificationSchemeIdentifier;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FingerCertificationBlock
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(FingerCertificationBlock.class);
    private FingerCertificationAuthorityID certificationAuthorityID;
    private FingerCertificationSchemeIdentifier certificationSchemeIdentifier;

    public FingerCertificationBlock() {
        this.setCertificationAuthorityID(FingerCertificationAuthorityID.UNSPECIFIED);
        this.setCertificationSchemeIdentifier(FingerCertificationSchemeIdentifier.UNSPECIFIED);
    }

    public FingerCertificationBlock(FingerCertificationAuthorityID certificationAuthorityID, FingerCertificationSchemeIdentifier certificationSchemeIdentifier) {
        this.setCertificationAuthorityID(certificationAuthorityID);
        this.setCertificationSchemeIdentifier(certificationSchemeIdentifier);
    }

    public FingerCertificationBlock(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        int certificationAuthorityID = inputStream.readUnsignedShort();
        try {
            this.setCertificationAuthorityID(FingerCertificationAuthorityID.fromValue(certificationAuthorityID));
        }
        catch (Exception ex) {
            LOGGER.error("setCertificationAuthorityID :: Not Defined :: certificationAuthorityID :: " + Integer.toHexString(certificationAuthorityID));
        }
        int certificationSchemeIdentifier = inputStream.readUnsignedByte();
        try {
            this.setCertificationSchemeIdentifier(FingerCertificationSchemeIdentifier.fromValue(certificationSchemeIdentifier));
        }
        catch (Exception ex) {
            LOGGER.error("setCertificationSchemeIdentifier :: Not Defined :: certificationSchemeIdentifier :: " + Integer.toHexString(certificationSchemeIdentifier));
        }
    }

    @Override
    public int getRecordLength() {
        return 3;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeShort(this.getCertificationAuthorityID().value());
        outputStream.writeByte(this.getCertificationSchemeIdentifier().value());
        outputStream.flush();
    }

    public FingerCertificationAuthorityID getCertificationAuthorityID() {
        return this.certificationAuthorityID;
    }

    public void setCertificationAuthorityID(FingerCertificationAuthorityID certificationAuthorityID) {
        this.certificationAuthorityID = certificationAuthorityID;
    }

    public FingerCertificationSchemeIdentifier getCertificationSchemeIdentifier() {
        return this.certificationSchemeIdentifier;
    }

    public void setCertificationSchemeIdentifier(FingerCertificationSchemeIdentifier certificationSchemeIdentifier) {
        this.certificationSchemeIdentifier = certificationSchemeIdentifier;
    }

    public String toString() {
        return "\nFingerCertificationBlock [RecordLength=" + this.getRecordLength() + ", certificationAuthorityID=" + this.certificationAuthorityID + ", certificationSchemeIdentifier=" + this.certificationSchemeIdentifier + "]\n";
    }
}

