/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.CommonUtil;
import io.mosip.biometrics.util.ConvertRequestDto;
import io.mosip.biometrics.util.finger.FingerBDIR;
import io.mosip.biometrics.util.finger.FingerImageCompressionType;
import io.mosip.biometrics.util.finger.ImageData;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FingerDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FingerDecoder.class);

    private static FingerBDIR getFingerBDIRISO19794_4_2011(byte[] isoData) throws Exception {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(isoData);){
            FingerBDIR fingerBDIR;
            try (DataInputStream inputStream = new DataInputStream(bais);){
                FingerBDIR fingerBDIR2 = new FingerBDIR(inputStream);
                LOGGER.info("fingerBDIR :: ", (Object)fingerBDIR2);
                fingerBDIR = fingerBDIR2;
            }
            return fingerBDIR;
        }
    }

    public static FingerBDIR getFingerBDIR(ConvertRequestDto convertRequestDto) throws Exception {
        switch (convertRequestDto.getVersion()) {
            case "ISO19794_4_2011": {
                return FingerDecoder.getFingerBDIRISO19794_4_2011(convertRequestDto.getInputBytes());
            }
        }
        throw new UnsupportedOperationException();
    }

    public static byte[] convertFingerISOToImageBytes(ConvertRequestDto convertRequestDto) throws Exception {
        switch (convertRequestDto.getVersion()) {
            case "ISO19794_4_2011": {
                FingerBDIR fingerBDIR = FingerDecoder.getFingerBDIRISO19794_4_2011(convertRequestDto.getInputBytes());
                FingerImageCompressionType fingerImageCompressionType = fingerBDIR.getRepresentation().getRepresentationHeader().getCompressionType();
                switch (fingerImageCompressionType) {
                    case JPEG_2000_LOSSY: 
                    case JPEG_2000_LOSS_LESS: {
                        return CommonUtil.convertJP2ToJPEGBytes(fingerBDIR.getRepresentation().getRepresentationBody().getImageData().getImage());
                    }
                }
                return fingerBDIR.getRepresentation().getRepresentationBody().getImageData().getImage();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static BufferedImage convertFingerISOToBufferedImage(ConvertRequestDto convertRequestDto) throws Exception {
        ImageData imageData = null;
        switch (convertRequestDto.getVersion()) {
            case "ISO19794_4_2011": {
                imageData = FingerDecoder.getFingerBDIRISO19794_4_2011(convertRequestDto.getInputBytes()).getRepresentation().getRepresentationBody().getImageData();
                return ImageIO.read(new ByteArrayInputStream(imageData.getImage()));
            }
        }
        throw new UnsupportedOperationException();
    }
}

