/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.CommonUtil;
import io.mosip.biometrics.util.ConvertRequestDto;
import io.mosip.biometrics.util.finger.AnnotationBlock;
import io.mosip.biometrics.util.finger.CommentBlock;
import io.mosip.biometrics.util.finger.FingerBDIR;
import io.mosip.biometrics.util.finger.FingerCaptureDeviceTechnology;
import io.mosip.biometrics.util.finger.FingerCaptureDeviceType;
import io.mosip.biometrics.util.finger.FingerCaptureDeviceVendor;
import io.mosip.biometrics.util.finger.FingerCertificationBlock;
import io.mosip.biometrics.util.finger.FingerCertificationFlag;
import io.mosip.biometrics.util.finger.FingerFormatIdentifier;
import io.mosip.biometrics.util.finger.FingerImageBitDepth;
import io.mosip.biometrics.util.finger.FingerImageCompressionType;
import io.mosip.biometrics.util.finger.FingerImpressionType;
import io.mosip.biometrics.util.finger.FingerPosition;
import io.mosip.biometrics.util.finger.FingerQualityAlgorithmIdentifier;
import io.mosip.biometrics.util.finger.FingerQualityAlgorithmVendorIdentifier;
import io.mosip.biometrics.util.finger.FingerQualityBlock;
import io.mosip.biometrics.util.finger.FingerScaleUnitType;
import io.mosip.biometrics.util.finger.FingerVersionNumber;
import io.mosip.biometrics.util.finger.SegmentationBlock;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FingerEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FingerEncoder.class);

    private static byte[] convertFingerImageToISO19794_4_2011(FingerFormatIdentifier formatIdentifier, FingerVersionNumber versionNumber, FingerCertificationFlag certificationFlag, FingerCaptureDeviceTechnology sourceType, FingerCaptureDeviceVendor deviceVendor, FingerCaptureDeviceType deviceType, Date captureDate, int noOfRepresentations, FingerQualityBlock[] qualityBlocks, FingerCertificationBlock[] certificationBlocks, FingerPosition fingerPosition, int representationNo, FingerScaleUnitType scaleUnitType, int captureDeviceSpatialSamplingRateHorizontal, int captureDeviceSpatialSamplingRateVertical, int imageSpatialSamplingRateHorizontal, int imageSpatialSamplingRateVertical, FingerImageBitDepth bitDepth, FingerImageCompressionType compressionType, FingerImpressionType impressionType, int lineLengthHorizontal, int lineLengthVertical, int noOfFingerPresent, byte[] image, SegmentationBlock segmentationBlock, AnnotationBlock annotationBlock, CommentBlock commentBlock) throws Exception {
        FingerBDIR bdir = new FingerBDIR(formatIdentifier, versionNumber, certificationFlag, sourceType, deviceVendor, deviceType, captureDate, noOfRepresentations, qualityBlocks, certificationBlocks, fingerPosition, representationNo, scaleUnitType, captureDeviceSpatialSamplingRateHorizontal, captureDeviceSpatialSamplingRateVertical, imageSpatialSamplingRateHorizontal, imageSpatialSamplingRateVertical, bitDepth, compressionType, impressionType, lineLengthHorizontal, lineLengthVertical, noOfFingerPresent, image, segmentationBlock, annotationBlock, commentBlock);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream(baos);){
                bdir.writeObject(outputStream);
                outputStream.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public static byte[] convertFingerImageToISO(ConvertRequestDto convertRequestDto) throws Exception {
        switch (convertRequestDto.getVersion()) {
            case "ISO19794_4_2011": {
                FingerFormatIdentifier formatIdentifier = FingerFormatIdentifier.FORMAT_FIR;
                FingerVersionNumber versionNumber = FingerVersionNumber.VERSION_020;
                FingerCertificationFlag certificationFlag = FingerCertificationFlag.UNSPECIFIED;
                FingerCaptureDeviceTechnology sourceType = FingerCaptureDeviceTechnology.UNSPECIFIED;
                FingerCaptureDeviceVendor deviceVendor = FingerCaptureDeviceVendor.UNSPECIFIED;
                FingerCaptureDeviceType deviceType = FingerCaptureDeviceType.UNSPECIFIED;
                Date captureDate = new Date();
                int noOfRepresentations = 1;
                FingerQualityAlgorithmVendorIdentifier algorithmVendorIdentifier = FingerQualityAlgorithmVendorIdentifier.NIST;
                FingerQualityAlgorithmIdentifier qualityAlgorithmIdentifier = FingerQualityAlgorithmIdentifier.NIST;
                int quality = 80;
                FingerQualityBlock[] qualityBlocks = new FingerQualityBlock[]{new FingerQualityBlock((byte)quality, algorithmVendorIdentifier, qualityAlgorithmIdentifier)};
                FingerCertificationBlock[] certificationBlocks = null;
                FingerPosition fingerPosition = FingerEncoder.getFingerPosition(convertRequestDto.getBiometricSubType());
                int representationNo = 0;
                FingerScaleUnitType scaleUnitType = FingerScaleUnitType.PIXELS_PER_INCH;
                int captureDeviceSpatialSamplingRateHorizontal = 500;
                int captureDeviceSpatialSamplingRateVertical = 500;
                int imageSpatialSamplingRateHorizontal = 500;
                int imageSpatialSamplingRateVertical = 500;
                FingerImageBitDepth bitDepth = FingerImageBitDepth.BPP_08;
                FingerImageCompressionType compressionType = convertRequestDto.getImageType() == 0 ? FingerImageCompressionType.JPEG_2000_LOSS_LESS : FingerImageCompressionType.WSQ;
                FingerImpressionType impressionType = FingerImpressionType.UNKNOWN;
                BufferedImage bufferedImage = CommonUtil.getBufferedImage(convertRequestDto);
                int lineLengthHorizontal = bufferedImage.getWidth();
                int lineLengthVertical = bufferedImage.getHeight();
                int noOfFingerPresent = 1;
                SegmentationBlock segmentationBlock = null;
                AnnotationBlock annotationBlock = null;
                CommentBlock commentBlock = null;
                LOGGER.info("imageWidth :: {} :: imageHeight :: {} :: Size :: {}", new Object[]{lineLengthHorizontal, lineLengthVertical, convertRequestDto.getInputBytes().length});
                return FingerEncoder.convertFingerImageToISO19794_4_2011(formatIdentifier, versionNumber, certificationFlag, sourceType, deviceVendor, deviceType, captureDate, noOfRepresentations, qualityBlocks, certificationBlocks, fingerPosition, representationNo, scaleUnitType, captureDeviceSpatialSamplingRateHorizontal, captureDeviceSpatialSamplingRateVertical, imageSpatialSamplingRateHorizontal, imageSpatialSamplingRateVertical, bitDepth, compressionType, impressionType, lineLengthHorizontal, lineLengthVertical, noOfFingerPresent, convertRequestDto.getInputBytes(), segmentationBlock, annotationBlock, commentBlock);
            }
        }
        throw new UnsupportedOperationException();
    }

    private static FingerPosition getFingerPosition(String biometricSubType) {
        if (biometricSubType == null) {
            return FingerPosition.UNKNOWN;
        }
        switch (biometricSubType) {
            case "Right Thumb": {
                return FingerPosition.RIGHT_THUMB;
            }
            case "Right IndexFinger": {
                return FingerPosition.RIGHT_INDEX_FINGER;
            }
            case "Right MiddleFinger": {
                return FingerPosition.RIGHT_MIDDLE_FINGER;
            }
            case "Right RingFinger": {
                return FingerPosition.RIGHT_RING_FINGER;
            }
            case "Right LittleFinger": {
                return FingerPosition.RIGHT_LITTLE_FINGER;
            }
            case "Left Thumb": {
                return FingerPosition.LEFT_THUMB;
            }
            case "Left IndexFinger": {
                return FingerPosition.LEFT_INDEX_FINGER;
            }
            case "Left MiddleFinger": {
                return FingerPosition.LEFT_MIDDLE_FINGER;
            }
            case "Left RingFinger": {
                return FingerPosition.LEFT_RING_FINGER;
            }
            case "Left LittleFinger": {
                return FingerPosition.LEFT_LITTLE_FINGER;
            }
        }
        return FingerPosition.UNKNOWN;
    }
}

