/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

public enum FingerPosition {
    UNKNOWN(0),
    RIGHT_THUMB(1),
    RIGHT_INDEX_FINGER(2),
    RIGHT_MIDDLE_FINGER(3),
    RIGHT_RING_FINGER(4),
    RIGHT_LITTLE_FINGER(5),
    LEFT_THUMB(6),
    LEFT_INDEX_FINGER(7),
    LEFT_MIDDLE_FINGER(8),
    LEFT_RING_FINGER(9),
    LEFT_LITTLE_FINGER(10),
    PLAIN_RIGHT_FOUR_FINGERS(13),
    PLAIN_LEFT_FOUR_FINGERS(14),
    PLAIN_TWO_THUMBS(15),
    UNKNOWN_PALM(20),
    RIGHT_FULL_PALM(21),
    RIGHT_WRITER_S_PALM(22),
    LEFT_FULL_PALM(23),
    LEFT_WRITER_S_PALM(24),
    RIGHT_LOWER_PALM(25),
    RIGHT_UPPER_PALM(26),
    LEFT_LOWER_PALM(27),
    LEFT_UPPER_PALM(28),
    RIGHT_OTHER(29),
    LEFT_OTHER(30),
    RIGHT_INTERDIGITAL(31),
    RIGHT_THENAR(32),
    RIGHT_HYPOTHENAR(33),
    LEFT_INTERDIGITAL(34),
    LEFT_THENAR(35),
    LEFT_HYPOTHENAR(36),
    RIGHT_INDEX_AND_MIDDLE_FINGERS(40),
    RIGHT_MIDDLE_AND_RING_FINGERS(41),
    RIGHT_RING_AND_LITTLE_FINGERS(42),
    LEFT_INDEX_AND_MIDDLE_FINGERS(43),
    LEFT_MIDDLE_AND_RING_FINGERS(44),
    LEFT_RING_AND_LITTLE_FINGERS(45),
    RIGHT_INDEX_AND_LEFT_INDEX_FINGERS(46),
    RIGHT_INDEX_AND_MIDDLE_AND_RING_FINGERS(47),
    RIGHT_MIDDLE_AND_RING_AND_LITTLE_FINGERS(48),
    LEFT_INDEX_AND_MIDDLE_AND_RING_FINGERS(49),
    LEFT_MIDDLE_AND_RING_AND_LITTLE_FINGERS(50);

    private final int value;

    private FingerPosition(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static FingerPosition fromValue(int value) {
        for (FingerPosition c : FingerPosition.values()) {
            if (c.value != value) continue;
            return c;
        }
        throw new IllegalArgumentException("" + value);
    }

    public String toString() {
        return super.toString() + "(" + Integer.toHexString(this.value) + ")";
    }
}

