/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.finger.FingerQualityAlgorithmIdentifier;
import io.mosip.biometrics.util.finger.FingerQualityAlgorithmVendorIdentifier;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FingerQualityBlock
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(FingerQualityBlock.class);
    private int qualityScore;
    private FingerQualityAlgorithmVendorIdentifier qualityAlgorithmVendorIdentifier;
    private FingerQualityAlgorithmIdentifier qualityAlgorithmIdentifier;

    public FingerQualityBlock(int qualityScore) {
        this.setQualityScore(qualityScore);
        this.setQualityAlgorithmVendorIdentifier(FingerQualityAlgorithmVendorIdentifier.ALGORITHM_VENDOR_IDENTIFIER);
        this.setQualityAlgorithmIdentifier(FingerQualityAlgorithmIdentifier.ALGORITHM_IDENTIFIER);
    }

    public FingerQualityBlock(int qualityScore, FingerQualityAlgorithmVendorIdentifier qualityAlgorithmVendorIdentifier, FingerQualityAlgorithmIdentifier qualityAlgorithmIdentifier) {
        this.setQualityScore(qualityScore);
        this.setQualityAlgorithmVendorIdentifier(qualityAlgorithmVendorIdentifier);
        this.setQualityAlgorithmIdentifier(qualityAlgorithmIdentifier);
    }

    public FingerQualityBlock(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setQualityScore(inputStream.readUnsignedByte());
        int qualityAlgorithmVendorIdentifier = inputStream.readUnsignedShort();
        try {
            this.setQualityAlgorithmVendorIdentifier(FingerQualityAlgorithmVendorIdentifier.fromValue(qualityAlgorithmVendorIdentifier));
        }
        catch (Exception ex) {
            LOGGER.error("setQualityAlgorithmVendorIdentifier :: Not Defined :: qualityAlgorithmVendorIdentifier :: " + Integer.toHexString(qualityAlgorithmVendorIdentifier));
        }
        int qualityAlgorithmIdentifier = inputStream.readUnsignedShort();
        try {
            this.setQualityAlgorithmIdentifier(FingerQualityAlgorithmIdentifier.fromValue(qualityAlgorithmIdentifier));
        }
        catch (Exception ex) {
            LOGGER.error("setQualityAlgorithmIdentifier :: Not Defined :: qualityAlgorithmIdentifier :: " + Integer.toHexString(qualityAlgorithmIdentifier));
        }
    }

    @Override
    public int getRecordLength() {
        return 5;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeByte(this.getQualityScore());
        outputStream.writeShort(this.getQualityAlgorithmVendorIdentifier().value());
        outputStream.writeShort(this.getQualityAlgorithmIdentifier().value());
        outputStream.flush();
    }

    public int getQualityScore() {
        return this.qualityScore;
    }

    public void setQualityScore(int qualityScore) {
        this.qualityScore = qualityScore;
    }

    public FingerQualityAlgorithmVendorIdentifier getQualityAlgorithmVendorIdentifier() {
        return this.qualityAlgorithmVendorIdentifier;
    }

    public void setQualityAlgorithmVendorIdentifier(FingerQualityAlgorithmVendorIdentifier qualityAlgorithmVendorIdentifier) {
        this.qualityAlgorithmVendorIdentifier = qualityAlgorithmVendorIdentifier;
    }

    public FingerQualityAlgorithmIdentifier getQualityAlgorithmIdentifier() {
        return this.qualityAlgorithmIdentifier;
    }

    public void setQualityAlgorithmIdentifier(FingerQualityAlgorithmIdentifier qualityAlgorithmIdentifier) {
        this.qualityAlgorithmIdentifier = qualityAlgorithmIdentifier;
    }

    public String toString() {
        return "\nQualityBlock [QualityBlockRecordLength=" + this.getRecordLength() + ", qualityScore=" + this.qualityScore + ", qualityAlgorithmVendorIdentifier=" + this.qualityAlgorithmVendorIdentifier + ", qualityAlgorithmIdentifier=" + this.qualityAlgorithmIdentifier + "]\n";
    }
}

