/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.finger.FingerCertificationFlag;
import io.mosip.biometrics.util.finger.FingerFormatIdentifier;
import io.mosip.biometrics.util.finger.FingerVersionNumber;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralHeader
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralHeader.class);
    private FingerFormatIdentifier formatIdentifier;
    private FingerVersionNumber versionNumber;
    private int totalRepresentationLength;
    private int noOfRepresentations;
    private FingerCertificationFlag certificationFlag;
    private int noOfFingerPresent;

    public GeneralHeader(int totalRepresentationLength, int noOfRepresentations, int noOfFingerPresent) {
        this.setFormatIdentifier(FingerFormatIdentifier.FORMAT_FIR);
        this.setVersionNumber(FingerVersionNumber.VERSION_020);
        this.setTotalRepresentationLength(totalRepresentationLength);
        this.setNoOfRepresentations(noOfRepresentations);
        this.setCertificationFlag(FingerCertificationFlag.UNSPECIFIED);
        this.setNoOfFingerPresent(noOfFingerPresent);
    }

    public GeneralHeader(FingerFormatIdentifier formatIdentifier, FingerVersionNumber versionNumber, int totalRepresentationLength, int noOfRepresentations, FingerCertificationFlag certificationFlag, int noOfFingerPresent) {
        this.setFormatIdentifier(formatIdentifier);
        this.setVersionNumber(versionNumber);
        this.setTotalRepresentationLength(totalRepresentationLength);
        this.setNoOfRepresentations(noOfRepresentations);
        this.setCertificationFlag(certificationFlag);
        this.setNoOfFingerPresent(noOfFingerPresent);
    }

    public GeneralHeader(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setFormatIdentifier(FingerFormatIdentifier.fromValue((int)((long)inputStream.readInt() & 0xFFFFFFFFL)));
        this.setVersionNumber(FingerVersionNumber.fromValue((int)((long)inputStream.readInt() & 0xFFFFFFFFL)));
        this.setTotalRepresentationLength((int)(((long)inputStream.readInt() & 0xFFFFFFFFL) - (long)this.getRecordLength()));
        this.setNoOfRepresentations(inputStream.readUnsignedShort());
        this.setCertificationFlag(FingerCertificationFlag.fromValue(inputStream.readUnsignedByte()));
        this.setNoOfFingerPresent(inputStream.readUnsignedByte());
    }

    @Override
    public int getRecordLength() {
        return 16;
    }

    @Override
    protected void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.getFormatIdentifier().value());
        outputStream.writeInt(this.getVersionNumber().value());
        outputStream.writeInt(this.getRecordLength() + this.getTotalRepresentationLength());
        outputStream.writeShort(this.getNoOfRepresentations());
        outputStream.writeByte(this.getCertificationFlag().value());
        outputStream.writeByte(this.getNoOfFingerPresent());
        outputStream.flush();
    }

    public FingerFormatIdentifier getFormatIdentifier() {
        return this.formatIdentifier;
    }

    public void setFormatIdentifier(FingerFormatIdentifier formatIdentifier) {
        this.formatIdentifier = formatIdentifier;
    }

    public FingerVersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(FingerVersionNumber versionNumber) {
        this.versionNumber = versionNumber;
    }

    public int getTotalRepresentationLength() {
        return this.totalRepresentationLength;
    }

    public void setTotalRepresentationLength(int totalRepresentationLength) {
        this.totalRepresentationLength = totalRepresentationLength;
    }

    public int getNoOfRepresentations() {
        return this.noOfRepresentations;
    }

    public void setNoOfRepresentations(int noOfRepresentations) {
        this.noOfRepresentations = noOfRepresentations;
    }

    public FingerCertificationFlag getCertificationFlag() {
        return this.certificationFlag;
    }

    public void setCertificationFlag(FingerCertificationFlag certificationFlag) {
        this.certificationFlag = certificationFlag;
    }

    public int getNoOfFingerPresent() {
        return this.noOfFingerPresent;
    }

    public void setNoOfFingerPresent(int noOfFingerPresent) {
        this.noOfFingerPresent = noOfFingerPresent;
    }

    public String toString() {
        return "\nIrisGeneralHeader [GeneralHeaderRecordLength=" + this.getRecordLength() + ", formatIdentifier=" + this.formatIdentifier + ", versionNumber=" + this.versionNumber + ", totalRepresentationLength=" + this.totalRepresentationLength + ", noOfRepresentations=" + this.noOfRepresentations + ", certificationFlag=" + this.certificationFlag + ", noOfFingerPresent=" + this.noOfFingerPresent + "]\n";
    }
}

