/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.AbstractImageInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageData
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageData.class);
    private int imageLength;
    private byte[] image;

    public ImageData(byte[] image) {
        this.setImageLength(image.length);
        this.setImage(image);
    }

    public ImageData(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setImageLength((int)((long)inputStream.readInt() & 0xFFFFFFFFL));
        this.setImage(new byte[this.getImageLength()]);
        inputStream.readFully(this.getImage());
    }

    @Override
    public int getRecordLength() {
        return 4 + this.getImageLength();
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.getImageLength());
        if (this.getImage() != null && this.getImage().length > 0) {
            outputStream.write(this.getImage(), 0, this.getImageLength());
        }
        outputStream.flush();
    }

    public int getImageLength() {
        return this.imageLength;
    }

    public void setImageLength(int imageLength) {
        this.imageLength = imageLength;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public String toString() {
        return "\nFingerImageData [ImageDataRecordLength=" + this.getRecordLength() + ", imageLength=" + this.imageLength + "]\n";
    }
}

