/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.finger.AnnotationBlock;
import io.mosip.biometrics.util.finger.CommentBlock;
import io.mosip.biometrics.util.finger.FingerCaptureDeviceTechnology;
import io.mosip.biometrics.util.finger.FingerCaptureDeviceType;
import io.mosip.biometrics.util.finger.FingerCaptureDeviceVendor;
import io.mosip.biometrics.util.finger.FingerCertificationBlock;
import io.mosip.biometrics.util.finger.FingerCertificationFlag;
import io.mosip.biometrics.util.finger.FingerImageBitDepth;
import io.mosip.biometrics.util.finger.FingerImageCompressionType;
import io.mosip.biometrics.util.finger.FingerImpressionType;
import io.mosip.biometrics.util.finger.FingerPosition;
import io.mosip.biometrics.util.finger.FingerQualityBlock;
import io.mosip.biometrics.util.finger.FingerScaleUnitType;
import io.mosip.biometrics.util.finger.ImageData;
import io.mosip.biometrics.util.finger.RepresentationBody;
import io.mosip.biometrics.util.finger.RepresentationHeader;
import io.mosip.biometrics.util.finger.SegmentationBlock;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Representation
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(Representation.class);
    private RepresentationHeader representationHeader;
    private RepresentationBody representationBody;
    private FingerCertificationFlag certificationFlag;

    public Representation(Date captureDate, FingerQualityBlock[] qualityBlocks, FingerCertificationFlag certificationFlag, FingerCertificationBlock[] certificationBlocks, FingerPosition fingerPosition, int representationNo, FingerScaleUnitType scaleUnitType, byte[] image) {
        this.setCertificationFlag(certificationFlag);
        this.setRepresentationBody(new RepresentationBody(new ImageData(image), null, null, null));
        this.setRepresentationHeader(new RepresentationHeader(this.getRepresentationBody().getRecordLength(), captureDate, qualityBlocks, certificationFlag, certificationBlocks, fingerPosition, representationNo, scaleUnitType));
    }

    public Representation(Date captureDate, FingerCaptureDeviceTechnology captureDeviceTechnologyIdentifier, FingerCaptureDeviceVendor captureDeviceVendorIdentifier, FingerCaptureDeviceType captureDeviceTypeIdentifier, FingerQualityBlock[] qualityBlocks, FingerCertificationFlag certificationFlag, FingerCertificationBlock[] certificationBlocks, FingerPosition fingerPosition, int representationNo, FingerScaleUnitType scaleUnitType, int captureDeviceSpatialSamplingRateHorizontal, int captureDeviceSpatialSamplingRateVertical, int imageSpatialSamplingRateHorizontal, int imageSpatialSamplingRateVertical, FingerImageBitDepth bitDepth, FingerImageCompressionType compressionType, FingerImpressionType impressionType, int lineLengthHorizontal, int lineLengthVertical, byte[] image, SegmentationBlock segmentationBlock, AnnotationBlock annotationBlock, CommentBlock commentBlock) {
        this.setCertificationFlag(certificationFlag);
        this.setRepresentationBody(new RepresentationBody(new ImageData(image), segmentationBlock, annotationBlock, commentBlock));
        this.setRepresentationHeader(new RepresentationHeader(this.getRepresentationBody().getRecordLength(), captureDate, captureDeviceTechnologyIdentifier, captureDeviceVendorIdentifier, captureDeviceTypeIdentifier, qualityBlocks, certificationFlag, certificationBlocks, fingerPosition, representationNo, scaleUnitType, captureDeviceSpatialSamplingRateHorizontal, captureDeviceSpatialSamplingRateVertical, imageSpatialSamplingRateHorizontal, imageSpatialSamplingRateVertical, bitDepth, compressionType, impressionType, lineLengthHorizontal, lineLengthVertical));
        LOGGER.info(this.toString());
    }

    public Representation(DataInputStream inputStream, FingerCertificationFlag certificationFlag) throws IOException {
        this.setCertificationFlag(certificationFlag);
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setRepresentationHeader(new RepresentationHeader(inputStream, this.getCertificationFlag()));
        this.setRepresentationBody(new RepresentationBody(inputStream));
    }

    @Override
    public int getRecordLength() {
        return this.getRepresentationHeader().getRecordLength() + this.getRepresentationBody().getRecordLength();
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        this.getRepresentationHeader().writeObject(outputStream);
        this.getRepresentationBody().writeObject(outputStream);
        outputStream.flush();
    }

    public RepresentationHeader getRepresentationHeader() {
        return this.representationHeader;
    }

    public void setRepresentationHeader(RepresentationHeader representationHeader) {
        this.representationHeader = representationHeader;
    }

    public RepresentationBody getRepresentationBody() {
        return this.representationBody;
    }

    public void setRepresentationBody(RepresentationBody representationBody) {
        this.representationBody = representationBody;
    }

    public FingerCertificationFlag getCertificationFlag() {
        return this.certificationFlag;
    }

    public void setCertificationFlag(FingerCertificationFlag certificationFlag) {
        this.certificationFlag = certificationFlag;
    }

    public String toString() {
        return "\nRepresentation [RepresentationRecordLength=" + this.getRecordLength() + ", representationHeader=" + this.representationHeader + ", representationData=" + this.representationBody + "]\n";
    }
}

