/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.finger.AnnotationBlock;
import io.mosip.biometrics.util.finger.CommentBlock;
import io.mosip.biometrics.util.finger.ExtendedDataBlockIdentificationCode;
import io.mosip.biometrics.util.finger.ImageData;
import io.mosip.biometrics.util.finger.SegmentationBlock;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepresentationBody
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepresentationBody.class);
    private ImageData imageData;
    private SegmentationBlock segmentationBlock;
    private AnnotationBlock annotationBlock;
    private CommentBlock commentBlock;

    public RepresentationBody(ImageData imageData, SegmentationBlock segmentationBlock, AnnotationBlock annotationBlock, CommentBlock commentBlock) {
        this.setImageData(imageData);
        this.setSegmentationBlock(segmentationBlock);
        this.setAnnotationBlock(annotationBlock);
        this.setCommentBlock(commentBlock);
    }

    public RepresentationBody(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setImageData(new ImageData(inputStream));
        try {
            int typeIdentificationCode;
            if (inputStream.available() > 0 && ExtendedDataBlockIdentificationCode.fromValue(typeIdentificationCode = inputStream.readUnsignedShort()) == ExtendedDataBlockIdentificationCode.SEGMENTATION) {
                this.setSegmentationBlock(new SegmentationBlock(inputStream));
            }
            if (inputStream.available() > 0 && ExtendedDataBlockIdentificationCode.fromValue(typeIdentificationCode = inputStream.readUnsignedShort()) == ExtendedDataBlockIdentificationCode.ANNOTATION) {
                this.setAnnotationBlock(new AnnotationBlock(inputStream));
            }
            if (inputStream.available() > 0 && ExtendedDataBlockIdentificationCode.fromValue(typeIdentificationCode = inputStream.readUnsignedShort()) == ExtendedDataBlockIdentificationCode.COMMENT_03) {
                this.setCommentBlock(new CommentBlock(inputStream));
            }
        }
        catch (Exception ex) {
            LOGGER.error("readObject :: Error ::", (Throwable)ex);
        }
    }

    @Override
    public int getRecordLength() {
        return this.getImageData().getRecordLength() + (this.getSegmentationBlock() != null ? this.getSegmentationBlock().getRecordLength() : 0) + (this.getAnnotationBlock() != null ? this.getAnnotationBlock().getRecordLength() : 0) + (this.getCommentBlock() != null ? this.getCommentBlock().getRecordLength() : 0);
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        this.getImageData().writeObject(outputStream);
        if (this.getSegmentationBlock() != null) {
            this.getSegmentationBlock().writeObject(outputStream);
        }
        if (this.getAnnotationBlock() != null) {
            this.getAnnotationBlock().writeObject(outputStream);
        }
        if (this.getCommentBlock() != null) {
            this.getCommentBlock().writeObject(outputStream);
        }
        outputStream.flush();
    }

    public ImageData getImageData() {
        return this.imageData;
    }

    public void setImageData(ImageData imageData) {
        this.imageData = imageData;
    }

    public SegmentationBlock getSegmentationBlock() {
        return this.segmentationBlock;
    }

    public void setSegmentationBlock(SegmentationBlock segmentationBlock) {
        this.segmentationBlock = segmentationBlock;
    }

    public AnnotationBlock getAnnotationBlock() {
        return this.annotationBlock;
    }

    public void setAnnotationBlock(AnnotationBlock annotationBlock) {
        this.annotationBlock = annotationBlock;
    }

    public CommentBlock getCommentBlock() {
        return this.commentBlock;
    }

    public void setCommentBlock(CommentBlock commentBlock) {
        this.commentBlock = commentBlock;
    }

    public String toString() {
        return "RepresentationBody [RecordLength=" + this.getRecordLength() + ", imageData=" + this.imageData + ", segmentationBlock=" + this.segmentationBlock + ", annotationBlock=" + this.annotationBlock + ", commentBlock=" + this.commentBlock + "]";
    }
}

